/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.expr.VarInfo;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class FunctionInfo {
    private final QuercusContext _quercus;
    private final ClassDef _classDef;
    private final String _name;
    private final HashMap<StringValue, VarInfo> _varMap = new HashMap();
    private final ArrayList<String> _tempVarList = new ArrayList();
    private Function _fun;
    private boolean _hasThis;
    private boolean _isGlobal;
    private boolean _isClosure;
    private boolean _isConstructor;
    private boolean _isStaticClassMethod;
    private boolean _isPageMain;
    private boolean _isPageStatic;
    private boolean _isReturnsReference;
    private boolean _isVariableVar;
    private boolean _isOutUsed;
    private boolean _isVariableArgs;
    private boolean _isUsesSymbolTable;
    private boolean _isUsesGlobal;
    private boolean _isReadOnly = true;

    public FunctionInfo(QuercusContext quercus, ClassDef classDef, String name) {
        this._quercus = quercus;
        this._classDef = classDef;
        this._name = name;
    }

    public FunctionInfo copy() {
        FunctionInfo copy = this.createCopy();
        copy._varMap.putAll(this._varMap);
        copy._tempVarList.addAll(this._tempVarList);
        copy._fun = this._fun;
        copy._hasThis = this._hasThis;
        copy._isGlobal = this._isGlobal;
        copy._isClosure = this._isClosure;
        copy._isConstructor = this._isConstructor;
        copy._isPageMain = this._isPageMain;
        copy._isPageStatic = this._isPageStatic;
        copy._isReturnsReference = this._isReturnsReference;
        copy._isVariableVar = this._isVariableVar;
        copy._isOutUsed = this._isOutUsed;
        copy._isVariableArgs = this._isVariableArgs;
        copy._isUsesSymbolTable = this._isUsesSymbolTable;
        copy._isReadOnly = this._isReadOnly;
        return copy;
    }

    protected FunctionInfo createCopy() {
        return new FunctionInfo(this._quercus, this._classDef, this._name);
    }

    public QuercusContext getQuercus() {
        return this._quercus;
    }

    public String getName() {
        return this._name;
    }

    public Function getFunction() {
        return this._fun;
    }

    public void setFunction(Function fun) {
        this._fun = fun;
    }

    public boolean isGlobal() {
        return this._isGlobal;
    }

    public void setGlobal(boolean isGlobal) {
        this._isGlobal = isGlobal;
    }

    public void setClosure(boolean isClosure) {
        this._isClosure = isClosure;
    }

    public boolean isClosure() {
        return this._isClosure;
    }

    public boolean isFinal() {
        return this._fun.isFinal();
    }

    public boolean isPageMain() {
        return this._isPageMain;
    }

    public void setPageMain(boolean isPageMain) {
        this._isPageMain = isPageMain;
    }

    public boolean isPageStatic() {
        return this._isPageStatic;
    }

    public void setPageStatic(boolean isPageStatic) {
        this._isPageStatic = isPageStatic;
    }

    public void setHasThis(boolean hasThis) {
        this._hasThis = hasThis;
    }

    public boolean hasThis() {
        return this._hasThis || this._classDef != null && !this._isStaticClassMethod;
    }

    public ClassDef getDeclaringClass() {
        return this._classDef;
    }

    public boolean isMethod() {
        return this._classDef != null;
    }

    public boolean isStaticClassMethod() {
        return this._isStaticClassMethod;
    }

    public void setStaticClassMethod(boolean isStaticClassMethod) {
        this._isStaticClassMethod = isStaticClassMethod;
    }

    public boolean isConstructor() {
        return this._isConstructor;
    }

    public void setConstructor(boolean isConstructor) {
        this._isConstructor = isConstructor;
    }

    public boolean isReturnsReference() {
        return this._isReturnsReference;
    }

    public void setReturnsReference(boolean isReturnsReference) {
        this._isReturnsReference = isReturnsReference;
    }

    public boolean isVariableVar() {
        return this._isVariableVar;
    }

    public void setVariableVar(boolean isVariableVar) {
        this._isVariableVar = isVariableVar;
    }

    public boolean isVariableArgs() {
        return this._isVariableArgs;
    }

    public void setVariableArgs(boolean isVariableArgs) {
        this._isVariableArgs = isVariableArgs;
    }

    public boolean isUsesSymbolTable() {
        return this._isUsesSymbolTable;
    }

    public void setUsesSymbolTable(boolean isUsesSymbolTable) {
        this._isUsesSymbolTable = isUsesSymbolTable;
    }

    public boolean isUsesGlobal() {
        return this._isUsesGlobal;
    }

    public void setUsesGlobal(boolean isUsesGlobal) {
        this._isUsesGlobal = isUsesGlobal;
    }

    public boolean isOutUsed() {
        return this._isOutUsed;
    }

    public void setOutUsed() {
        this._isOutUsed = true;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public void setModified() {
        this._isReadOnly = false;
    }

    public VarInfo createVar(StringValue name) {
        VarInfo var = this._varMap.get(name);
        if (var == null) {
            var = this.createVarInfo(name);
            this._varMap.put(name, var);
        }
        return var;
    }

    protected VarInfo createVarInfo(StringValue name) {
        return new VarInfo(name, this);
    }

    public Collection<VarInfo> getVariables() {
        return this._varMap.values();
    }

    public void addTempVar(String name) {
        if (!this._tempVarList.contains(name)) {
            this._tempVarList.add(name);
        }
    }

    public Collection<String> getTempVariables() {
        return this._tempVarList;
    }

    public int getTempIndex() {
        return this._tempVarList.size();
    }

    public String createTempVar() {
        String name = "q_temp_" + this.getTempIndex();
        this._tempVarList.add(name);
        return name;
    }

    public String toString() {
        return "FunctionInfo[" + this._name + "]";
    }
}

