/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.statement;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.BreakValue;
import com.caucho.quercus.env.ContinueValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.statement.Statement;

public class DoStatement
extends Statement {
    protected final Expr _test;
    protected final Statement _block;
    protected final String _label;

    public DoStatement(Location location, Expr test, Statement block, String label) {
        super(location);
        this._test = test;
        this._block = block;
        this._label = label;
        block.setParent(this);
    }

    @Override
    public boolean isLoop() {
        return true;
    }

    @Override
    public Value execute(Env env) {
        try {
            do {
                int target;
                env.checkTimeout();
                Value value = this._block.execute(env);
                if (value == null) continue;
                if (value instanceof ContinueValue) {
                    ContinueValue conValue = (ContinueValue)value;
                    target = conValue.getTarget();
                    if (target <= 1) continue;
                    return new ContinueValue(target - 1);
                }
                if (value instanceof BreakValue) {
                    BreakValue breakValue = (BreakValue)value;
                    target = breakValue.getTarget();
                    if (target > 1) {
                        return new BreakValue(target - 1);
                    }
                    break;
                }
                return value;
            } while (this._test.evalBoolean(env));
        }
        catch (RuntimeException e) {
            this.rethrow(e, RuntimeException.class);
        }
        return null;
    }
}

