/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.statement;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.BreakValue;
import com.caucho.quercus.env.ContinueValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.statement.BlockStatement;
import com.caucho.quercus.statement.Statement;
import java.util.ArrayList;

public class SwitchStatement
extends Statement {
    protected final Expr _value;
    protected final Expr[][] _cases;
    protected final BlockStatement[] _blocks;
    protected final Statement _defaultBlock;
    protected final String _label;

    public SwitchStatement(Location location, Expr value, ArrayList<Expr[]> caseList, ArrayList<BlockStatement> blockList, Statement defaultBlock, String label) {
        super(location);
        this._value = value;
        this._cases = new Expr[caseList.size()][];
        caseList.toArray((T[])this._cases);
        this._blocks = new BlockStatement[blockList.size()];
        blockList.toArray(this._blocks);
        this._defaultBlock = defaultBlock;
        for (int i = 0; i < this._blocks.length; ++i) {
            this._blocks[i].setParent(this);
        }
        if (this._defaultBlock != null) {
            this._defaultBlock.setParent(this);
        }
        this._label = label;
    }

    @Override
    public Value execute(Env env) {
        try {
            Value testValue = this._value.eval(env);
            int len = this._cases.length;
            for (int i = 0; i < len; ++i) {
                Expr[] values = this._cases[i];
                for (int j = 0; j < values.length; ++j) {
                    Value caseValue = values[j].eval(env);
                    if (!testValue.eq(caseValue)) continue;
                    Value retValue = this._blocks[i].execute(env);
                    if (retValue instanceof BreakValue) {
                        BreakValue breakValue = (BreakValue)retValue;
                        int target = breakValue.getTarget();
                        if (target > 1) {
                            return new BreakValue(target - 1);
                        }
                        return null;
                    }
                    if (retValue instanceof ContinueValue) {
                        ContinueValue conValue = (ContinueValue)retValue;
                        int target = conValue.getTarget();
                        if (target > 1) {
                            return new ContinueValue(target - 1);
                        }
                        return null;
                    }
                    return retValue;
                }
            }
            if (this._defaultBlock != null) {
                Value retValue = this._defaultBlock.execute(env);
                if (retValue instanceof BreakValue) {
                    return null;
                }
                return retValue;
            }
        }
        catch (RuntimeException e) {
            this.rethrow(e, RuntimeException.class);
        }
        return null;
    }

    @Override
    public int fallThrough() {
        return 0;
    }
}

