/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.GoogleInodeService;
import com.caucho.vfs.GooglePath;
import com.caucho.vfs.GoogleWriteStream;
import com.caucho.vfs.StreamImpl;
import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.BlobstoreFailureException;
import com.google.appengine.api.blobstore.BlobstoreService;
import com.google.appengine.api.blobstore.BlobstoreServiceFactory;
import com.google.appengine.api.files.AppEngineFile;
import com.google.appengine.api.files.FileService;
import com.google.appengine.api.files.FileWriteChannel;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GoogleBlobStorePath
extends GooglePath {
    private static Logger log = Logger.getLogger(GoogleBlobStorePath.class.getName());

    private GoogleBlobStorePath(FilesystemPath root, String userPath, String path, FileService fileService, GoogleInodeService inodeService) {
        super(root, userPath, path, fileService, inodeService);
    }

    public GoogleBlobStorePath(FileService fileService, GoogleInodeService inodeService) {
        super(fileService, inodeService);
    }

    @Override
    protected GooglePath createInstance(FilesystemPath root, String userPath, String path) {
        return new GoogleBlobStorePath(root, userPath, path, this._fileService, this._inodeService);
    }

    @Override
    protected boolean removeImpl() {
        BlobstoreService service = BlobstoreServiceFactory.getBlobstoreService();
        BlobKey key = new BlobKey(this.getNativePath());
        try {
            service.delete(new BlobKey[]{key});
        }
        catch (BlobstoreFailureException e) {
            log.log(Level.FINER, e.toString(), e);
            return false;
        }
        return true;
    }

    @Override
    public AppEngineFile getAppEngineFile() {
        String path = this.getNativePath();
        AppEngineFile file = new AppEngineFile(path);
        return file;
    }

    @Override
    public String getNativePath() {
        String fullPath = this.getFullPath();
        if ("".equals(fullPath) || "/".equals(fullPath)) {
            fullPath = "/caucho-quercus-root";
        }
        return "/blobstore" + fullPath;
    }

    @Override
    public StreamImpl openWriteImpl() throws IOException {
        if (!this.getParent().isDirectory() && !this.getParent().mkdirs()) {
            throw new IOException(L.l("{0} must have a directory parent", (Object)this.getParent()));
        }
        AppEngineFile file = this.getAppEngineFile();
        boolean isLock = true;
        FileWriteChannel os = this._fileService.openWriteChannel(file, isLock);
        return new GoogleWriteStream(this, os, this.getGoogleInode());
    }
}

