/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.IoUtil;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.GoogleInode;
import com.caucho.vfs.GoogleInodeService;
import com.caucho.vfs.GoogleRandomAccessStream;
import com.caucho.vfs.GoogleReadStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.RandomAccessStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import com.google.appengine.api.files.AppEngineFile;
import com.google.appengine.api.files.FileReadChannel;
import com.google.appengine.api.files.FileService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class GooglePath
extends FilesystemPath {
    private static Logger log = Logger.getLogger(GooglePath.class.getName());
    protected static final String QUERCUS_ROOT_PATH = "caucho-quercus-root";
    protected FileService _fileService;
    protected GoogleInodeService _inodeService;
    protected GooglePath _parent;
    protected GoogleInode _inode;

    protected GooglePath(FilesystemPath root, String userPath, String path, FileService fileService, GoogleInodeService inodeService) {
        super(root, userPath, path);
        _separatorChar = GooglePath.getFileSeparatorChar();
        this._fileService = fileService;
        this._inodeService = inodeService;
    }

    protected GooglePath(FileService fileService, GoogleInodeService inodeService) {
        super(null, "/", "/");
        this._root = this;
        this._fileService = fileService;
        this._inodeService = inodeService;
        this._inode = new GoogleInode("", GoogleInode.FileType.DIRECTORY, 0L, 0L);
    }

    protected GooglePath(GooglePath path) {
        super(null, path._userPath, path._pathname);
        this._root = path == path._root ? this : path._root;
        this._fileService = path._fileService;
        this._inodeService = path._inodeService;
        if (path._inode != null) {
            this._inode = new GoogleInode(path._inode);
        }
    }

    public void init() {
        if (this.readDirMap() == null) {
            this._inode.setDirMap(new HashMap<String, GoogleInode>());
            this.writeDir(this._inode.getDirMap());
        }
    }

    @Override
    public String getFullPath() {
        String fullPath = super.getFullPath();
        int len = fullPath.length();
        if (len > 1 && fullPath.charAt(len - 1) == '/') {
            fullPath = fullPath.substring(0, len - 1);
        }
        return fullPath;
    }

    @Override
    public Path fsWalk(String userPath, Map<String, Object> attributes, String path) {
        if ("".equals(path) || "/".equals(path)) {
            return this._root;
        }
        return this.createInstance(this._root, userPath, path);
    }

    protected abstract GooglePath createInstance(FilesystemPath var1, String var2, String var3);

    @Override
    public GooglePath getParent() {
        if (this._parent == null) {
            this._parent = (GooglePath)super.getParent();
        }
        return this._parent;
    }

    private boolean isRoot() {
        return this.getTail().equals("");
    }

    @Override
    protected boolean isPathCacheable() {
        return true;
    }

    @Override
    public String getScheme() {
        return "file";
    }

    @Override
    public String getURL() {
        return GooglePath.escapeURL(this.getScheme() + ":" + this.getFullPath());
    }

    @Override
    public boolean exists() {
        GoogleInode inode = this.getGoogleInode();
        return inode != null && inode.exists();
    }

    @Override
    public int getMode() {
        int perms = 0;
        if (this.isDirectory()) {
            perms += 512;
            perms += 73;
        }
        if (this.canRead()) {
            perms += 292;
        }
        if (this.canWrite()) {
            perms += 144;
        }
        return perms;
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        GoogleInode inode = this.getGoogleInode();
        return inode != null && inode.isDirectory();
    }

    @Override
    public boolean isFile() {
        GoogleInode inode = this.getGoogleInode();
        return inode != null && inode.isFile();
    }

    @Override
    public long getLength() {
        GoogleInode inode = this.getGoogleInode();
        return inode != null ? inode.getLength() : -1L;
    }

    @Override
    public long getLastModified() {
        GoogleInode inode = this.getGoogleInode();
        if (inode == null) {
            return -1L;
        }
        return inode.getLastModified();
    }

    @Override
    public void setLastModified(long time) {
        GoogleInode inode = this.getGoogleInode();
        inode.setLastModified(time);
        this.writeInode(inode);
    }

    @Override
    public boolean canRead() {
        return this.exists();
    }

    @Override
    public boolean canWrite() {
        return this.exists();
    }

    @Override
    public String[] list() throws IOException {
        HashMap<String, GoogleInode> dir = this.getDir();
        if (dir == null) {
            return new String[0];
        }
        ArrayList<String> names = new ArrayList<String>();
        for (GoogleInode inode : dir.values()) {
            if (!inode.exists()) continue;
            names.add(inode.getName());
        }
        Object[] list = new String[names.size()];
        names.toArray(list);
        Arrays.sort(list);
        return list;
    }

    @Override
    public boolean mkdir() throws IOException {
        if (this.exists()) {
            return false;
        }
        GooglePath parent = this.getParent();
        if (((Path)parent).isFile()) {
            return false;
        }
        GoogleInode inode = new GoogleInode(this.getTail(), GoogleInode.FileType.DIRECTORY, 0L, 0L);
        this.writeInode(inode);
        return true;
    }

    @Override
    public boolean mkdirs() throws IOException {
        if (this.exists()) {
            return false;
        }
        GooglePath parent = this.getParent();
        ((Path)parent).mkdirs();
        if (!((Path)parent).isDirectory()) {
            return false;
        }
        return this.mkdir();
    }

    @Override
    public boolean remove() {
        if (!this.exists()) {
            return false;
        }
        if (this.isDirectory()) {
            try {
                if (this.list().length > 0) {
                    return false;
                }
            }
            catch (IOException e) {
                log.log(Level.FINER, e.toString(), e);
                return false;
            }
        }
        GoogleInode inode = new GoogleInode(this.getTail(), GoogleInode.FileType.NONE, -1L, -1L);
        this.getParent().updateDir(inode);
        this.removeImpl();
        return true;
    }

    protected abstract boolean removeImpl();

    @Override
    public boolean renameTo(Path path) throws IOException {
        ReadStream is = null;
        WriteStream os = null;
        TempBuffer tempBuffer = TempBuffer.allocate();
        try {
            int readLen;
            is = this.openRead();
            os = path.openWrite();
            byte[] buffer = tempBuffer.getBuffer();
            while ((readLen = is.read(buffer, 0, buffer.length)) >= 0) {
                os.write(buffer, 0, readLen);
            }
            IoUtil.close(is);
            os.close();
            this.remove();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            IoUtil.close(is);
            IoUtil.close(os);
            path.remove();
            throw e;
        }
        finally {
            TempBuffer.free(tempBuffer);
        }
    }

    @Override
    public StreamImpl openReadImpl() throws IOException {
        try {
            GoogleInode inode;
            if (!(this.isRoot() || (inode = this.getParent().getGoogleInode(this.getTail())) != null && inode.exists())) {
                throw new FileNotFoundException(this.getFullPath());
            }
            AppEngineFile file = this.getAppEngineFile();
            boolean isLock = false;
            FileReadChannel is = this._fileService.openReadChannel(file, isLock);
            return new GoogleReadStream(this, is);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            FileNotFoundException e1 = new FileNotFoundException(this.getURL() + ": " + e);
            e1.initCause(e);
            throw e1;
        }
    }

    @Override
    public RandomAccessStream openFileRandomAccess() throws IOException {
        return new GoogleRandomAccessStream(this, this.openWriteImpl());
    }

    @Override
    public Path copy() {
        return this.createInstance(this.getRoot(), this.getUserPath(), this.getPath());
    }

    private GoogleInode getGoogleInode(String name) {
        HashMap<String, GoogleInode> dirMap = this.getDir();
        GoogleInode gsInode = null;
        if (dirMap != null) {
            gsInode = dirMap.get(name);
        }
        if (gsInode == null) {
            gsInode = new GoogleInode(name, GoogleInode.FileType.NONE, -1L, -1L);
        }
        return gsInode;
    }

    private HashMap<String, GoogleInode> getDir() {
        if (!this.isDirectory()) {
            return null;
        }
        GoogleInode inode = this.getGoogleInode();
        if (inode.getDirMap() == null) {
            inode.setDirMap(this.readDirMap());
        }
        return inode.getDirMap();
    }

    HashMap<String, GoogleInode> readDirMap() {
        return this._inodeService.readDirMap(this);
    }

    void updateDir(GoogleInode inode) {
        HashMap<String, GoogleInode> map = this.readDirMap();
        if (map == null) {
            map = new HashMap();
        }
        map.put(inode.getName(), inode);
        GoogleInode dirInode = this.getGoogleInode();
        if (dirInode == null || !dirInode.exists() || !dirInode.isDirectory()) {
            dirInode = new GoogleInode(this.getTail(), GoogleInode.FileType.DIRECTORY, 0L, 0L);
            if (this.isRoot()) {
                this.setGoogleInode(dirInode);
            } else {
                this.writeInode(dirInode);
            }
        }
        dirInode.setDirMap(map);
        this.writeDir(map);
    }

    void writeDir(HashMap<String, GoogleInode> map) {
        this._inodeService.writeDirMap(this, map);
    }

    void setGoogleInode(GoogleInode inode) {
        this._inode = inode;
    }

    void writeInode(GoogleInode inode) {
        this.clearStatusCache();
        GoogleInode oldInode = this.getGoogleInode();
        if (this.isRoot()) {
            this.setGoogleInode(inode);
        } else if (oldInode == null || !oldInode.isDirectory() || !this.getParent().isDirectory()) {
            GooglePath parent = this.getParent();
            parent.updateDir(inode);
        }
    }

    GoogleInode getGoogleInode() {
        if (this._inode != null) {
            return this._inode;
        }
        return this.getParent().getGoogleInode(this.getTail());
    }

    @Override
    public void clearStatusCache() {
        GooglePath parent;
        if (this._inode != null) {
            this._inode.setDirMap(null);
        }
        if ((parent = this._parent) != null && parent != this) {
            parent.clearStatusCache();
        }
    }

    abstract AppEngineFile getAppEngineFile();

    @Override
    public int hashCode() {
        return this.getFullPath().hashCode();
    }

    @Override
    public boolean equals(Object b) {
        if (this == b) {
            return true;
        }
        if (!(b instanceof GooglePath)) {
            return false;
        }
        GooglePath file = (GooglePath)b;
        return this.getFullPath().equals(file.getFullPath());
    }

    @Override
    public String toString() {
        return this.getURL();
    }
}

