/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.GoogleInodeService;
import com.caucho.vfs.GooglePath;
import com.caucho.vfs.GoogleWriteStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.google.appengine.api.files.AppEngineFile;
import com.google.appengine.api.files.FileService;
import com.google.appengine.api.files.FileServiceFactory;
import com.google.appengine.api.files.FileWriteChannel;
import com.google.appengine.api.files.GSFileOptions;
import java.io.IOException;

public class GoogleStorePath
extends GooglePath {
    private final String _bucket;

    private GoogleStorePath(FilesystemPath root, String userPath, String path, FileService fileService, GoogleInodeService inodeService) {
        super(root, userPath, path, fileService, inodeService);
        GoogleStorePath gsRoot = (GoogleStorePath)root;
        this._bucket = gsRoot._bucket;
    }

    public GoogleStorePath() {
        this(FileServiceFactory.getFileService(), new GoogleInodeService("quercus"), null);
    }

    public GoogleStorePath(String bucket) {
        this(FileServiceFactory.getFileService(), new GoogleInodeService("quercus_" + bucket), bucket);
    }

    public GoogleStorePath(FileService fileService, GoogleInodeService inodeService, String bucket) {
        super(fileService, inodeService);
        try {
            if (bucket == null) {
                bucket = this._fileService.getDefaultGsBucketName();
            }
            this._bucket = bucket;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private GoogleStorePath(GoogleStorePath path) {
        super(path);
        this._bucket = path._bucket;
    }

    public String getBucket() {
        return this._bucket;
    }

    @Override
    public GooglePath createInstance(FilesystemPath root, String userPath, String path) {
        return new GoogleStorePath(root, userPath, path, this._fileService, this._inodeService);
    }

    @Override
    protected boolean removeImpl() {
        return true;
    }

    @Override
    public AppEngineFile getAppEngineFile() {
        String path = this.getNativePath();
        AppEngineFile file = new AppEngineFile(path);
        return file;
    }

    @Override
    public String getNativePath() {
        String fullPath = this.getFullPath();
        if ("".equals(fullPath) || "/".equals(fullPath)) {
            fullPath = "/caucho-quercus-root";
        }
        return "/gs/" + this._bucket + fullPath;
    }

    @Override
    public StreamImpl openWriteImpl() throws IOException {
        if (!this.getParent().isDirectory() && !this.getParent().mkdirs()) {
            throw new IOException(L.l("{0} must have a directory parent", (Object)this.getParent()));
        }
        GSFileOptions.GSFileOptionsBuilder builder = new GSFileOptions.GSFileOptionsBuilder();
        builder.setMimeType("application/octet-stream");
        builder.setBucket(this._bucket);
        String key = this.getFullPath();
        key = key.substring(1);
        if (key.equals("")) {
            key = "caucho-quercus-root";
        }
        builder.setKey(key);
        AppEngineFile file = this._fileService.createNewGSFile(builder.build());
        boolean isLock = true;
        FileWriteChannel os = this._fileService.openWriteChannel(file, isLock);
        return new GoogleWriteStream(this, os, this.getGoogleInode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamImpl openAppendImpl() throws IOException {
        long longLength = this.getLength();
        if (longLength > Integer.MAX_VALUE) {
            return super.openAppendImpl();
        }
        int len = (int)longLength;
        if (len <= 0) {
            return this.openWriteImpl();
        }
        byte[] buffer = new byte[len];
        ReadStream is = this.openRead();
        int totalRead = 0;
        try {
            int subLen;
            int index = 0;
            while ((subLen = is.read(buffer, index, len - totalRead)) >= 0) {
                index += subLen;
                totalRead += subLen;
            }
        }
        finally {
            is.close();
        }
        if (totalRead != len) {
            throw new IOException(L.l("expected {0} bytes but read only {0} bytes", len, totalRead));
        }
        StreamImpl stream = this.openWriteImpl();
        GoogleWriteStream os = (GoogleWriteStream)stream;
        try {
            os.write(buffer, 0, totalRead, false);
        }
        catch (IOException e) {
            os.close();
            throw e;
        }
        return os;
    }

    @Override
    public Path copy() {
        return new GoogleStorePath(this);
    }
}

