/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.LockableStream;
import com.caucho.vfs.SendfileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class RandomAccessStream
implements LockableStream {
    private static final Logger log = Logger.getLogger(RandomAccessStream.class.getName());
    private final AtomicLong _useCount = new AtomicLong(1L);
    private final AtomicBoolean _isClosed = new AtomicBoolean();

    public abstract long getLength() throws IOException;

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public abstract int read(char[] var1, int var2, int var3) throws IOException;

    public abstract int read(long var1, byte[] var3, int var4, int var5) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public abstract void write(long var1, byte[] var3, int var4, int var5) throws IOException;

    public boolean writeToStream(SendfileOutputStream os, long offset, long length, long[] blockAddresses, long blockLength) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public abstract boolean seek(long var1);

    public abstract OutputStream getOutputStream() throws IOException;

    public abstract InputStream getInputStream() throws IOException;

    public abstract int read() throws IOException;

    public abstract void write(int var1) throws IOException;

    public abstract long getFilePointer() throws IOException;

    public boolean isMmap() {
        return false;
    }

    public long getMmapAddress() throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void fsync() throws IOException {
    }

    public final boolean isOpen() {
        return this._useCount.get() > 0L;
    }

    public final long getUseCount() {
        return this._useCount.get();
    }

    public final boolean allocate() {
        long count;
        AtomicLong useCount = this._useCount;
        do {
            if ((count = useCount.get()) > 0L) continue;
            return false;
        } while (!useCount.compareAndSet(count, count + 1L));
        return true;
    }

    public final void free() {
        long value = this._useCount.decrementAndGet();
        if (value == 0L) {
            try {
                this.closeImpl();
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public final void close() {
        if (!this._isClosed.getAndSet(true)) {
            this.free();
        }
    }

    protected void closeImpl() throws IOException {
    }

    @Override
    public boolean lock(boolean shared, boolean block) {
        return true;
    }

    @Override
    public boolean unlock() {
        return true;
    }
}

