/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.inject.Module;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

@Module
public class SocketChannelStream
extends StreamImpl {
    private static final Logger log = Logger.getLogger(SocketChannelStream.class.getName());
    private static byte[] UNIX_NEWLINE = new byte[]{10};
    private SocketChannel _channel;
    private ByteBuffer _readBuffer;
    private ByteBuffer _writeBuffer;
    private boolean _needsFlush;
    private byte[] _newline = UNIX_NEWLINE;
    private boolean _throwReadInterrupts = false;
    private long _totalReadBytes;
    private long _totalWriteBytes;

    public SocketChannelStream() {
        this._readBuffer = ByteBuffer.allocateDirect(TempBuffer.SIZE);
        this._writeBuffer = ByteBuffer.allocateDirect(TempBuffer.SIZE);
    }

    public SocketChannelStream(SocketChannel channel) {
        this();
        this.init(channel);
    }

    public void init(SocketChannel channel) {
        this._channel = channel;
        this._readBuffer.clear();
        this._readBuffer.flip();
        this._needsFlush = false;
    }

    public void setThrowReadInterrupts(boolean allowThrow) {
        this._throwReadInterrupts = allowThrow;
    }

    public boolean getThrowReadInterrupts() {
        return this._throwReadInterrupts;
    }

    public void setNewline(byte[] newline) {
        this._newline = newline;
    }

    @Override
    public byte[] getNewline() {
        return this._newline;
    }

    @Override
    public boolean hasSkip() {
        return this.canRead();
    }

    @Override
    public boolean canRead() {
        return this._channel != null;
    }

    @Override
    public int read(byte[] buf, int offset, int length) throws IOException {
        try {
            if (this._channel == null) {
                return -1;
            }
            int remaining = this._readBuffer.remaining();
            if (remaining > 0) {
                this._readBuffer.get(buf, offset, remaining);
                return remaining;
            }
            this._readBuffer.clear();
            int channelRead = this._channel.read(this._readBuffer);
            this._readBuffer.flip();
            if (channelRead < 0) {
                return -1;
            }
            this._readBuffer.get(buf, offset, channelRead);
            return channelRead;
        }
        catch (InterruptedIOException e) {
            if (this._throwReadInterrupts) {
                throw e;
            }
            log.log(Level.FINEST, e.toString(), e);
        }
        catch (IOException e) {
            if (this._throwReadInterrupts) {
                throw e;
            }
            log.log(Level.FINER, e.toString(), e);
        }
        return -1;
    }

    @Override
    public int getAvailable() throws IOException {
        if (this._channel == null) {
            return -1;
        }
        return 1;
    }

    @Override
    public void close() throws IOException {
        SocketChannel channel = this._channel;
        this._channel = null;
        if (channel != null) {
            channel.close();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._channel + "]";
    }
}

