/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream;

import com.caucho.xml.stream.NamespaceBinding;
import com.caucho.xml.stream.NamespaceContextImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class NamespaceReaderContext
extends NamespaceContextImpl {
    private final HashMap<String, NamespaceBinding> _bindings = new HashMap();
    private NamespaceBinding _nullEltBinding = new NamespaceBinding(null, null, 0);
    private NamespaceBinding _nullAttrBinding = new NamespaceBinding(null, null, 0);

    @Override
    protected void remove(String prefix, String uri) {
        this._bindings.remove(prefix);
    }

    @Override
    public void declare(String prefix, String uri) {
        NamespaceBinding binding = this.getElementNamespace(prefix);
        NamespaceContextImpl.ElementBinding eltBinding = (NamespaceContextImpl.ElementBinding)this._stack.get(this._stack.size() - 1);
        if (eltBinding == null) {
            eltBinding = new NamespaceContextImpl.ElementBinding();
            this._stack.set(this._stack.size() - 1, eltBinding);
        }
        eltBinding.addOldBinding(binding, prefix, binding.getUri(), uri);
        ++this._version;
        binding.setUri(uri);
        binding.setVersion(this._version);
    }

    public String getUri(String prefix) {
        NamespaceBinding binding = this._bindings.get(prefix);
        if (binding != null) {
            return binding.getUri();
        }
        return null;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix may not be null");
        }
        NamespaceBinding binding = this._bindings.get(prefix);
        if (binding != null) {
            return binding.getUri();
        }
        String uri = null;
        if ("xml".equals(prefix)) {
            uri = "http://www.w3.org/XML/1998/namespace";
        } else if ("xmlns".equals(prefix)) {
            uri = "http://www.w3.org/2000/xmlns/";
        }
        return uri;
    }

    @Override
    public String getPrefix(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI may not be null");
        }
        if ("".equals(uri)) {
            throw new IllegalArgumentException("URI may not be empty");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(uri)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(uri)) {
            return "xmlns";
        }
        for (NamespaceBinding binding : this._bindings.values()) {
            if (!uri.equals(binding.getUri())) continue;
            return binding.getPrefix();
        }
        return null;
    }

    public Iterator getPrefixes(String uri) {
        return new PrefixIterator(uri);
    }

    public int getNumDecls() {
        NamespaceContextImpl.ElementBinding eltBinding = (NamespaceContextImpl.ElementBinding)this._stack.get(this._stack.size() - 1);
        if (eltBinding != null) {
            ArrayList<NamespaceContextImpl.Decl> oldBindingList = eltBinding.getOldBindingList();
            if (oldBindingList != null) {
                return oldBindingList.size();
            }
            return 0;
        }
        return 0;
    }

    public String getUri(int i) {
        NamespaceContextImpl.ElementBinding eltBinding = (NamespaceContextImpl.ElementBinding)this._stack.get(this._stack.size() - 1);
        if (eltBinding != null) {
            return eltBinding.getOldBindingList().get(i).getNewUri();
        }
        return null;
    }

    public String getPrefix(int i) {
        NamespaceContextImpl.ElementBinding eltBinding = (NamespaceContextImpl.ElementBinding)this._stack.get(this._stack.size() - 1);
        if (eltBinding != null) {
            return eltBinding.getOldBindingList().get(i).getPrefix();
        }
        return null;
    }

    NamespaceBinding getElementNamespace(String prefix) {
        NamespaceBinding binding = prefix == null ? this._nullEltBinding : this._bindings.get(prefix);
        if (binding != null) {
            return binding;
        }
        binding = new NamespaceBinding(prefix, null, this._version);
        this._bindings.put(prefix, binding);
        return binding;
    }

    NamespaceBinding getAttributeNamespace(String prefix) {
        NamespaceBinding binding = prefix == null || "".equals(prefix) ? this._nullAttrBinding : this._bindings.get(prefix);
        if (binding != null) {
            return binding;
        }
        binding = new NamespaceBinding(prefix, null, this._version);
        this._bindings.put(prefix, binding);
        return binding;
    }

    public void print() {
        for (NamespaceBinding binding : this._bindings.values()) {
            System.out.println(binding.toString());
        }
    }

    private class PrefixIterator
    implements Iterator {
        private String _uri;
        private String _prefix;
        private Iterator<NamespaceBinding> _iterator;

        public PrefixIterator(String uri) {
            this._uri = uri;
            this._iterator = NamespaceReaderContext.this._bindings.values().iterator();
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this._prefix != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String prefix = this._prefix;
            this.advance();
            return prefix;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() {
            this._prefix = null;
            while (this._iterator.hasNext()) {
                NamespaceBinding binding = this._iterator.next();
                if (!this._uri.equals(binding.getUri())) continue;
                this._prefix = binding.getPrefix();
                break;
            }
        }
    }
}

