/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.xpath.Env;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPath;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.NodeIterator;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class Pattern {
    protected static final Logger log = Logger.getLogger(Pattern.class.getName());
    private AbstractPattern pattern;

    Pattern(AbstractPattern pattern) {
        this.pattern = pattern;
    }

    public Node find(Node node) throws XPathException {
        if (node == null) {
            throw new NullPointerException();
        }
        Env env = XPath.createEnv();
        NodeIterator iter = this.pattern.select(node, env);
        Node value = null;
        if (iter.hasNext()) {
            value = (Node)iter.next();
        }
        XPath.freeEnv(env);
        return value;
    }

    public Node find(Node node, ExprEnvironment env) throws XPathException {
        if (node == null) {
            throw new NullPointerException();
        }
        if (env instanceof Env) {
            Env env2 = (Env)env;
        }
        NodeIterator iter = this.pattern.select(node, env);
        Node value = null;
        if (iter.hasNext()) {
            value = (Node)iter.next();
        }
        return value;
    }

    public NodeIterator select(Node node) throws XPathException {
        if (node == null) {
            throw new NullPointerException();
        }
        Env env = XPath.createEnv();
        env.setCurrentNode(node);
        NodeIterator iter = this.pattern.select(node, env);
        XPath.freeEnv(env);
        return iter;
    }

    public NodeIterator select(Node node, ExprEnvironment env) throws XPathException {
        if (node == null) {
            throw new NullPointerException();
        }
        if (env instanceof Env) {
            Env globalEnv = (Env)env;
            globalEnv.setCurrentNode(node);
            globalEnv.setContextNode(node);
        }
        return this.pattern.select(node, env);
    }

    public boolean isMatch(Node node) throws XPathException {
        Env env = XPath.createEnv();
        boolean value = this.pattern.match(node, env);
        XPath.freeEnv(env);
        return value;
    }

    public boolean isMatch(Node node, ExprEnvironment env) throws XPathException {
        return this.pattern.match(node, env);
    }

    public AbstractPattern getPattern() {
        return this.pattern;
    }

    public String toString() {
        return this.pattern.toString();
    }
}

