/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.Env;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.Axis;
import org.w3c.dom.Node;

public class FromPreviousSibling
extends Axis {
    public FromPreviousSibling(AbstractPattern parent) {
        super(parent);
        if (parent == null) {
            throw new RuntimeException();
        }
    }

    @Override
    public boolean match(Node node, ExprEnvironment env) throws XPathException {
        if (node == null) {
            return false;
        }
        for (node = node.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (!this._parent.match(node, env)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAscending() {
        return false;
    }

    @Override
    public boolean isUnique() {
        if (this._parent == null) {
            return true;
        }
        return this._parent.isSingleSelect();
    }

    @Override
    public Node firstNode(Node node, ExprEnvironment env) {
        return node.getPreviousSibling();
    }

    @Override
    public Node nextNode(Node node, Node lastNOde) {
        return node.getPreviousSibling();
    }

    @Override
    public int position(Node node, Env env, AbstractPattern pattern) throws XPathException {
        int index = env.getPositionIndex();
        int count = 1;
        while ((node = node.getNextSibling()) != null) {
            if (this._parent.match(node, env) && --index <= 0) {
                for (node = node.getNextSibling(); node != null; node = node.getNextSibling()) {
                    if (!this._parent.match(node, env)) continue;
                    env.setMorePositions(true);
                    break;
                }
                return count;
            }
            if (!pattern.match(node, env)) continue;
            ++count;
        }
        return count;
    }

    public String toString() {
        return this.getPrefix() + "preceding-sibling::";
    }
}

