/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.NodeIterator;
import org.w3c.dom.Node;

public class UniqueIterator
extends NodeIterator {
    private NodeIterator _baseIterator;
    private Node _node;
    private Node[] _oldNodes;
    private int _top;

    public UniqueIterator(ExprEnvironment env) {
        super(env);
    }

    public UniqueIterator(ExprEnvironment env, NodeIterator baseIterator) throws XPathException {
        super(env);
        this._baseIterator = baseIterator;
        this._node = baseIterator.nextNode();
        this._oldNodes = new Node[32];
    }

    @Override
    public boolean hasNext() {
        return this._node != null;
    }

    @Override
    public Node nextNode() throws XPathException {
        int i;
        Node next = this._node;
        if (next == null) {
            return null;
        }
        if (this._top == this._oldNodes.length) {
            Node[] newNodes = new Node[this._oldNodes.length * 2];
            System.arraycopy(this._oldNodes, 0, newNodes, 0, this._oldNodes.length);
            this._oldNodes = newNodes;
        }
        this._oldNodes[this._top++] = next;
        do {
            this._node = this._baseIterator.nextNode();
            if (this._node == null) {
                return next;
            }
            for (i = this._top - 1; i >= 0 && this._oldNodes[i] != this._node; --i) {
            }
        } while (i >= 0);
        return next;
    }

    @Override
    public Object clone() {
        UniqueIterator clone = new UniqueIterator(this._env);
        clone._node = this._node;
        clone._oldNodes = new Node[this._oldNodes.length];
        System.arraycopy(this._oldNodes, 0, clone._oldNodes, 0, this._oldNodes.length);
        clone._top = this._top;
        return clone;
    }
}

