/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.JAnnotation;
import com.caucho.bytecode.JAnnotationWrapper;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassLoader;
import com.caucho.bytecode.JClassLoaderWrapper;
import com.caucho.bytecode.JMethod;
import com.caucho.bytecode.JType;
import com.caucho.bytecode.JTypeWrapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class JMethodWrapper
extends JMethod {
    private JClassLoader _loader;
    private Method _method;

    public JMethodWrapper(Method method) {
        this(method, JClassLoaderWrapper.create());
    }

    public JMethodWrapper(Method method, JClassLoader loader) {
        if (loader == null) {
            throw new NullPointerException();
        }
        this._method = method;
        this._loader = loader;
    }

    @Override
    public String getName() {
        return this._method.getName();
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this._method.getModifiers());
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this._method.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this._method.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this._method.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this._method.getModifiers());
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this._method.getModifiers());
    }

    @Override
    public JClass getDeclaringClass() {
        return this._loader.forName(this._method.getDeclaringClass().getName());
    }

    @Override
    public JClass getReturnType() {
        return this._loader.forName(this._method.getReturnType().getName());
    }

    @Override
    public JType getGenericReturnType() {
        try {
            Type retType = this._method.getGenericReturnType();
            if (retType instanceof Class) {
                return this._loader.forName(((Class)retType).getName());
            }
            return new JTypeWrapper(this._loader, (ParameterizedType)retType);
        }
        catch (NoSuchMethodError e) {
            return this.getReturnType();
        }
    }

    @Override
    public JClass[] getParameterTypes() {
        Class<?>[] types = this._method.getParameterTypes();
        JClass[] jTypes = new JClass[types.length];
        for (int i = 0; i < types.length; ++i) {
            jTypes[i] = this._loader.forName(types[i].getName());
        }
        return jTypes;
    }

    @Override
    public JClass[] getExceptionTypes() {
        Class<?>[] types = this._method.getExceptionTypes();
        JClass[] jTypes = new JClass[types.length];
        for (int i = 0; i < types.length; ++i) {
            jTypes[i] = this._loader.forName(types[i].getName());
        }
        return jTypes;
    }

    @Override
    public JAnnotation[] getDeclaredAnnotations() {
        Annotation[] ann = this._method.getAnnotations();
        JAnnotation[] jAnn = new JAnnotation[ann.length];
        for (int i = 0; i < ann.length; ++i) {
            jAnn[i] = new JAnnotationWrapper(ann[i]);
        }
        return jAnn;
    }
}

