/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.Attribute;
import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.CodeAttribute;
import com.caucho.bytecode.CodeWriterAttribute;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.JAnnotation;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JMethod;
import com.caucho.bytecode.JType;
import com.caucho.bytecode.JavaAnnotation;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.JavaClassLoader;
import com.caucho.bytecode.OpaqueAttribute;
import com.caucho.bytecode.SignatureAttribute;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaMethod
extends JMethod {
    private static final Logger log = Logger.getLogger(JavaMethod.class.getName());
    private static final JClass[] NULL_CLASS = new JClass[0];
    private JavaClassLoader _loader;
    private JavaClass _jClass;
    private int _accessFlags;
    private String _name;
    private String _descriptor;
    private JClass[] _exceptions = NULL_CLASS;
    private int _line = -1;
    private ArrayList<Attribute> _attributes = new ArrayList();
    private JavaAnnotation[] _annotations;
    private boolean _isWrite;

    public JavaMethod(JavaClassLoader loader) {
        this._loader = loader;
    }

    public JavaMethod() {
    }

    public void setJavaClass(JavaClass jClass) {
        this._jClass = jClass;
    }

    public void setWrite(boolean isWrite) {
        this._isWrite = isWrite;
    }

    public void setName(String name) {
        this._name = name;
        if (this._jClass != null) {
            this._jClass.getConstantPool().addUTF8(name);
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public int getLine() {
        if (this._line >= 0) {
            return this._line;
        }
        Attribute attr = this.getAttribute("LineNumberTable");
        if (attr == null) {
            this._line = 0;
            return this._line;
        }
        this._line = 0;
        return this._line;
    }

    public JavaClassLoader getClassLoader() {
        return this._loader;
    }

    public void setAccessFlags(int flags) {
        this._accessFlags = flags;
    }

    public int getAccessFlags() {
        return this._accessFlags;
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.getAccessFlags());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.getAccessFlags());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.getAccessFlags());
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.getAccessFlags());
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.getAccessFlags());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getAccessFlags());
    }

    public void setDescriptor(String descriptor) {
        this._descriptor = descriptor;
        if (this._jClass != null) {
            this._jClass.getConstantPool().addUTF8(descriptor);
        }
    }

    public String getDescriptor() {
        return this._descriptor;
    }

    @Override
    public JClass getDeclaringClass() {
        return this._jClass;
    }

    @Override
    public JClass getReturnType() {
        String descriptor = this.getDescriptor();
        int i = descriptor.lastIndexOf(41);
        return this.getClassLoader().descriptorToClass(descriptor, i + 1);
    }

    @Override
    public JType getGenericReturnType() {
        SignatureAttribute sigAttr = (SignatureAttribute)this.getAttribute("Signature");
        if (sigAttr != null) {
            String sig = sigAttr.getSignature();
            int t = sig.lastIndexOf(41);
            return this._loader.parseParameterizedType(sig.substring(t + 1));
        }
        return this.getReturnType();
    }

    @Override
    public JClass[] getParameterTypes() {
        String descriptor = this.getDescriptor();
        ArrayList<JClass> typeList = new ArrayList<JClass>();
        int i = 0;
        while ((i = this.nextDescriptor(descriptor, i)) >= 0) {
            typeList.add(this.getClassLoader().descriptorToClass(descriptor, i));
        }
        JClass[] types = new JClass[typeList.size()];
        typeList.toArray(types);
        return types;
    }

    private int nextDescriptor(String name, int i) {
        switch (name.charAt(i)) {
            case ')': {
                return -1;
            }
            case '(': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                ++i;
                break;
            }
            case '[': {
                return this.nextDescriptor(name, i + 1);
            }
            case 'L': {
                int tail = name.indexOf(59, i);
                if (tail < 0) {
                    throw new IllegalStateException();
                }
                i = tail + 1;
                break;
            }
            default: {
                throw new UnsupportedOperationException(name.substring(i));
            }
        }
        if (name.length() <= i) {
            return -1;
        }
        if (name.charAt(i) == ')') {
            return -1;
        }
        return i;
    }

    public void setExceptionTypes(JClass[] exceptions) {
        this._exceptions = exceptions;
    }

    @Override
    public JClass[] getExceptionTypes() {
        return this._exceptions;
    }

    public void addAttribute(Attribute attr) {
        this._attributes.add(attr);
    }

    public CodeWriterAttribute createCodeWriter() {
        CodeWriterAttribute code = new CodeWriterAttribute(this._jClass);
        this._attributes.add(code);
        return code;
    }

    public Attribute removeAttribute(String name) {
        for (int i = this._attributes.size() - 1; i >= 0; --i) {
            Attribute attr = this._attributes.get(i);
            if (!attr.getName().equals(name)) continue;
            this._attributes.remove(i);
            return attr;
        }
        return null;
    }

    public ArrayList<Attribute> getAttributes() {
        return this._attributes;
    }

    public Attribute getAttribute(String name) {
        for (int i = this._attributes.size() - 1; i >= 0; --i) {
            Attribute attr = this._attributes.get(i);
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    @Override
    public JAnnotation[] getDeclaredAnnotations() {
        if (this._annotations == null) {
            Attribute attr = this.getAttribute("RuntimeVisibleAnnotations");
            if (attr instanceof OpaqueAttribute) {
                byte[] buffer = ((OpaqueAttribute)attr).getValue();
                try {
                    ByteArrayInputStream is = new ByteArrayInputStream(buffer);
                    ConstantPool cp = this._jClass.getConstantPool();
                    this._annotations = JavaAnnotation.parseAnnotations(is, cp, this.getClassLoader());
                }
                catch (IOException e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
            if (this._annotations == null) {
                this._annotations = new JavaAnnotation[0];
            }
        }
        return this._annotations;
    }

    public CodeAttribute getCode() {
        for (int i = 0; i < this._attributes.size(); ++i) {
            Attribute attr = this._attributes.get(i);
            if (!(attr instanceof CodeAttribute)) continue;
            return (CodeAttribute)attr;
        }
        return null;
    }

    public CodeAttribute createCode() {
        CodeAttribute code = new CodeAttribute();
        for (int i = 0; i < this._attributes.size(); ++i) {
            Attribute attr = this._attributes.get(i);
            if (!(attr instanceof CodeAttribute)) continue;
            return (CodeAttribute)attr;
        }
        return null;
    }

    public void write(ByteCodeWriter out) throws IOException {
        out.writeShort(this._accessFlags);
        out.writeUTF8Const(this._name);
        out.writeUTF8Const(this._descriptor);
        out.writeShort(this._attributes.size());
        for (int i = 0; i < this._attributes.size(); ++i) {
            Attribute attr = this._attributes.get(i);
            attr.write(out);
        }
    }

    public JavaMethod export(JavaClass source, JavaClass target) {
        JavaMethod method = new JavaMethod(this._loader);
        method.setName(this._name);
        method.setDescriptor(this._descriptor);
        method.setAccessFlags(this._accessFlags);
        target.getConstantPool().addUTF8(this._name);
        target.getConstantPool().addUTF8(this._descriptor);
        for (int i = 0; i < this._attributes.size(); ++i) {
            Attribute attr = this._attributes.get(i);
            method.addAttribute(attr.export(source, target));
        }
        return method;
    }

    public void concatenate(JavaMethod tail) {
        CodeAttribute codeAttr = this.getCode();
        CodeAttribute tailCodeAttr = tail.getCode();
        byte[] code = codeAttr.getCode();
        byte[] tailCode = tailCodeAttr.getCode();
        int codeLength = code.length;
        if ((code[codeLength - 1] & 0xFF) == 177) {
            --codeLength;
        }
        byte[] newCode = new byte[codeLength + tailCode.length];
        System.arraycopy(code, 0, newCode, 0, codeLength);
        System.arraycopy(tailCode, 0, newCode, codeLength, tailCode.length);
        codeAttr.setCode(newCode);
        if (codeAttr.getMaxStack() < tailCodeAttr.getMaxStack()) {
            codeAttr.setMaxStack(tailCodeAttr.getMaxStack());
        }
        if (codeAttr.getMaxLocals() < tailCodeAttr.getMaxLocals()) {
            codeAttr.setMaxLocals(tailCodeAttr.getMaxLocals());
        }
        ArrayList<CodeAttribute.ExceptionItem> exns = tailCodeAttr.getExceptions();
        for (int i = 0; i < exns.size(); ++i) {
            CodeAttribute.ExceptionItem exn = exns.get(i);
            CodeAttribute.ExceptionItem newExn = new CodeAttribute.ExceptionItem();
            newExn.setType(exn.getType());
            newExn.setStart(exn.getStart() + codeLength);
            newExn.setEnd(exn.getEnd() + codeLength);
            newExn.setHandler(exn.getHandler() + codeLength);
        }
    }

    @Override
    public String toString() {
        return "JavaMethod[" + this._name + "]";
    }
}

