/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.Names;
import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.DefaultLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.program.PropertyStringProgram;
import com.caucho.config.program.PropertyValueProgram;
import com.caucho.config.type.TypeFactory;
import com.caucho.config.xml.XmlBeanConfig;
import com.caucho.inject.Module;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.MessageDriven;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Scope;

@Module
public class BeanConfig {
    private static final L10N L = new L10N(BeanConfig.class);
    private String _filename;
    private int _line;
    private String _uri;
    private String _jndiName;
    private String _mbeanName;
    private Class<?> _beanConfigClass;
    private XmlBeanConfig _customBean;
    private InjectManager _cdiManager;
    private Class<?> _cl;
    private String _name;
    private ArrayList<Annotation> _qualifierList = new ArrayList();
    private ArrayList<Annotation> _stereotypeList = new ArrayList();
    private Class<?> _scope;
    private ArrayList<ConfigProgram> _newArgs;
    private ContainerProgram _init;
    private AnnotatedType<?> _annotatedType;
    private Annotated _extAnnotated;
    protected Bean<?> _bean;
    private boolean _isService;

    public BeanConfig() {
        this._cdiManager = InjectManager.create();
        if (this.getDefaultScope() != null) {
            this.setScope(this.getDefaultScope());
        }
        this.setService(this.isDefaultService());
    }

    public InjectManager getBeanManager() {
        return this._cdiManager;
    }

    protected String getDefaultScope() {
        return "singleton";
    }

    protected boolean isDefaultService() {
        return true;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setType(Class<?> cl) {
        this.setClass(cl);
    }

    public void setClass(Class<?> cl) {
        this._cl = cl;
        Class<?> type = this.getBeanConfigClass();
        if (type != null && !type.isAssignableFrom(cl)) {
            throw new ConfigException(L.l("'{0}' is not a valid instance of '{1}'", (Object)cl.getName(), (Object)type.getName()));
        }
    }

    public Class<?> getClassType() {
        if (this._customBean != null) {
            return this._customBean.getClassType();
        }
        return this._cl;
    }

    public Bean<?> getComponent() {
        return this._bean;
    }

    public void addBinding(Annotation binding) {
        this._qualifierList.add(binding);
    }

    public ArrayList<Annotation> getBindingList() {
        return this._qualifierList;
    }

    public ArrayList<Annotation> getStereotypeList() {
        return this._stereotypeList;
    }

    public void setScope(String scope) {
        if ("singleton".equals(scope)) {
            this._scope = javax.inject.Singleton.class;
        } else if ("dependent".equals(scope)) {
            this._scope = Dependent.class;
        } else if ("request".equals(scope)) {
            this._scope = RequestScoped.class;
        } else if ("session".equals(scope)) {
            this._scope = SessionScoped.class;
        } else if ("application".equals(scope)) {
            this._scope = ApplicationScoped.class;
        } else if ("conversation".equals(scope)) {
            this._scope = ConversationScoped.class;
        } else {
            Class<?> cl = null;
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                cl = Class.forName(scope, false, loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.setScopeType(cl);
        }
    }

    public void setScopeType(Class<?> cl) {
        if (cl == null) {
            throw new ConfigException(L.l("'{0}' is an invalid scope.  The scope must be a valid @Scope annotation."));
        }
        if (!Annotation.class.isAssignableFrom(cl)) {
            throw new ConfigException(L.l("'{0}' is an invalid scope.  The scope must be a valid @Scope annotation."));
        }
        if (!cl.isAnnotationPresent(Scope.class) && !cl.isAnnotationPresent(NormalScope.class)) {
            throw new ConfigException(L.l("'{0}' is an invalid scope.  The scope must be a valid @Scope annotation."));
        }
        this._scope = cl;
    }

    public void addParam(ConfigProgram param) {
        if (this._newArgs == null) {
            this._newArgs = new ArrayList();
        }
        this._newArgs.add(param);
    }

    public void setInit(ContainerProgram init) {
        if (this._init == null) {
            this._init = new ContainerProgram();
        }
        this._init.addProgram(init);
    }

    public void addInitProgram(ConfigProgram program) {
        if (this._init == null) {
            this._init = new ContainerProgram();
        }
        this._init.addProgram(program);
    }

    public ContainerProgram getInit() {
        return this._init;
    }

    public void addStringProperty(String name, String value) {
        if (this._init == null) {
            this._init = new ContainerProgram();
        }
        this._init.addProgram(new PropertyStringProgram(name, value));
    }

    public void addProperty(String name, Object value) {
        if (this._init == null) {
            this._init = new ContainerProgram();
        }
        this._init.addProgram(new PropertyValueProgram(name, value));
    }

    public void addOptionalStringProperty(String name, String value) {
        if (this._init == null) {
            this._init = new ContainerProgram();
        }
        this._init.addProgram(0, new PropertyStringProgram(name, value, true));
    }

    private Bean getComponentFactory() {
        return this._bean;
    }

    private boolean isService() {
        return this._isService;
    }

    public void setService(boolean isService) {
        this._isService = isService;
    }

    public void setConfigLocation(String filename, int line) {
        this._filename = filename;
        this._line = line;
    }

    public String getFilename() {
        return this._filename;
    }

    public int getLine() {
        return this._line;
    }

    public void setJndiName(String jndiName) {
        this._jndiName = jndiName;
        if (this.getName() == null) {
            this.setName(jndiName);
        }
    }

    public void setMbeanName(String mbeanName) {
        this._mbeanName = mbeanName;
    }

    public String getMBeanName() {
        return this._mbeanName;
    }

    public void setMbeanClass(Class cl) {
        this.setMbeanInterface(cl);
    }

    public void setMbeanInterface(Class<?> cl) {
    }

    public Class<?> getBeanConfigClass() {
        return this._beanConfigClass;
    }

    public void setBeanConfigClass(Class<?> cl) {
        this._beanConfigClass = cl;
    }

    public void setUri(String uri) {
        String[] props;
        String scheme;
        Class<?> beanConfigClass = this.getBeanConfigClass();
        if (beanConfigClass == null) {
            throw new ConfigException(L.l("'{0}' does not support the 'uri' attribute because its bean-config-class is undefined", (Object)this.getClass().getName()));
        }
        this._uri = uri;
        String properties = "";
        int p = uri.indexOf(58);
        if (p >= 0) {
            scheme = uri.substring(0, p);
            properties = uri.substring(p + 1);
        } else {
            scheme = uri;
        }
        TypeFactory factory = TypeFactory.create();
        this.setClass(factory.getDriverClassByUrl(beanConfigClass, uri));
        for (String prop : props = properties.split("[;]")) {
            if (prop.length() == 0) continue;
            String[] values = prop.split("[=]");
            if (values.length != 2) {
                throw new ConfigException(L.l("'{0}' is an invalid URI.  Bean URI syntax is 'scheme:prop1=value1;prop2=value2'", (Object)uri));
            }
            this.addStringProperty(values[0], values[1]);
        }
    }

    public String getUri() {
        return this._uri;
    }

    public void addCustomBean(XmlBeanConfig<?> customBean) {
        this._customBean = customBean;
    }

    protected String getTagName() {
        return "bean";
    }

    protected boolean isStartup() {
        return this._scope == javax.inject.Singleton.class;
    }

    @PostConstruct
    public void init() {
        if (this._customBean != null) {
            return;
        }
        if (this._cl == null) {
            throw new ConfigException(L.l("<{0}> requires a class attribute", (Object)this.getTagName()));
        }
        this.introspect();
        InjectManager beanManager = InjectManager.create();
        BeanBuilder<?> builder = beanManager.createBeanFactory(this._cl);
        if (builder == null) {
            return;
        }
        this._annotatedType = builder.getAnnotatedType();
        if (this._name != null && !Map.class.isAssignableFrom(this._cl)) {
            this.addOptionalStringProperty("name", this._name);
        }
        if (this.getCdiNamed() != null) {
            builder.name(this.getCdiNamed());
        }
        if (this._annotatedType.isAnnotationPresent(Singleton.class) || this._annotatedType.isAnnotationPresent(Stateful.class) || this._annotatedType.isAnnotationPresent(Stateless.class) || this._annotatedType.isAnnotationPresent(MessageDriven.class)) {
            throw new ConfigException(L.l("{0} cannot be configured by <bean> because it has an EJB annotation.  Use CDI syntax instead.", (Object)this._annotatedType));
        }
        if (this.isStartup() && !this._annotatedType.isAnnotationPresent(Stateful.class) && !this._annotatedType.isAnnotationPresent(Stateless.class) && !this._annotatedType.isAnnotationPresent(MessageDriven.class)) {
            builder.annotation((Annotation)((Object)new StartupLiteral()));
        }
        for (Annotation qualifier : this._qualifierList) {
            builder.qualifier(qualifier);
        }
        if (this._name != null) {
            builder.qualifier((Annotation)Names.create(this._name));
        }
        if (this._qualifierList.size() == 0) {
            builder.qualifier((Annotation)DefaultLiteral.DEFAULT);
        }
        for (Annotation stereotype : this._stereotypeList) {
            builder.stereotype(stereotype.annotationType());
        }
        if (this._scope != null) {
            builder.scope(this._scope);
        }
        if (javax.inject.Singleton.class == this._scope) {
            builder.annotation((Annotation)((Object)new StartupLiteral()));
        }
        builder.annotation(this._cdiManager.generateXmlCookie());
        if (this._init != null) {
            builder.init(this._init);
        }
        this._bean = builder.bean();
        this._extAnnotated = builder.getExtendedAnnotated();
        this.introspectPostInit();
        this.deploy();
        try {
            if (this._bean != null && this._jndiName != null) {
                Jndi.bindDeepShort(this._jndiName, this._bean);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    protected String getCdiNamed() {
        return this._name;
    }

    protected void introspectPostInit() {
    }

    protected void deploy() {
        if (this._bean != null) {
            this.getBeanManager().addBeanDiscover(this._bean, this._extAnnotated);
        }
    }

    public Object getObject() {
        if (this._bean != null) {
            CreationalContext<?> env = this._cdiManager.createCreationalContext(this._bean);
            Object value = this._cdiManager.getReference(this._bean, this._bean.getBeanClass(), env);
            return value;
        }
        return null;
    }

    public Object createObjectNoInit() {
        if (this._bean != null) {
            CreationalContext<?> env = this._cdiManager.createCreationalContext(this._bean);
            return this._cdiManager.getReference(this._bean, (Type)null, env);
        }
        return null;
    }

    private void introspect() {
        if (this._scope == null) {
            for (Annotation ann : this._cl.getDeclaredAnnotations()) {
                if (!ann.annotationType().isAnnotationPresent(Scope.class) && !ann.annotationType().isAnnotationPresent(NormalScope.class)) continue;
                if (this._scope != null) {
                    throw new ConfigException(L.l("{0}: multiple scope annotations are forbidden ({1} and {2}).", (Object)this._cl.getName(), (Object)this._scope.getSimpleName(), (Object)ann.annotationType().getSimpleName()));
                }
                this._scope = ann.annotationType();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._cl + "]";
    }

    static class StartupLiteral
    extends AnnotationLiteral<Startup>
    implements Startup {
        StartupLiteral() {
        }
    }
}

