/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.event;

import com.caucho.config.event.ObserverMethodImpl;
import com.caucho.config.inject.InjectManager;
import com.caucho.transaction.TransactionImpl;
import com.caucho.transaction.TransactionManagerImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.transaction.Synchronization;

public class ObserverMethodAfterCompletionImpl<X, T>
extends ObserverMethodImpl<X, T> {
    private static final Logger log = Logger.getLogger(ObserverMethodAfterCompletionImpl.class.getName());
    private TransactionManagerImpl _tm = TransactionManagerImpl.getInstance();

    public ObserverMethodAfterCompletionImpl(InjectManager beanManager, Bean<X> bean, AnnotatedMethod<X> method, Type type, Set<Annotation> qualifiers) {
        super(beanManager, bean, method, type, qualifiers);
    }

    @Override
    public void notify(T event) {
        TransactionImpl xa = this._tm.getCurrent();
        try {
            if (xa != null && xa.isActive()) {
                xa.registerSynchronization(new AfterCompletion(event));
            } else {
                this.notifyImpl(event);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    class AfterCompletion
    implements Synchronization {
        private T _event;

        AfterCompletion(T event) {
            this._event = event;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            ObserverMethodAfterCompletionImpl.this.notifyImpl(this._event);
        }
    }
}

