/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.inject.InjectManager;
import com.caucho.inject.Module;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.TypeLiteral;

@Module
public final class InstanceImpl<T>
implements Instance<T>,
Serializable {
    private transient InjectManager _cdiManager;
    private Type _type;
    private Annotation[] _qualifiers;
    private transient long _version;
    private transient Set<Bean<?>> _beanSet;
    private transient InjectManager.ReferenceFactory<T> _factory;
    private transient InjectionPoint _injectionPoint;

    InstanceImpl(InjectManager beanManager, Type type, Annotation[] bindings, InjectionPoint injectionPoint) {
        this._cdiManager = beanManager;
        this._type = type;
        this._qualifiers = bindings;
        this._beanSet = beanManager.getBeans(type, bindings);
        this._version = beanManager.getVersion();
        this._injectionPoint = injectionPoint;
    }

    public T get() {
        if (this._factory == null) {
            Bean bean = this._cdiManager.resolve(this._beanSet);
            if (bean != null) {
                this._factory = this._cdiManager.getReferenceFactory(bean);
            } else {
                throw this._cdiManager.unsatisfiedException(this._type, this._qualifiers);
            }
        }
        if (this._factory != null) {
            return this._factory.create(null, null, this._injectionPoint);
        }
        return null;
    }

    public Instance<T> select(Annotation ... bindings) {
        return new InstanceImpl<T>(this._cdiManager, this._type, bindings, this._injectionPoint);
    }

    public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... bindings) {
        if (bindings == null || bindings.length == 0) {
            bindings = this._qualifiers;
        }
        return new InstanceImpl<T>(this._cdiManager, subtype, bindings, this._injectionPoint);
    }

    public <U extends T> Instance<U> select(TypeLiteral<U> subtype, Annotation ... bindings) {
        return new InstanceImpl<T>(this._cdiManager, subtype.getType(), bindings, this._injectionPoint);
    }

    public Iterator<T> iterator() {
        return new InstanceIterator(this._cdiManager, this.getBeanSet().iterator());
    }

    public boolean isAmbiguous() {
        return this.getBeanSet().size() > 1;
    }

    public boolean isUnsatisfied() {
        return this.getBeanSet().size() == 0;
    }

    private Set<Bean<?>> getBeanSet() {
        if (this._version != this._cdiManager.getVersion()) {
            this._beanSet = this._cdiManager.getBeans(this._type, this._qualifiers);
            this._version = this._cdiManager.getVersion();
        }
        return this._beanSet;
    }

    private Object readResolve() {
        return new InstanceImpl<T>(InjectManager.create(), this._type, this._qualifiers, this._injectionPoint);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._type + "]";
    }

    static class InstanceIterator<T>
    implements Iterator<T> {
        private final BeanManager _manager;
        private final Iterator<Bean<T>> _beanIter;

        InstanceIterator(BeanManager manager, Iterator<Bean<T>> beanIter) {
            this._manager = manager;
            this._beanIter = beanIter;
        }

        @Override
        public boolean hasNext() {
            return this._beanIter.hasNext();
        }

        @Override
        public T next() {
            Bean<T> bean = this._beanIter.next();
            CreationalContext env = this._manager.createCreationalContext(bean);
            return (T)this._manager.getReference(bean, (Type)bean.getBeanClass(), env);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

