/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.meter;

import com.caucho.env.meter.AbstractMeter;
import com.caucho.env.meter.ActiveSensor;
import java.util.concurrent.atomic.AtomicLong;

public final class ActiveMeter
extends AbstractMeter
implements ActiveSensor {
    private final AtomicLong _activeCount = new AtomicLong();
    private final AtomicLong _activeCountMax = new AtomicLong();
    private final AtomicLong _totalCount = new AtomicLong();
    private long _lastTotal;
    private long _delta;

    public ActiveMeter(String name) {
        super(name);
    }

    @Override
    public final void start() {
        long max;
        long activeCount = this._activeCount.incrementAndGet();
        this._totalCount.incrementAndGet();
        while ((max = this._activeCountMax.get()) < activeCount && !this._activeCountMax.compareAndSet(max, activeCount)) {
        }
    }

    @Override
    public final void end() {
        this._activeCount.decrementAndGet();
    }

    public AbstractMeter createMax(String name) {
        return new MaxProbe(name);
    }

    public final double sampleActive() {
        return this._activeCount.get();
    }

    public final double sampleMax() {
        return this._activeCountMax.getAndSet(this._activeCount.get());
    }

    @Override
    public final void sample() {
        long totalCount = this._totalCount.get();
        this._delta = totalCount - this._lastTotal;
        this._lastTotal = totalCount;
    }

    @Override
    public final double calculate() {
        return this._delta;
    }

    class MaxProbe
    extends AbstractMeter {
        private double _max;

        MaxProbe(String name) {
            super(name);
        }

        @Override
        public void sample() {
            this._max = ActiveMeter.this.sampleMax();
        }

        @Override
        public double calculate() {
            return this._max;
        }
    }
}

