/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.java.AbstractJavaCompiler;
import com.caucho.java.ErrorParser;
import com.caucho.java.LineMap;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharCursor;
import com.caucho.util.L10N;
import com.caucho.util.StringCharCursor;
import com.caucho.vfs.ByteToChar;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

class JavacErrorParser
extends ErrorParser {
    private static final L10N L = new L10N(JavacErrorParser.class);
    private static final Logger log = Logger.getLogger(JavacErrorParser.class.getName());
    private CharBuffer _token = new CharBuffer();
    private CharBuffer _buf = new CharBuffer();
    private ByteToChar _lineBuf = ByteToChar.create();
    private AbstractJavaCompiler _compiler;
    private String _file;
    private String _encoding;

    public JavacErrorParser() throws UnsupportedEncodingException {
        this(null, null, null);
    }

    public JavacErrorParser(AbstractJavaCompiler compiler, String file, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        this._compiler = compiler;
        this._file = file;
        this._encoding = encoding;
        this._lineBuf.setEncoding(encoding);
    }

    @Override
    String parseErrors(InputStream is, LineMap lineMap) throws IOException {
        CharBuffer result = new CharBuffer();
        int ch = is.read();
        while (ch >= 0) {
            try {
                this._lineBuf.clear();
                while (ch >= 0 && ch != 10) {
                    try {
                        this._lineBuf.addByte((byte)ch);
                    }
                    catch (Exception e) {
                        log.log(Level.FINER, e.toString(), e);
                        log.warning(L.l("{0}: javac error parsing encoding error detected while parsing Javac output.  The javac error encoding appears to be different from Resin's configured encoding '{1}'\n  {2}", (Object)this._file, (Object)this._encoding, (Object)e.toString()));
                    }
                    ch = is.read();
                }
                this._lineBuf.addByte(10);
                String lineString = this._lineBuf.getConvertedString();
                StringCharCursor cursor = new StringCharCursor(lineString);
                String line = this.parseLine(cursor, lineMap);
                if (line == null) {
                    result.append(lineString);
                } else {
                    result.append(line);
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
                result.append(e).append("\n");
            }
            ch = is.read();
        }
        return result.toString();
    }

    String parseLine(CharCursor is, LineMap lineMap) throws IOException {
        char ch = is.read();
        this._buf.clear();
        String filename = null;
        int line = 0;
        this._token.clear();
        block0: while (true) {
            if (ch == '\uffff') break;
            while (ch == ':') {
                line = 0;
                ch = is.read();
                while (ch >= '0' && ch <= '9') {
                    line = 10 * line + ch - 48;
                    ch = is.read();
                }
                if (ch == ':' && line > 0) {
                    filename = this._token.toString();
                    break block0;
                }
                this._token.append(':');
                if (line <= 0) continue;
                this._token.append(line);
            }
            if (ch != '\uffff') {
                this._token.append(ch);
            }
            ch = is.read();
        }
        if (filename == null) {
            return null;
        }
        boolean column = false;
        while (true) {
            if (ch == '\uffff' || ch == ' ') break;
            ch = is.read();
        }
        while (ch == ' ') {
            ch = is.read();
        }
        this._buf.clear();
        while (true) {
            if (ch == '\uffff') break;
            this._buf.append(ch);
            ch = is.read();
        }
        String message = this._buf.toString();
        if (lineMap != null) {
            return lineMap.convertError(filename, line, 0, message);
        }
        return filename + ":" + line + ": " + message;
    }
}

