/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.env.actor.AbstractActorProcessor;
import com.caucho.env.actor2.ActorQueue2;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public abstract class AbstractLogHandler
extends Handler {
    private final ActorQueue2<LogRecord> _logQueue = new ActorQueue2<LogRecord>(256, new LogQueue());
    private Filter _filter;

    @Override
    public void setFilter(Filter filter) {
        this._filter = filter;
    }

    @Override
    public Filter getFilter() {
        return this._filter;
    }

    @Override
    public final void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        Filter filter = this.getFilter();
        if (filter != null && !filter.isLoggable(record)) {
            return;
        }
        if (record == null) {
            System.out.println(this + ": no record");
            return;
        }
        this.processPublish(record);
        this.processFlush();
    }

    private void waitForEmpty() {
        this._logQueue.wake();
        for (int i = 0; i < 20 && !this._logQueue.isEmpty(); ++i) {
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected abstract void processPublish(LogRecord var1);

    protected abstract void processFlush();

    protected void printMessage(WriteStream os, String message, Object[] parameters) throws IOException {
        if (parameters == null || parameters.length == 0) {
            os.println(message);
        } else {
            os.println(L10N.fillMessage(message, parameters));
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    private class LogQueue
    extends AbstractActorProcessor<LogRecord> {
        private LogQueue() {
        }

        @Override
        public String getThreadName() {
            Thread thread = Thread.currentThread();
            return this.getClass().getSimpleName() + "-" + thread.getId();
        }

        @Override
        public void process(LogRecord value) throws Exception {
            AbstractLogHandler.this.processPublish(value);
        }

        @Override
        public void onProcessComplete() throws Exception {
            AbstractLogHandler.this.processFlush();
        }
    }
}

