/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ArgGetValue;
import com.caucho.quercus.env.ArgValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;

public class ArgGetFieldValue
extends ArgValue {
    private final Env _env;
    private final Value _obj;
    private final StringValue _name;

    public ArgGetFieldValue(Env env, Value obj, StringValue name) {
        this._env = env;
        this._obj = obj;
        this._name = name;
    }

    @Override
    public Value getArg(Value name, boolean isTop) {
        return new ArgGetValue(this, name);
    }

    @Override
    public Value getFieldArg(Env env, StringValue name, boolean isTop) {
        return new ArgGetFieldValue(env, this, name);
    }

    @Override
    public Var toLocalVarDeclAsRef() {
        return this._obj.toAutoObject(this._env).getFieldVar(this._env, this._name).toLocalVarDeclAsRef();
    }

    @Override
    public Value toValue() {
        return this._obj.getField(this._env, this._name);
    }

    @Override
    public Value toLocalValueReadOnly() {
        return this.toValue();
    }

    @Override
    public Value toLocalValue() {
        return this.toValue();
    }

    @Override
    public Value toLocalRef() {
        return this._obj.getField(this._env, this._name);
    }

    @Override
    public Value toAutoArray() {
        Value parent = this._obj.toAutoObject(this._env);
        Value value = parent.getField(this._env, this._name);
        Value array = value.toAutoArray();
        if (array != value) {
            parent.putField(this._env, this._name, array);
            value = array;
        }
        return value;
    }

    @Override
    public Value toAutoObject(Env env) {
        Value parent = this._obj.toAutoObject(env);
        Value value = parent.getField(env, this._name);
        if (value.isNull()) {
            value = env.createObject();
            parent.putField(env, this._name, value);
        } else {
            Value obj = value.toAutoObject(env);
            if (obj != value) {
                parent.putField(env, this._name, obj);
            }
            value = obj;
        }
        return value;
    }

    @Override
    public Value toRefValue() {
        return this._obj.getFieldVar(this._env, this._name);
    }

    @Override
    public Var toVar() {
        return new Var(this.toValue());
    }

    @Override
    public Var getVar(Value index) {
        return this._obj.getFieldArray(this._env, this._name).getVar(index);
    }

    @Override
    public Var getFieldVar(Env env, StringValue name) {
        return this._obj.getFieldObject(this._env, this._name).getFieldVar(this._env, name);
    }

    @Override
    public StringValue toStringValue() {
        return this.toValue().toStringValue();
    }

    @Override
    public String toJavaString() {
        return this.toValue().toJavaString();
    }
}

