/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.java.WorkDir;
import com.caucho.quercus.Location;
import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.QuercusDieException;
import com.caucho.quercus.QuercusErrorException;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.QuercusExitException;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BinaryBuilderValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.CallbackFunction;
import com.caucho.quercus.env.Closure;
import com.caucho.quercus.env.ConnectionEntry;
import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.EnvCleanup;
import com.caucho.quercus.env.EnvVar;
import com.caucho.quercus.env.EnvVarImpl;
import com.caucho.quercus.env.GlobalArrayValue;
import com.caucho.quercus.env.ImportMap;
import com.caucho.quercus.env.InternalAutoloadCallback;
import com.caucho.quercus.env.LargeStringBuilderValue;
import com.caucho.quercus.env.LazyEnvVar;
import com.caucho.quercus.env.LazyStaticMap;
import com.caucho.quercus.env.LazySymbolMap;
import com.caucho.quercus.env.LocaleInfo;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullThisValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.OutputBuffer;
import com.caucho.quercus.env.Post;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.QuercusLanguageException;
import com.caucho.quercus.env.SaveState;
import com.caucho.quercus.env.ServerArrayValue;
import com.caucho.quercus.env.SessionArrayValue;
import com.caucho.quercus.env.SessionCallback;
import com.caucho.quercus.env.SessionVar;
import com.caucho.quercus.env.Shutdown;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnexpectedValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.UnicodeValueImpl;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.lib.ErrorModule;
import com.caucho.quercus.lib.VariableModule;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.quercus.lib.file.PhpProtocolWrapper;
import com.caucho.quercus.lib.file.PhpStderr;
import com.caucho.quercus.lib.file.PhpStdin;
import com.caucho.quercus.lib.file.PhpStdout;
import com.caucho.quercus.lib.file.ProtocolWrapper;
import com.caucho.quercus.lib.file.ZlibProtocolWrapper;
import com.caucho.quercus.lib.regexp.RegexpState;
import com.caucho.quercus.lib.string.StringModule;
import com.caucho.quercus.lib.string.StringUtility;
import com.caucho.quercus.module.IniDefinition;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.quercus.module.ModuleStartupListener;
import com.caucho.quercus.page.QuercusPage;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.quercus.program.QuercusProgram;
import com.caucho.quercus.program.UndefinedFunction;
import com.caucho.quercus.resources.StreamContextResource;
import com.caucho.quercus.servlet.api.QuercusCookie;
import com.caucho.quercus.servlet.api.QuercusHttpServletRequest;
import com.caucho.quercus.servlet.api.QuercusHttpServletResponse;
import com.caucho.quercus.servlet.api.QuercusHttpSession;
import com.caucho.quercus.servlet.api.QuercusServletContext;
import com.caucho.util.CharBuffer;
import com.caucho.util.FreeList;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.util.QDate;
import com.caucho.vfs.ByteToChar;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.MemoryPath;
import com.caucho.vfs.NullPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import com.caucho.vfs.i18n.EncodingReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.sql.DataSource;

public class Env {
    private static final L10N L = new L10N(Env.class);
    private static final Logger log = Logger.getLogger(Env.class.getName());
    public static final int B_ERROR = 0;
    public static final int B_WARNING = 1;
    public static final int B_PARSE = 2;
    public static final int B_NOTICE = 3;
    public static final int B_CORE_ERROR = 4;
    public static final int B_CORE_WARNING = 5;
    public static final int B_COMPILE_ERROR = 6;
    public static final int B_COMPILE_WARNING = 7;
    public static final int B_USER_ERROR = 8;
    public static final int B_USER_WARNING = 9;
    public static final int B_USER_NOTICE = 10;
    public static final int B_STRICT = 11;
    public static final int B_RECOVERABLE_ERROR = 12;
    public static final int B_DEPRECATED = 13;
    public static final int B_USER_DEPRECATED = 14;
    public static final int B_LAST = 12;
    public static final int E_ERROR = 1;
    public static final int E_WARNING = 2;
    public static final int E_PARSE = 4;
    public static final int E_NOTICE = 8;
    public static final int E_CORE_ERROR = 16;
    public static final int E_CORE_WARNING = 32;
    public static final int E_COMPILE_ERROR = 64;
    public static final int E_COMPILE_WARNING = 128;
    public static final int E_USER_ERROR = 256;
    public static final int E_USER_WARNING = 512;
    public static final int E_USER_NOTICE = 1024;
    public static final int E_ALL = Short.MAX_VALUE;
    public static final int E_STRICT = 2048;
    public static final int E_RECOVERABLE_ERROR = 4096;
    public static final int E_DEPRECATED = 8192;
    public static final int E_USER_DEPRECATED = 16384;
    public static final int E_DEFAULT = 32759;
    private static final int _SERVER = 1;
    private static final int _GET = 2;
    private static final int _POST = 3;
    private static final int _COOKIE = 4;
    private static final int _GLOBAL = 5;
    private static final int _REQUEST = 6;
    private static final int _SESSION = 7;
    private static final int HTTP_GET_VARS = 8;
    private static final int HTTP_POST_VARS = 9;
    private static final int HTTP_COOKIE_VARS = 10;
    private static final int PHP_SELF = 11;
    private static final int _FILES = 12;
    private static final int HTTP_POST_FILES = 13;
    private static final int _ENV = 14;
    private static final int HTTP_SERVER_VARS = 15;
    private static final int HTTP_RAW_POST_DATA = 16;
    private static final int ARGC = 17;
    private static final int ARGV = 18;
    private static final IntMap SPECIAL_VARS = new IntMap();
    private static final IntMap SPECIAL_VARS_U = new IntMap();
    private static final StringValue PHP_SELF_STRING = new ConstStringValue("PHP_SELF");
    private static final StringValue PHP_SELF_STRING_U = new UnicodeBuilderValue("PHP_SELF");
    private static final StringValue S_GET = new ConstStringValue("_GET");
    private static final StringValue S_GET_U = new UnicodeBuilderValue("_GET");
    private static final StringValue S_POST = new ConstStringValue("_POST");
    private static final StringValue S_POST_U = new UnicodeBuilderValue("_POST");
    private static final StringValue S_SESSION = new ConstStringValue("_SESSION");
    private static final StringValue S_SESSION_U = new UnicodeBuilderValue("_SESSION");
    private static final StringValue S_SERVER = new ConstStringValue("_SERVER");
    private static final StringValue S_SERVER_U = new UnicodeBuilderValue("_SERVER");
    private static final StringValue S_COOKIE = new ConstStringValue("_COOKIE");
    private static final StringValue S_COOKIE_U = new UnicodeBuilderValue("_COOKIE");
    private static final StringValue S_FILES = new ConstStringValue("_FILES");
    private static final StringValue S_FILES_U = new UnicodeBuilderValue("_FILES");
    private static final StringValue S_ARGV = new ConstStringValue("argv");
    private static final StringValue S_ARGV_U = new UnicodeBuilderValue("argv");
    public static final Value[] EMPTY_VALUE = new Value[0];
    private static ThreadLocal<Env> _threadEnv = new ThreadLocal();
    private static final FreeList<AbstractFunction[]> _freeFunList = new FreeList(256);
    private static final FreeList<ClassDef[]> _freeClassDefList = new FreeList(256);
    private static final FreeList<QuercusClass[]> _freeClassList = new FreeList(256);
    private static final FreeList<Value[]> _freeConstList = new FreeList(256);
    private static final FreeList<QDate> _freeGmtDateList = new FreeList(256);
    private static final FreeList<QDate> _freeLocalDateList = new FreeList(256);
    private static final LruCache<String, StringValue> _internStringMap = new LruCache(4096);
    protected final QuercusContext _quercus;
    private QuercusPage _page;
    private HashMap<String, Value> _scriptGlobalMap = new HashMap(16);
    public AbstractFunction[] _fun;
    public HashMap<StringValue, AbstractFunction> _anonymousFunMap;
    public ClassDef[] _classDef;
    public QuercusClass[] _qClass;
    public HashMap<String, QuercusClass> _classAliasMap;
    public Value[] _const;
    private Map<StringValue, EnvVar> _globalMap = new HashMap<StringValue, EnvVar>();
    private EnvVar[] _globalList;
    private Map<StringValue, Var> _staticMap = new HashMap<StringValue, Var>();
    private Map<StringValue, EnvVar> _map = this._globalMap;
    private HashMap<String, Value> _iniMap;
    private HashMap<String, Object> _specialMap = new HashMap();
    private HashSet<String> _initializedClassSet = new HashSet();
    private int _iniCount = 1;
    private ArrayList<EnvCleanup> _cleanupList;
    private ArrayList<ObjectValue> _objCleanupList;
    private ArrayList<Shutdown> _shutdownList;
    private String _defaultIncludePath;
    private String _includePath;
    private int _includePathIniCount;
    private ArrayList<String> _includePathList;
    private HashMap<Path, ArrayList<Path>> _includePathMap;
    private HashMap<Path, QuercusPage> _includeMap = new HashMap();
    private Value _this = NullThisValue.NULL;
    private Closure _closure;
    private final boolean _isUnicodeSemantics;
    private boolean _isAllowUrlInclude;
    private boolean _isAllowUrlFopen;
    private HashMap<StringValue, Path> _lookupCache = new HashMap();
    private HashMap<ConnectionEntry, ConnectionEntry> _connMap = new HashMap();
    private AbstractFunction _autoload;
    private HashSet<String> _autoloadClasses = new HashSet();
    private ArrayList<Callable> _autoloadList;
    private InternalAutoloadCallback _internalAutoload;
    private Location _location;
    private long _startTime;
    private long _timeLimit = 600000L;
    private long _endTime;
    private Expr[] _callStack;
    private Value[] _callThisStack;
    private Value[][] _callArgStack;
    private int _callStackTop;
    private QuercusClass _callingClass;
    private Value[] _functionArgs;
    private LinkedList<FieldGetEntry> _fieldGetList = new LinkedList();
    private LinkedList<FieldGetEntry> _fieldSetList = new LinkedList();
    private LinkedList<FieldGetEntry> _issetList = new LinkedList();
    private LinkedList<FieldGetEntry> _unsetList = new LinkedList();
    private Path _selfPath;
    private Path _selfDirectory;
    private Path _pwd;
    private Path _uploadPath;
    private Path _tmpPath;
    private ArrayList<Path> _removePaths;
    private final boolean _isStrict;
    private QuercusHttpServletRequest _request;
    private QuercusHttpServletResponse _response;
    private ArrayValue _inputGet;
    private ArrayValue _inputCookie;
    private ArrayValue _inputEnv;
    private ArrayValue _inputServer;
    private ArrayValue _inputPost = new ArrayValueImpl();
    private ArrayValue _files = new ArrayValueImpl();
    private StringValue _inputData;
    private SessionArrayValue _session;
    private QuercusHttpSession _javaSession;
    private ScriptContext _scriptContext;
    private WriteStream _originalOut;
    private OutputBuffer _outputBuffer;
    private WriteStream _out;
    private LocaleInfo _locale;
    private Callable[] _prevErrorHandlers = new Callback[13];
    private Callable[] _errorHandlers = new Callback[13];
    private Callable _prevExceptionHandler;
    private Callable _exceptionHandler;
    private SessionCallback _sessionCallback;
    private StreamContextResource _defaultStreamContext;
    private HashMap<StringValue, ProtocolWrapper> _wrappedStreamMap;
    private HashMap<StringValue, ProtocolWrapper> _unregisteredWrappedStreamMap;
    private int _objectId = 0;
    private Logger _logger;
    private ImportMap _importMap;
    private TimeZone _defaultTimeZone;
    private QDate _localDate;
    private QDate _gmtDate;
    private Object _gzStream;
    private Env _oldThreadEnv;
    private boolean _isTimeout;
    private long _firstMicroTime;
    private long _firstNanoTime;
    private RegexpState _freeRegexpState;
    private Object _duplex;
    private StringValue _variablesOrder;
    private int[] _querySeparatorMap;
    public static final int[] DEFAULT_QUERY_SEPARATOR_MAP;
    private CharBuffer _cb = new CharBuffer();
    private int _lastErrorType = -1;
    private String _lastErrorMessage = null;
    private Location _lastErrorLocation = null;

    public Env(QuercusContext quercus, QuercusPage page, WriteStream out, QuercusHttpServletRequest request, QuercusHttpServletResponse response) {
        this._quercus = quercus;
        this._isStrict = quercus.isStrict();
        this._isUnicodeSemantics = quercus.isUnicodeSemantics();
        this._isAllowUrlInclude = quercus.isAllowUrlInclude();
        this._isAllowUrlFopen = quercus.isAllowUrlFopen();
        this._variablesOrder = this._quercus.getIniValue("variables_order").toStringValue(this);
        StringValue querySeparators = this._quercus.getIniValue("arg_separator.input").toStringValue(this);
        int len = querySeparators.length();
        if (len == 0) {
            this._querySeparatorMap = DEFAULT_QUERY_SEPARATOR_MAP;
        } else {
            this._querySeparatorMap = new int[128];
            for (int i = 0; i < len; ++i) {
                char ch = querySeparators.charAt(i);
                this._querySeparatorMap[ch] = 1;
            }
        }
        this._page = page;
        AbstractFunction[] defFuns = this.getDefaultFunctionMap();
        this._fun = _freeFunList.allocate();
        if (this._fun == null || this._fun.length < defFuns.length) {
            this._fun = new AbstractFunction[defFuns.length];
        }
        System.arraycopy(defFuns, 0, this._fun, 0, defFuns.length);
        ClassDef[] defClasses = quercus.getClassDefMap();
        this._classDef = _freeClassDefList.allocate();
        if (this._classDef == null || this._classDef.length < defClasses.length) {
            this._classDef = new ClassDef[defClasses.length];
        }
        this._qClass = _freeClassList.allocate();
        if (this._qClass == null || this._qClass.length < defClasses.length) {
            this._qClass = new QuercusClass[defClasses.length];
        }
        Value[] defConst = quercus.getConstantMap();
        this._const = _freeConstList.allocate();
        if (this._const == null || this._const.length < defConst.length) {
            this._const = new Value[defConst.length];
        }
        System.arraycopy(defConst, 0, this._const, 0, defConst.length);
        this._originalOut = out;
        this._out = out;
        this._request = request;
        this._response = response;
        if (page != null) {
            this.pageInit(page);
        }
        if (request != null && page != null) {
            this.setPwd(page.getPwd(null));
        } else {
            this.setPwd(this._quercus.getPwd());
        }
        if (this._page != null) {
            this.setSelfPath(this._page.getSelfPath(null));
            this._includeMap.put(this._selfPath, this._page);
        }
        this._internalAutoload = new InternalAutoloadCallback("com/caucho/quercus/php/");
        String version = quercus.getPhpVersion();
        this.addConstant("PHP_VERSION", (Value)this.createString(version), true);
        if (response == null) {
            this.addConstant("STDOUT", this.wrapJava(new PhpStdout()), false);
            this.addConstant("STDERR", this.wrapJava(new PhpStderr()), false);
            this.addConstant("STDIN", this.wrapJava(new PhpStdin(this)), false);
        }
    }

    public Env(QuercusContext quercus) {
        this(quercus, null, null, null, null);
    }

    public static Env getCurrent() {
        return _threadEnv.get();
    }

    public static Env getInstance() {
        return Env.getCurrent();
    }

    private void fillGet(ArrayValue array, boolean isMagicQuotes) {
        String queryString = this.getQueryString();
        if (queryString == null || queryString.length() == 0) {
            return;
        }
        StringUtility.parseStr(this, queryString, array, true, this.getHttpInputEncoding(), isMagicQuotes, true, this._querySeparatorMap);
    }

    private void fillPost(ArrayValue array, ArrayValue postArray) {
        for (Map.Entry<Value, Value> entry : postArray.entrySet()) {
            Value key = entry.getKey();
            Value value = entry.getValue();
            Value existingValue = array.get(key);
            if (existingValue.isArray() && value.isArray()) {
                existingValue.toArrayValue(this).putAll(value.toArrayValue(this));
                continue;
            }
            array.put(entry.getKey(), entry.getValue().copy());
        }
    }

    private void fillCookies(ArrayValue array, QuercusCookie[] cookies, boolean isMagicQuotes) {
        for (int i = 0; cookies != null && i < cookies.length; ++i) {
            QuercusCookie cookie = cookies[i];
            String decodedValue = Env.decodeValue(cookie.getValue());
            Post.addFormValue(this, array, cookie.getName(), new String[]{decodedValue}, isMagicQuotes, true);
        }
    }

    protected void fillPost(ArrayValue postArray, ArrayValue files, QuercusHttpServletRequest request, boolean isMagicQuotes) {
        if (request != null && request.getMethod().equals("POST")) {
            Post.fillPost(this, postArray, files, request, isMagicQuotes, this.getIniBoolean("file_uploads"));
        } else if (request != null && !request.getMethod().equals("GET")) {
            InputStream is = null;
            try {
                is = request.getInputStream();
            }
            catch (IOException e) {
                this.warning(e);
            }
            StringValue bb = this.createBinaryBuilder();
            bb.appendReadAll(is, Integer.MAX_VALUE);
            this.setInputData(bb);
        }
    }

    protected AbstractFunction[] getDefaultFunctionMap() {
        return this.getQuercus().getFunctionMap();
    }

    protected QuercusPage pageInit(QuercusPage page) {
        if (page.getCompiledPage() != null) {
            page = page.getCompiledPage();
        }
        page.init(this);
        page.importDefinitions(this);
        return page;
    }

    public Value setScriptGlobal(String name, Object object) {
        Value value = object instanceof Value ? (Value)object : (object == null ? NullValue.NULL : this.wrapJava(object));
        this._scriptGlobalMap.put(name, value);
        return value;
    }

    public boolean isUnicodeSemantics() {
        return this._isUnicodeSemantics;
    }

    public String getScriptEncoding() {
        StringValue encoding = this.getIni("unicode.script_encoding");
        if (encoding.length() == 0 && (encoding = this.getIni("unicode.fallback_encoding")).length() == 0) {
            return this.getQuercus().getScriptEncoding();
        }
        return encoding.toString();
    }

    public String getRuntimeEncoding() {
        if (!this._isUnicodeSemantics) {
            return "iso-8859-1";
        }
        StringValue encoding = this.getIni("unicode.runtime_encoding");
        if (encoding.length() == 0) {
            encoding = this.getIni("unicode.fallback_encoding");
        }
        if (encoding.length() > 0) {
            return encoding.toString();
        }
        return "utf-8";
    }

    public Value setRuntimeEncoding(String encoding) {
        return this.setIni("unicode.runtime_encoding", encoding);
    }

    public EncodingReader getRuntimeEncodingFactory() throws IOException {
        return Encoding.getReadFactory(this.getRuntimeEncoding());
    }

    public String getHttpInputEncoding() {
        if (!this._isUnicodeSemantics) {
            return null;
        }
        StringValue encoding = this.getIni("unicode.http_input_encoding");
        if (encoding.length() == 0) {
            encoding = this.getIni("unicode.fallback_encoding");
        }
        if (encoding.length() > 0) {
            return encoding.toString();
        }
        return "utf-8";
    }

    public String getOutputEncoding() {
        return this._quercus.getOutputEncoding();
    }

    public StringValue createBinaryBuilder() {
        if (this._isUnicodeSemantics) {
            return new BinaryBuilderValue();
        }
        return new StringBuilderValue();
    }

    public StringValue createLargeBinaryBuilder() {
        if (this._isUnicodeSemantics) {
            return new BinaryBuilderValue();
        }
        return new LargeStringBuilderValue();
    }

    public StringValue createBinaryBuilder(int length) {
        if (this._isUnicodeSemantics) {
            return new BinaryBuilderValue(length);
        }
        return new StringBuilderValue(length);
    }

    public StringValue createBinaryBuilder(byte[] buffer, int offset, int length) {
        if (this._isUnicodeSemantics) {
            return new BinaryBuilderValue(buffer, offset, length);
        }
        return new StringBuilderValue(buffer, offset, length);
    }

    public StringValue createBinaryBuilder(byte[] buffer) {
        if (buffer == null) {
            return StringBuilderValue.EMPTY;
        }
        if (this._isUnicodeSemantics) {
            return new BinaryBuilderValue(buffer, 0, buffer.length);
        }
        return new StringBuilderValue(buffer, 0, buffer.length);
    }

    public StringValue createUnicodeBuilder() {
        if (this._isUnicodeSemantics) {
            return new UnicodeBuilderValue();
        }
        return new StringBuilderValue();
    }

    public TimeZone getDefaultTimeZone() {
        if (this._defaultTimeZone != null) {
            return this._defaultTimeZone;
        }
        String timeZone = this.getIniString("date.timezone");
        if (timeZone != null) {
            return TimeZone.getTimeZone(timeZone);
        }
        return TimeZone.getDefault();
    }

    public QDate getGmtDate() {
        if (this._gmtDate == null) {
            this._gmtDate = _freeGmtDateList.allocate();
            if (this._gmtDate == null) {
                this._gmtDate = new QDate();
            }
        }
        return this._gmtDate;
    }

    public QDate getLocalDate() {
        if (this._localDate == null) {
            this._localDate = _freeLocalDateList.allocate();
            if (this._localDate == null) {
                this._localDate = QDate.createLocal();
            }
        }
        return this._localDate;
    }

    public QDate getDate() {
        TimeZone zone = this.getDefaultTimeZone();
        if (zone.getID().equals("GMT")) {
            return this.getGmtDate();
        }
        if (zone.equals(TimeZone.getDefault())) {
            return this.getLocalDate();
        }
        return new QDate(zone);
    }

    public void setDefaultTimeZone(String id) {
        this._defaultTimeZone = TimeZone.getTimeZone(id);
    }

    public void setDefaultTimeZone(TimeZone zone) {
        this._defaultTimeZone = zone;
    }

    public QuercusServletContext getServletContext() {
        return this._quercus.getServletContext();
    }

    public void setScriptContext(ScriptContext context) {
        this._scriptContext = context;
    }

    public ArrayValue getInputGetArray() {
        ArrayValue array = this._inputGet;
        if (array == null) {
            array = new ArrayValueImpl();
            this.fillGet(array, this.getIniBoolean("magic_quotes_gpc"));
            this._inputGet = array;
        }
        return array;
    }

    public ArrayValue getInputPostArray() {
        return this._inputPost;
    }

    public ArrayValue getInputCookieArray() {
        ArrayValue array = this._inputCookie;
        if (array == null) {
            array = new ArrayValueImpl();
            this.fillCookies(array, this._request.getCookies(), this.getIniBoolean("magic_quotes_gpc"));
            this._inputCookie = array;
        }
        return array;
    }

    public ArrayValue getInputEnvArray() {
        ArrayValue array = this._inputEnv;
        if (array == null) {
            this._inputEnv = array = new ArrayValueImpl();
        }
        return array;
    }

    public ArrayValue getInputServerArray() {
        ArrayValue array = this._inputServer;
        if (array == null) {
            this._inputServer = array = new ServerArrayValue(this);
        }
        return array;
    }

    public StringValue getInputData() {
        return this._inputData;
    }

    public void setInputData(StringValue data) {
        this._inputData = data;
    }

    public final boolean isStrict() {
        return this._isStrict;
    }

    public boolean isAllowUrlInclude() {
        return this._isAllowUrlInclude;
    }

    public boolean isAllowUrlFopen() {
        return this._isAllowUrlFopen;
    }

    public int getConnectionStatus() {
        return 0;
    }

    public void start() {
        this._oldThreadEnv = _threadEnv.get();
        this._startTime = this._quercus.getCurrentTime();
        this._timeLimit = this.getIniLong("max_execution_time") * 1000L;
        this._endTime = this._timeLimit > 0L ? this._startTime + this._timeLimit : 0x3FFFFFFFFFFFFFFFL;
        _threadEnv.set(this);
        this.fillPost(this._inputPost, this._files, this._request, this.getIniBoolean("magic_quotes_gpc"));
        String encoding = this.getOutputEncoding();
        String type = this.getIniString("default_mimetype");
        if (!"".equals(type) && this._response != null) {
            if (encoding != null) {
                this._response.setContentType(type + "; charset=" + encoding);
            } else {
                this._response.setContentType(type);
            }
        }
        if (this._out != null && encoding != null) {
            try {
                this._out.setEncoding(encoding);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        HashSet<ModuleStartupListener> listeners = this._quercus.getModuleStartupListeners();
        for (ModuleStartupListener listener : listeners) {
            listener.startup(this);
        }
        this._quercus.startEnv(this);
    }

    public long getCurrentTime() {
        return this.getQuercus().getCurrentTime();
    }

    public long getExactTime() {
        return this.getQuercus().getExactTime();
    }

    public void addCleanup(EnvCleanup envCleanup) {
        if (this._cleanupList == null) {
            this._cleanupList = new ArrayList();
        }
        this._cleanupList.add(envCleanup);
    }

    public void addObjectCleanup(ObjectValue objCleanup) {
        if (this._objCleanupList == null) {
            this._objCleanupList = new ArrayList();
        }
        this._objCleanupList.add(objCleanup);
    }

    public void removeCleanup(EnvCleanup envCleanup) {
        if (this._cleanupList == null) {
            return;
        }
        for (int i = this._cleanupList.size() - 1; i >= 0; --i) {
            EnvCleanup res = this._cleanupList.get(i);
            if (!envCleanup.equals(res)) continue;
            this._cleanupList.remove(i);
            break;
        }
    }

    public QuercusContext getQuercus() {
        return this._quercus;
    }

    public ModuleContext getModuleContext() {
        return this._quercus.getModuleContext();
    }

    public DataSource getDatabase() {
        return this._quercus.getDatabase();
    }

    protected final DataSource findDatabase(String driver, String url) throws Exception {
        return this._quercus.findDatabase(driver, url);
    }

    public ConnectionEntry getConnection(String driver, String url, String userName, String password, boolean isReuse) throws Exception {
        isReuse = false;
        DataSource database = this._quercus.getDatabase();
        if (database != null) {
            userName = null;
            password = null;
        } else {
            database = this.findDatabase(driver, url);
            if (database == null) {
                return null;
            }
        }
        ConnectionEntry entry = new ConnectionEntry(this);
        entry.init(database, userName, password);
        ConnectionEntry oldEntry = null;
        if (isReuse) {
            oldEntry = this._connMap.get(entry);
        }
        if (oldEntry != null && oldEntry.isReusable()) {
            return oldEntry;
        }
        entry.connect(isReuse);
        if (isReuse) {
            this._connMap.put(entry, entry);
        }
        return entry;
    }

    public DataSource getDataSource(String driver, String url) throws Exception {
        DataSource database = this._quercus.getDatabase();
        if (database != null) {
            return database;
        }
        return this.findDatabase(driver, url);
    }

    public void setTimeLimit(long ms) {
        if (ms <= 0L) {
            ms = 0x3FFFFFFFFFFFFFFFL;
        }
        this._timeLimit = ms;
    }

    public void checkTimeout() {
        if (this._isTimeout) {
            throw new QuercusRuntimeException(L.l("script timed out"));
        }
    }

    public void updateTimeout() {
        long now = this._quercus.getCurrentTime();
        if (this._endTime < now) {
            this._isTimeout = true;
        }
    }

    public void resetTimeout() {
        this._startTime = this._quercus.getCurrentTime();
        this._endTime = this._startTime + this._timeLimit;
        this._isTimeout = false;
    }

    public long getStartTime() {
        return this._startTime;
    }

    public WriteStream getOut() {
        return this._out;
    }

    public WriteStream getOriginalOut() {
        return this._originalOut;
    }

    public final void flush() {
        try {
            this.getOut().flush();
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void print(String v) {
        try {
            this.getOut().print(v);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void print(char[] buffer, int offset, int length) {
        try {
            this.getOut().print(buffer, offset, length);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void print(char v) {
        try {
            this.getOut().print(v);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void print(long v) {
        try {
            this.getOut().print(v);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void print(double v) {
        try {
            long longV = (long)v;
            if (v == (double)longV) {
                this.getOut().print(longV);
            } else {
                this.getOut().print(v);
            }
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void print(Object v) {
        try {
            this.getOut().print(v);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void print(Value v) {
        v.print(this);
    }

    public final void println() {
        try {
            this.getOut().println();
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void println(String v) {
        try {
            this.getOut().println(v);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void println(Value v) {
        try {
            v.print(this);
            this.getOut().println();
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void println(Object v) {
        try {
            this.getOut().println(v);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void write(byte[] buffer, int offset, int length) {
        try {
            this.getOut().write(buffer, offset, length);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public OutputBuffer getOutputBuffer() {
        return this._outputBuffer;
    }

    public void pushOutputBuffer(Callable callback, int chunkSize, boolean erase) {
        this._outputBuffer = this._outputBuffer == null ? new OutputBuffer(this._outputBuffer, this, callback, chunkSize, erase) : new OutputBuffer(this._outputBuffer, this, callback, chunkSize, erase);
        this._out = this._outputBuffer.getOut();
    }

    public boolean popOutputBuffer() {
        OutputBuffer outputBuffer = this._outputBuffer;
        if (outputBuffer == null) {
            return false;
        }
        outputBuffer.close();
        this._outputBuffer = outputBuffer.getNext();
        this._out = this._outputBuffer != null ? this._outputBuffer.getOut() : this._originalOut;
        return true;
    }

    public Path getPwd() {
        return this._pwd;
    }

    public String getShellPwd() {
        if (this._pwd instanceof MemoryPath) {
            return System.getProperty("user.dir");
        }
        return this._pwd.getNativePath();
    }

    public Path getWorkDir() {
        return this._quercus.getWorkDir();
    }

    public void setPwd(Path path) {
        this._pwd = path;
        this._lookupCache.clear();
    }

    public Path getSelfPath() {
        return this._selfPath;
    }

    public Path getSelfDirectory() {
        return this._selfDirectory;
    }

    public void setSelfPath(Path path) {
        this._selfPath = path;
        this._selfDirectory = this._selfPath.getParent();
    }

    public Path getUploadDirectory() {
        if (this._uploadPath == null) {
            String realPath = this.getIniString("upload_tmp_dir");
            if (realPath != null) {
                this._uploadPath = this._quercus.getPwd().lookup(realPath);
            } else if (this.getRequest() != null) {
                this._uploadPath = this._quercus.getWebInfDir().lookup("upload");
            } else {
                realPath = WorkDir.getTmpWorkDir().lookup("upload").getNativePath();
                this._uploadPath = this._quercus.getPwd().lookup(realPath);
            }
            try {
                if (!this._uploadPath.isDirectory()) {
                    this._uploadPath.mkdirs();
                }
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
            this._uploadPath = this._uploadPath.createRoot();
        }
        return this._uploadPath;
    }

    public String getRealPath(String path) {
        String realPath = this.getRequest() != null ? this.getRequest().getRealPath(path) : this.getSelfDirectory().lookup(path).getNativePath();
        return realPath;
    }

    public Path getTempDirectory() {
        if (this._tmpPath == null) {
            String realPath = this.getRequest() != null ? this.getRequest().getRealPath("/WEB-INF/tmp") : "file:/tmp";
            this._tmpPath = this.getPwd().lookup(realPath);
            try {
                if (!this._tmpPath.isDirectory()) {
                    this._tmpPath.mkdirs();
                }
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        return this._tmpPath;
    }

    public void addRemovePath(Path path) {
        if (this._removePaths == null) {
            this._removePaths = new ArrayList();
        }
        this._removePaths.add(path);
    }

    public QuercusHttpServletRequest getRequest() {
        return this._request;
    }

    public QuercusHttpServletResponse getResponse() {
        return this._response;
    }

    public void setSessionCallback(SessionCallback callback) {
        this._sessionCallback = callback;
    }

    public SessionCallback getSessionCallback() {
        return this._sessionCallback;
    }

    public SessionArrayValue getSession() {
        return this._session;
    }

    public QuercusHttpSession getJavaSession() {
        return this._javaSession;
    }

    public void setSession(SessionArrayValue session) {
        this._session = session;
        StringValue sessionStr = this.isUnicodeSemantics() ? S_SESSION_U : S_SESSION;
        if (session != null) {
            Var var = this.getGlobalVar(sessionStr);
            if (!(var instanceof SessionVar)) {
                var = new SessionVar();
                this.setGlobalValue(sessionStr, (Value)var);
            }
            ((Value)var).set(session);
            this.setGlobalValue("HTTP_SESSION_VARS", (Value)session);
            session.addUse();
        } else {
            Var v = this.getGlobalVar(sessionStr);
            if (v != null) {
                ((Value)v).set(UnsetValue.UNSET);
            }
            if ((v = this.getGlobalVar("HTTP_SESSION_VARS")) != null) {
                ((Value)v).set(UnsetValue.UNSET);
            }
        }
    }

    public String generateSessionId() {
        String sessionId = this._quercus.getQuercusSessionManager().createSessionId(this);
        if (this._javaSession != null) {
            sessionId = this._javaSession.getId().substring(0, 3) + sessionId.substring(3);
        }
        return sessionId;
    }

    public SessionArrayValue createSession(String sessionId, boolean create) {
        Value unserialize;
        StringValue value;
        long now = this._quercus.getCurrentTime();
        SessionCallback callback = this.getSessionCallback();
        this._javaSession = this._request.getSession(true);
        if (create && this._javaSession.getId().length() >= 3 && sessionId.length() >= 3) {
            sessionId = this._javaSession.getId().substring(0, 3) + sessionId.substring(3);
        }
        SessionArrayValue session = this._quercus.loadSession(this, sessionId);
        if (callback != null && (value = callback.read(this, sessionId)) != null && value.length() != 0 && (unserialize = VariableModule.unserialize(this, value)) instanceof ArrayValue) {
            ArrayValue arrayValue = (ArrayValue)unserialize;
            session.reset(now);
            session.putAll(arrayValue);
        }
        this.setSession(session);
        return session;
    }

    public void destroySession(String sessionId) {
        SessionCallback callback = this.getSessionCallback();
        if (callback != null) {
            callback.destroy(this, sessionId);
        } else {
            this._quercus.destroySession(sessionId);
        }
        this.setSession(null);
    }

    public Logger getLogger() {
        if (this._logger == null) {
            this._logger = Logger.getLogger("quercus.quercus");
        }
        return this._logger;
    }

    public Value getConfigVar(String name) {
        return this.getIniDefinition(name).getValue(this._quercus);
    }

    public HashMap<String, Value> getIniMap(boolean create) {
        if (this._iniMap == null && create) {
            this._iniMap = new HashMap();
        }
        return this._iniMap;
    }

    public StringValue setIni(String name, Value value) {
        ++this._iniCount;
        StringValue oldValue = this.getIni(name);
        this.getIniDefinition(name).set(this, value);
        return oldValue;
    }

    public StringValue setIni(String name, String value) {
        ++this._iniCount;
        StringValue oldValue = this.getIni(name);
        this.getIniDefinition(name).set(this, value);
        return oldValue;
    }

    public StringValue getIni(String name) {
        return this.getIniDefinition(name).getAsStringValue(this);
    }

    private IniDefinition getIniDefinition(String name) {
        return this._quercus.getIniDefinitions().get(name);
    }

    public boolean getIniBoolean(String name) {
        return this.getIniDefinition(name).getAsBoolean(this);
    }

    public long getIniLong(String name) {
        return this.getIniDefinition(name).getAsLong(this);
    }

    public String getIniString(String name) {
        return this.getIniDefinition(name).getAsString(this);
    }

    public long getIniBytes(String name, long deflt) {
        return this.getIniDefinition(name).getAsLongBytes(this, deflt);
    }

    public ByteToChar getByteToChar() {
        return ByteToChar.create();
    }

    public Value getThis() {
        return this._this;
    }

    public Value setThis(Value value) {
        Value oldThis = this._this;
        this._this = value.toValue();
        return oldThis;
    }

    public Closure getClosure() {
        return this._closure;
    }

    public Closure setClosure(Closure closure) {
        Closure old = this._closure;
        this._closure = closure;
        return old;
    }

    public Value getValue(StringValue name) {
        return this.getValue(name, true, false);
    }

    public Value getValue(StringValue name, boolean isAutoCreate, boolean isOutputNotice) {
        EnvVar var = this.getEnvVar(name, isAutoCreate, isOutputNotice);
        if (var != null) {
            return var.get();
        }
        return NullValue.NULL;
    }

    public Object getSpecialValue(String name) {
        return this._specialMap.get(name);
    }

    public Object setSpecialValue(String name, Object value) {
        this._specialMap.put(name, value);
        return value;
    }

    public Value getGlobalValue(String name) {
        return this.getGlobalValue(this.createString(name));
    }

    public Value getGlobalValue(StringValue name) {
        EnvVar var = this.getGlobalEnvVar(name);
        return var.get();
    }

    public final Var getVar(StringValue name, Value value) {
        if (value != null) {
            return (Var)value;
        }
        return this.getRef(name);
    }

    public final Var getGlobalVar(StringValue name, Value value) {
        if (value != null) {
            return (Var)value;
        }
        return this.getGlobalRef(name);
    }

    public Var getRef(StringValue name) {
        EnvVar envVar = this.getEnvVar(name);
        return envVar.getVar();
    }

    public Var getRef(StringValue name, boolean isAutoCreate) {
        EnvVar envVar = this.getEnvVar(name, isAutoCreate, true);
        if (envVar != null) {
            return envVar.getVar();
        }
        return null;
    }

    public EnvVar getGlobalRaw(String name) {
        return this._globalMap.get(name);
    }

    public Var getGlobalRef(StringValue name) {
        EnvVar envVar = this.getGlobalEnvVar(name);
        return envVar.getVar();
    }

    public final EnvVar getEnvVar(StringValue name) {
        return this.getEnvVar(name, true, true);
    }

    public final EnvVar getLazyEnvVar(StringValue name) {
        EnvVar var = this.getEnvVar(name, false, false);
        if (var == null) {
            var = new LazyEnvVar(name);
        }
        return var;
    }

    public final EnvVar getEnvVar(StringValue name, boolean isAutoCreate, boolean isOutputNotice) {
        EnvVar envVar = this._map.get(name);
        if (envVar != null) {
            return envVar;
        }
        if (this._map == this._globalMap) {
            return this.getGlobalEnvVar(name, isAutoCreate, isOutputNotice);
        }
        envVar = this.getSuperGlobalRef(name, true, false);
        if (envVar != null) {
            this._globalMap.put(name, envVar);
        } else {
            if (isOutputNotice) {
                this.notice(L.l("${0} is an undefined variable", (Object)name));
            }
            if (!isAutoCreate) {
                return null;
            }
            envVar = new EnvVarImpl(new Var());
        }
        this._map.put(name, envVar);
        return envVar;
    }

    public final EnvVar getGlobalEnvVar(StringValue name) {
        return this.getGlobalEnvVar(name, true, false);
    }

    public final EnvVar getGlobalEnvVar(StringValue name, boolean isAutoCreate, boolean isOutputNotice) {
        Value value;
        EnvVar envVar = this._globalMap.get(name);
        if (envVar != null) {
            return envVar;
        }
        envVar = this.getSuperGlobalRef(name, true);
        if (envVar == null && (value = this._scriptGlobalMap.get(name)) != null) {
            envVar = new EnvVarImpl(new Var());
            envVar.setRef(value);
        }
        if (envVar == null) {
            envVar = this.getGlobalScriptContextRef(name);
        }
        if (envVar == null) {
            if (isOutputNotice) {
                this.notice(L.l("${0} is an undefined variable", (Object)name));
            }
            if (!isAutoCreate) {
                return null;
            }
            Var var = new Var();
            envVar = new EnvVarImpl(var);
        }
        this._globalMap.put(name, envVar);
        return envVar;
    }

    public Map<StringValue, EnvVar> pushEnv(Map<StringValue, EnvVar> map) {
        Map<StringValue, EnvVar> oldEnv = this._map;
        this._map = map;
        return oldEnv;
    }

    public void popEnv(Map<StringValue, EnvVar> oldEnv) {
        this._map = oldEnv;
    }

    public Map<StringValue, EnvVar> getEnv() {
        return this._map;
    }

    public Map<StringValue, EnvVar> getGlobalEnv() {
        return this._globalMap;
    }

    public boolean isGlobalEnv() {
        return this._map == this._globalMap;
    }

    public final StringValue createStaticName() {
        return this._quercus.createStaticName();
    }

    public final Var getStaticVar(StringValue name) {
        Var var = this._staticMap.get(name);
        if (var == null) {
            var = new Var();
            this._staticMap.put(name, var);
        }
        return var;
    }

    public final Value getStaticValue(StringValue name) {
        Var var = this._staticMap.get(name);
        if (var != null) {
            return var.toValue();
        }
        return NullValue.NULL;
    }

    public final Var setStaticRef(StringValue name, Value value) {
        if (value.isVar()) {
            Var var = (Var)value;
            this._staticMap.put(name, var);
            return var;
        }
        Var var = this._staticMap.get(name);
        if (var == null) {
            var = new Var();
            this._staticMap.put(name, var);
        }
        var.set(value);
        return var;
    }

    public final Var unsetVar(StringValue name) {
        EnvVar envVar = this._map.get(name);
        if (envVar != null) {
            envVar.setVar(new Var());
        }
        return null;
    }

    public final Var setVar(String name, Value value) {
        throw new UnsupportedOperationException();
    }

    public final Var unsetLocalVar(StringValue name) {
        EnvVar envVar = this._map.get(name);
        if (envVar != null) {
            envVar.setVar(new Var());
        }
        return null;
    }

    public final Var unsetGlobalVar(StringValue name) {
        EnvVar envVar = this._globalMap.get(name);
        if (envVar != null) {
            envVar.setVar(new Var());
        }
        return null;
    }

    public static final Value getLocalVar(Value var) {
        if (var == null) {
            var = new Var();
        }
        return var;
    }

    public static final Value getLocalValue(Value var) {
        if (var != null) {
            return var;
        }
        return NullValue.NULL;
    }

    public static final Value setLocalVar(Value var, Value value) {
        value = value.toValue();
        if (var instanceof Var) {
            var.set(value);
        }
        return value;
    }

    private EnvVar getSuperGlobalRef(StringValue name, boolean isGlobal) {
        return this.getSuperGlobalRef(name, false, isGlobal);
    }

    private EnvVar getSuperGlobalRef(StringValue name, boolean isCheckGlobal, boolean isGlobal) {
        EnvVar envVar;
        int specialVarId = this.isUnicodeSemantics() ? SPECIAL_VARS_U.get(name) : SPECIAL_VARS.get(name);
        if (isCheckGlobal && specialVarId != -65536 && (envVar = this._globalMap.get(name)) != null) {
            return envVar;
        }
        switch (specialVarId) {
            case 14: {
                Var var = new Var();
                EnvVarImpl envVar2 = new EnvVarImpl(var);
                this._globalMap.put(name, envVar2);
                ArrayValueImpl array = new ArrayValueImpl(this.getInputEnvArray());
                ((EnvVar)envVar2).set(array);
                return envVar2;
            }
            case 18: {
                if (!this._quercus.isRegisterArgv()) {
                    return null;
                }
                Var var = new Var();
                EnvVarImpl envVar3 = new EnvVarImpl(var);
                ArrayValue array = this.createArgv();
                ((EnvVar)envVar3).set(array);
                this._globalMap.put(name, envVar3);
                return envVar3;
            }
            case 17: {
                if (!this._quercus.isRegisterArgv()) {
                    return null;
                }
                Var array = this.getGlobalEnvVar(this.isUnicodeSemantics() ? S_ARGV_U : S_ARGV).getVar();
                int size = array.getSize();
                Var var = new Var();
                EnvVarImpl envVar4 = new EnvVarImpl(var);
                LongValue value = LongValue.create(size);
                ((EnvVar)envVar4).set(value);
                this._globalMap.put(name, envVar4);
                return envVar4;
            }
            case 9: {
                if (!QuercusContext.INI_REGISTER_LONG_ARRAYS.getAsBoolean(this)) {
                    return null;
                }
                return this.getGlobalEnvVar(this.isUnicodeSemantics() ? S_POST_U : S_POST);
            }
            case 3: {
                Var var = new Var();
                EnvVarImpl envVar5 = new EnvVarImpl(var);
                this._globalMap.put(name, envVar5);
                ArrayValueImpl post = new ArrayValueImpl();
                ((EnvVar)envVar5).set(post);
                if (this._variablesOrder.indexOf('P') >= 0 && this._inputPost.getSize() > 0) {
                    for (Map.Entry<Value, Value> entry : this._inputPost.entrySet()) {
                        post.put(entry.getKey(), entry.getValue());
                    }
                }
                return envVar5;
            }
            case 13: {
                if (!QuercusContext.INI_REGISTER_LONG_ARRAYS.getAsBoolean(this)) {
                    return null;
                }
                return this.getGlobalEnvVar(this.isUnicodeSemantics() ? S_FILES_U : S_FILES);
            }
            case 12: {
                Var var = new Var();
                EnvVarImpl envVar6 = new EnvVarImpl(var);
                this._globalMap.put(name, envVar6);
                ArrayValueImpl files = new ArrayValueImpl();
                if (this._files != null) {
                    for (Map.Entry<Value, Value> entry : this._files.entrySet()) {
                        files.put(entry.getKey(), entry.getValue());
                    }
                }
                ((EnvVar)envVar6).set(files);
                return envVar6;
            }
            case 8: {
                if (!QuercusContext.INI_REGISTER_LONG_ARRAYS.getAsBoolean(this)) {
                    return null;
                }
                if (!isGlobal) {
                    return null;
                }
                return this.getGlobalEnvVar(this.isUnicodeSemantics() ? S_GET_U : S_GET);
            }
            case 2: {
                EnvVar e;
                if (isCheckGlobal && (e = this._globalMap.get(name)) != null) {
                    return e;
                }
                Var var = new Var();
                EnvVarImpl envVar7 = new EnvVarImpl(var);
                this._globalMap.put(name, envVar7);
                ArrayValueImpl array = this._variablesOrder.indexOf('G') >= 0 ? new ArrayValueImpl(this.getInputGetArray()) : new ArrayValueImpl();
                ((EnvVar)envVar7).set(array);
                return envVar7;
            }
            case 6: {
                Var var = new Var();
                EnvVarImpl envVar8 = new EnvVarImpl(var);
                ArrayValueImpl array = new ArrayValueImpl();
                ((EnvVar)envVar8).set(array);
                this._globalMap.put(name, envVar8);
                if (this._request == null) {
                    return envVar8;
                }
                int orderLen = this._variablesOrder.length();
                block27: for (int i = 0; i < orderLen; ++i) {
                    switch (this._variablesOrder.charAt(i)) {
                        case 'G': {
                            array.putAll(this.getInputGetArray());
                            continue block27;
                        }
                        case 'P': {
                            if (this._inputPost.getSize() <= 0) continue block27;
                            this.fillPost(array, this._inputPost);
                            continue block27;
                        }
                        case 'C': {
                            array.putAll(this.getInputCookieArray());
                        }
                    }
                }
                return envVar8;
            }
            case 16: {
                String contentType;
                if (!(QuercusContext.INI_ALWAYS_POPULATE_RAW_POST_DATA.getAsBoolean(this) || (contentType = this.getContentType()) != null && contentType.startsWith("unknown/type"))) {
                    return null;
                }
                if (this._inputData == null) {
                    return null;
                }
                Var var = new Var();
                EnvVarImpl envVar9 = new EnvVarImpl(var);
                this._globalMap.put(name, envVar9);
                var.set(this._inputData);
                return envVar9;
            }
            case 15: {
                if (!QuercusContext.INI_REGISTER_LONG_ARRAYS.getAsBoolean(this)) {
                    return null;
                }
                return this.getGlobalEnvVar(this.isUnicodeSemantics() ? S_SERVER_U : S_SERVER);
            }
            case 1: {
                Value serverEnv;
                Var var = new Var();
                EnvVarImpl envVar10 = new EnvVarImpl(var);
                this._globalMap.put(name, envVar10);
                if (this._variablesOrder.indexOf('S') >= 0) {
                    serverEnv = this.getInputServerArray().copy();
                    if (this._quercus.isRegisterArgv()) {
                        ArrayValue argv = this.createArgv();
                        serverEnv.put(this.createString("argc"), LongValue.create(argv.getSize()));
                        serverEnv.put(this.createString("argv"), argv);
                    }
                } else {
                    serverEnv = new ArrayValueImpl();
                }
                var.set(serverEnv);
                return envVar10;
            }
            case 5: {
                Var var = new Var();
                EnvVarImpl envVar11 = new EnvVarImpl(var);
                this._globalMap.put(name, envVar11);
                var.set(new GlobalArrayValue(this));
                return envVar11;
            }
            case 10: {
                if (!QuercusContext.INI_REGISTER_LONG_ARRAYS.getAsBoolean(this)) {
                    return null;
                }
                return this.getGlobalEnvVar(this.isUnicodeSemantics() ? S_COOKIE_U : S_COOKIE);
            }
            case 4: {
                Var var = new Var();
                EnvVarImpl envVar12 = new EnvVarImpl(var);
                this._globalMap.put(name, envVar12);
                if (this._variablesOrder.indexOf('C') >= 0) {
                    var.set(this.getCookies());
                } else {
                    var.set(new ArrayValueImpl());
                }
                return envVar12;
            }
            case 7: {
                envVar = this._globalMap.get("_SESSION");
                if (envVar == null) {
                    SessionVar var = new SessionVar();
                    envVar = new EnvVarImpl(var);
                    this._globalMap.put(name, envVar);
                }
                return envVar;
            }
            case 11: {
                Var var = new Var();
                EnvVarImpl envVar13 = new EnvVarImpl(var);
                this._globalMap.put(name, envVar13);
                var.set(this.getGlobalVar("_SERVER").get(this.isUnicodeSemantics() ? PHP_SELF_STRING_U : PHP_SELF_STRING));
                return envVar13;
            }
        }
        return null;
    }

    protected ArrayValue createArgv() {
        ArrayValueImpl array = new ArrayValueImpl();
        String query = this.getQueryString();
        if (query == null) {
            return array;
        }
        int i = 0;
        int j = 0;
        while ((j = query.indexOf(43, i)) >= 0) {
            String sub = query.substring(i, j);
            array.put(sub);
            i = j + 1;
        }
        if (i < query.length()) {
            array.put(query.substring(i));
        }
        return array;
    }

    protected String getQueryString() {
        if (this._request != null) {
            return this._request.getQueryString();
        }
        return null;
    }

    protected String getContentType() {
        if (this._request != null) {
            return this._request.getContentType();
        }
        return null;
    }

    protected ArrayValue getCookies() {
        ArrayValueImpl array = new ArrayValueImpl();
        if (this._request == null) {
            return array;
        }
        boolean isMagicQuotes = this.getIniBoolean("magic_quotes_gpc");
        QuercusCookie[] cookies = this._request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                QuercusCookie cookie = cookies[i];
                String value = Env.decodeValue(cookie.getValue());
                StringValue valueAsValue = this.createString(value);
                if (isMagicQuotes) {
                    valueAsValue = StringModule.addslashes(valueAsValue);
                }
                ((ArrayValue)array).append(this.createString(cookie.getName()), valueAsValue);
            }
        }
        return array;
    }

    public void setArgv(String[] args) {
        if (this._quercus.isRegisterArgv()) {
            ArrayValueImpl argv = new ArrayValueImpl();
            for (String arg : args) {
                argv.put(arg);
            }
            Value serverEnv = this.getGlobalValue("_SERVER");
            serverEnv.put(this.createString("argc"), LongValue.create(args.length));
            serverEnv.put(this.createString("argv"), argv);
        }
    }

    protected EnvVar getGlobalSpecialRef(StringValue name) {
        if (QuercusContext.isSuperGlobal(name)) {
            return this._globalMap.get(name);
        }
        return null;
    }

    protected EnvVar getGlobalScriptContextRef(StringValue name) {
        Bindings bindings;
        if (this._scriptContext == null) {
            return null;
        }
        EnvVar envVar = this._globalMap.get(name);
        if (envVar != null) {
            return envVar;
        }
        Object value = this._scriptContext.getAttribute(name.toString());
        if (value == null && (bindings = this._scriptContext.getBindings(100)) != null) {
            value = bindings.get(name.toString());
        }
        if (value == null && (bindings = this._scriptContext.getBindings(200)) != null) {
            value = bindings.get(name.toString());
        }
        if (value != null) {
            envVar = new EnvVarImpl(new Var());
            this._globalMap.put(name, envVar);
            envVar.set(this.wrapJava(value));
        }
        return envVar;
    }

    protected static String decodeValue(String s) {
        int len = s.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '%' && i + 2 < len) {
                char d1 = s.charAt(i + 1);
                char d2 = s.charAt(i + 2);
                int v = 0;
                if ('0' <= d1 && d1 <= '9') {
                    v = 16 * (d1 - 48);
                } else if ('a' <= d1 && d1 <= 'f') {
                    v = 16 * (d1 - 97 + 10);
                } else if ('A' <= d1 && d1 <= 'F') {
                    v = 16 * (d1 - 65 + 10);
                } else {
                    sb.append('%');
                    continue;
                }
                if ('0' <= d2 && d2 <= '9') {
                    v += d2 - 48;
                } else if ('a' <= d2 && d2 <= 'f') {
                    v += d2 - 97 + 10;
                } else if ('A' <= d2 && d2 <= 'F') {
                    v += d2 - 65 + 10;
                } else {
                    sb.append('%');
                    continue;
                }
                i += 2;
                sb.append((char)v);
                continue;
            }
            if (ch == '+') {
                sb.append(' ');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public Var getVar(String name) {
        return this.getVar(this.createString(name));
    }

    public Var getVar(StringValue name, boolean isAutoCreate, boolean isOutputNotice) {
        EnvVar envVar = this.getEnvVar(name, isAutoCreate, isOutputNotice);
        if (envVar != null) {
            return envVar.getVar();
        }
        return null;
    }

    public Var getVar(StringValue name) {
        EnvVar envVar = this.getEnvVar(name, true, false);
        return envVar.getVar();
    }

    public Var getGlobalVar(String name) {
        EnvVar envVar = this.getGlobalEnvVar(this.createString(name));
        return envVar.getVar();
    }

    public Var getGlobalVar(StringValue name) {
        EnvVar envVar = this.getGlobalEnvVar(name);
        return envVar.getVar();
    }

    public void setValue(String name, Value value) {
        this.setValue(this.createString(name), value);
    }

    public Value setValue(StringValue name, Value value) {
        EnvVar envVar = this.getEnvVar(name, true, false);
        envVar.set(value);
        return value;
    }

    public Var setVar(StringValue name, Var var) {
        EnvVar envVar = this.getEnvVar(name, true, false);
        envVar.setVar(var);
        return var;
    }

    public Var setRef(StringValue name, Value value) {
        EnvVar envVar = this.getEnvVar(name, true, false);
        return envVar.setRef(value);
    }

    public Value setGlobalValue(String name, Value value) {
        return this.setGlobalValue(this.createString(name), value);
    }

    public Value setGlobalValue(StringValue name, Value value) {
        EnvVar envVar = this.getGlobalEnvVar(name);
        envVar.setRef(value);
        return value;
    }

    public void pushCall(Expr call, Value obj, Value[] args) {
        if (this._callStack == null) {
            this._callStack = new Expr[256];
            this._callThisStack = new Value[256];
            this._callArgStack = new Value[256][];
        }
        if (this._callStack.length <= this._callStackTop) {
            Expr[] newStack = new Expr[2 * this._callStack.length];
            System.arraycopy(this._callStack, 0, newStack, 0, this._callStack.length);
            this._callStack = newStack;
            Value[] newThisStack = new Value[2 * this._callThisStack.length];
            System.arraycopy(this._callThisStack, 0, newThisStack, 0, this._callThisStack.length);
            this._callThisStack = newThisStack;
            Value[][] newArgStack = new Value[2 * this._callArgStack.length][];
            System.arraycopy(this._callArgStack, 0, newArgStack, 0, this._callArgStack.length);
            this._callArgStack = newArgStack;
        }
        this._callStack[this._callStackTop] = call;
        this._callThisStack[this._callStackTop] = obj;
        this._callArgStack[this._callStackTop] = args;
        ++this._callStackTop;
    }

    public Expr popCall() {
        if (this._callStack == null) {
            throw new IllegalStateException();
        }
        return this._callStack[--this._callStackTop];
    }

    public int getCallDepth() {
        return this._callStackTop;
    }

    public Expr peekCall(int depth) {
        if (this._callStackTop - depth > 0) {
            return this._callStack[this._callStackTop - depth - 1];
        }
        return null;
    }

    public Value peekCallThis(int depth) {
        if (this._callStackTop - depth > 0) {
            return this._callThisStack[this._callStackTop - depth - 1];
        }
        return null;
    }

    public Value[] peekArgs(int depth) {
        if (this._callStackTop - depth > 0) {
            return this._callArgStack[this._callStackTop - depth - 1];
        }
        return null;
    }

    public RegexpState allocateRegexpState() {
        RegexpState state = this._freeRegexpState;
        this._freeRegexpState = null;
        return state;
    }

    public void freeRegexpState(RegexpState state) {
        this._freeRegexpState = state;
    }

    public void pushProfile(int id) {
    }

    public void popProfile(long nanos) {
    }

    public boolean pushFieldGet(OVERLOADING_TYPES type, String className, StringValue fieldName) {
        FieldGetEntry entry = new FieldGetEntry(className, fieldName);
        LinkedList<FieldGetEntry> list = null;
        switch (type) {
            case FIELDGET: {
                list = this._fieldGetList;
                break;
            }
            case FIELDSET: {
                list = this._fieldSetList;
                break;
            }
            case ISSET: {
                list = this._issetList;
                break;
            }
            case UNSET: {
                list = this._unsetList;
                break;
            }
            case INVALID_FIRST: 
            case INVALID_LAST: {
                throw new IllegalStateException("IllegalState: pushFieldGet with FIRST/LAST Element");
            }
        }
        if (list == null) {
            return false;
        }
        if (list.contains(entry)) {
            return false;
        }
        list.push(entry);
        return true;
    }

    public void popFieldGet(OVERLOADING_TYPES type) {
        switch (type) {
            case FIELDGET: {
                this._fieldGetList.pop();
                break;
            }
            case FIELDSET: {
                this._fieldSetList.pop();
                break;
            }
            case ISSET: {
                this._issetList.pop();
                break;
            }
            case UNSET: {
                this._unsetList.pop();
                break;
            }
            case INVALID_FIRST: 
            case INVALID_LAST: {
                throw new IllegalStateException("IllegalState: popFieldGet with FIRST/LAST Element");
            }
        }
    }

    public QuercusClass getCallingClass() {
        return this._callingClass;
    }

    public Value getCallingClassName() {
        QuercusClass qClass = this._callingClass;
        if (qClass != null) {
            return this.createString(qClass.getName());
        }
        this.warning(L.l("get_called_class() must be called from a class-context."));
        return NullValue.NULL;
    }

    public QuercusClass getCallingClass(Value qThis) {
        QuercusClass cls = qThis.getQuercusClass();
        if (cls == null) {
            cls = this._callingClass;
        }
        return cls;
    }

    public QuercusClass setCallingClass(QuercusClass cls) {
        QuercusClass oldCallingClass = this._callingClass;
        this._callingClass = cls;
        return oldCallingClass;
    }

    public String getStackTraceAsString() {
        return this.getStackTraceAsString(this.getLocation());
    }

    public String getStackTraceAsString(Location loc) {
        ArrayValue value = ErrorModule.debug_backtrace(this, 0, 0);
        return this.getStackTraceAsString(value, loc);
    }

    public String getStackTraceAsString(Throwable e, Location loc) {
        ArrayValue value = ErrorModule.debug_backtrace_exception(this, e, 0);
        return this.getStackTraceAsString(value, loc);
    }

    public String getStackTraceAsString(ArrayValue value, Location location) {
        StringBuilder sb = new StringBuilder();
        for (Value item : value.values()) {
            String function = item.get(this.createString("function")).toJavaString();
            String file = item.get(this.createString("file")).toJavaString();
            int line = item.get(this.createString("line")).toInt();
            if (function == null || "".equals(function)) continue;
            sb.append("\n  at ");
            sb.append(function);
            if (file == null || "".equals(file)) continue;
            sb.append(" (" + file + ":" + line + ")");
        }
        if (sb.length() == 0 && location != null) {
            return "\n  " + String.valueOf(location);
        }
        return sb.toString();
    }

    public ArrayList<String> getStackTrace() {
        ArrayList<String> trace = new ArrayList<String>();
        for (int i = this._callStackTop - 1; i >= 0; --i) {
            Location location = this._callStack[i].getLocation();
            String loc = location != null && location.getFileName() != null ? " (at " + location.getFileName() + ":" + location.getLineNumber() + ")" : "";
            String entry = this._callThisStack[i] != null && !"".equals(this._callThisStack[i].toString()) ? this._callThisStack[i] + "." + this._callStack[i].toString() + loc : this._callStack[i].toString() + loc;
            trace.add(entry);
        }
        return trace;
    }

    public final Value[] setFunctionArgs(Value[] args) {
        Value[] oldArgs = this._functionArgs;
        Value[] newArgs = new Value[args.length];
        for (int i = 0; args != null && i < args.length; ++i) {
            newArgs[i] = args[i].toValue().copySaveFunArg();
        }
        this._functionArgs = newArgs;
        return oldArgs;
    }

    public final Value[] setFunctionArgsNoCopy(Value[] args) {
        Value[] oldArgs = this._functionArgs;
        for (int i = 0; args != null && i < args.length; ++i) {
            args[i] = args[i].toValue();
        }
        this._functionArgs = args;
        return oldArgs;
    }

    public final void restoreFunctionArgs(Value[] args) {
        this._functionArgs = args;
    }

    public final Value[] getFunctionArgs() {
        return this._functionArgs;
    }

    public Object removeSpecialValue(String name) {
        return this._specialMap.remove(name);
    }

    public Value getConstant(String name) {
        return this.getConstant(name, true);
    }

    public Value getConstant(String name, boolean isAutoCreateString) {
        Value value = this.getConstantImpl(name);
        if (value != null) {
            return value;
        }
        int ns = name.lastIndexOf(92);
        if (ns >= 0 && (value = this.getConstantImpl(name = name.substring(ns + 1))) != null) {
            return value;
        }
        if (isAutoCreateString) {
            return this.createString(name);
        }
        return null;
    }

    public boolean isDefined(String name) {
        return this.getConstantImpl(name) != null;
    }

    private Value getConstantImpl(String name) {
        Value value;
        int id = this._quercus.getConstantId(name);
        if (id < this._const.length && (value = this._const[id]) != null) {
            return value;
        }
        id = this._quercus.getConstantLowerId(name);
        if (id > 0 && id < this._const.length && (value = this._const[id]) != null) {
            return value;
        }
        return null;
    }

    public Value getConstant(int id) {
        if (this._const.length <= id) {
            return this._quercus.getConstantName(id);
        }
        Value value = this._const[id];
        if (value != null) {
            return value;
        }
        int lowerId = this._quercus.getConstantLower(id);
        value = this._const[lowerId];
        if (value != null) {
            this._const[id] = value;
            return value;
        }
        Value nameValue = this._quercus.getConstantName(id);
        String name = nameValue.toString();
        int ns = name.lastIndexOf(92);
        if (ns >= 0 && (value = this.getConstantImpl(name = name.substring(ns + 1))) != null) {
            this._const[id] = value;
            return value;
        }
        return nameValue;
    }

    public Value removeConstant(String name) {
        int id = this._quercus.getConstantId(name);
        Value value = this._const[id];
        this._const[id] = null;
        return value;
    }

    public Value addConstant(String name, Value value, boolean isCaseInsensitive) {
        int id = isCaseInsensitive ? this._quercus.addLowerConstantId(this.createString(name)) : this._quercus.getConstantId(name);
        return this.addConstant(id, value, isCaseInsensitive);
    }

    public Value addConstant(StringValue name, Value value, boolean isCaseInsensitive) {
        int id = isCaseInsensitive ? this._quercus.addLowerConstantId(name) : this._quercus.getConstantId(name);
        return this.addConstant(id, value, isCaseInsensitive);
    }

    public Value addConstant(int id, Value value, boolean isCaseInsensitive) {
        if (this._const.length <= id) {
            Value[] newConst = new Value[id + 256];
            System.arraycopy(this._const, 0, newConst, 0, this._const.length);
            this._const = newConst;
        }
        if (this._const[id] != null) {
            return this.notice(L.l("cannot redefine constant {0}", (Object)this._quercus.getConstantName(id)));
        }
        this._const[id] = value;
        if (isCaseInsensitive) {
            int lowerId = this._quercus.getConstantLower(id);
            if (this._const.length <= lowerId) {
                Value[] newConst = new Value[lowerId + 256];
                System.arraycopy(this._const, 0, newConst, 0, this._const.length);
                this._const = newConst;
            }
            this._const[lowerId] = value;
        }
        return value;
    }

    public ArrayValue getDefinedConstants() {
        ArrayValueImpl result = new ArrayValueImpl();
        for (int i = 0; i < this._const.length; ++i) {
            if (this._const[i] == null) continue;
            ((ArrayValue)result).append(this._quercus.getConstantName(i), this._const[i]);
        }
        return result;
    }

    public boolean isExtensionLoaded(String name) {
        return this.getQuercus().isExtensionLoaded(name);
    }

    public HashSet<String> getLoadedExtensions() {
        return this.getQuercus().getLoadedExtensions();
    }

    public Value getExtensionFuncs(String name) {
        return this.getQuercus().getExtensionFuncs(name);
    }

    public StreamContextResource getDefaultStreamContext() {
        if (this._defaultStreamContext == null) {
            this._defaultStreamContext = new StreamContextResource();
        }
        return this._defaultStreamContext;
    }

    public HashMap<StringValue, ProtocolWrapper> getStreamWrappers() {
        if (this._wrappedStreamMap == null) {
            this._wrappedStreamMap = new HashMap();
            ZlibProtocolWrapper zlibProtocolWrapper = new ZlibProtocolWrapper();
            this._wrappedStreamMap.put(this.createString("compress.zlib"), zlibProtocolWrapper);
            this._wrappedStreamMap.put(this.createString("zlib"), zlibProtocolWrapper);
            this._wrappedStreamMap.put(this.createString("php"), new PhpProtocolWrapper());
        }
        return this._wrappedStreamMap;
    }

    public void addStreamWrapper(StringValue name, ProtocolWrapper wrapper) {
        HashMap<StringValue, ProtocolWrapper> streamMap = this.getStreamWrappers();
        streamMap.put(name, wrapper);
    }

    public ProtocolWrapper getStreamWrapper(StringValue name) {
        HashMap<StringValue, ProtocolWrapper> wrapperMap = this.getStreamWrappers();
        return wrapperMap.get(name);
    }

    public boolean unregisterStreamWrapper(StringValue name) {
        HashMap<StringValue, ProtocolWrapper> wrapperMap = this.getStreamWrappers();
        ProtocolWrapper wrapper = wrapperMap.remove(name);
        if (wrapper == null) {
            return false;
        }
        if (this._unregisteredWrappedStreamMap == null) {
            this._unregisteredWrappedStreamMap = new HashMap();
        }
        this._unregisteredWrappedStreamMap.put(name, wrapper);
        return true;
    }

    public boolean restoreStreamWrapper(StringValue name) {
        if (this._unregisteredWrappedStreamMap == null) {
            return false;
        }
        ProtocolWrapper wrapper = this._unregisteredWrappedStreamMap.remove(name);
        if (wrapper == null) {
            return false;
        }
        HashMap<StringValue, ProtocolWrapper> wrapperMap = this.getStreamWrappers();
        wrapperMap.put(name, wrapper);
        return true;
    }

    public ArrayValue getDefinedFunctions() {
        ArrayValueImpl funs = new ArrayValueImpl();
        ArrayValueImpl system = new ArrayValueImpl();
        ArrayValueImpl user = new ArrayValueImpl();
        AbstractFunction[] systemFuns = this._quercus.getFunctionMap();
        AbstractFunction[] envFuns = this._fun;
        for (int i = 0; i < envFuns.length; ++i) {
            if (i < systemFuns.length && systemFuns[i] != null && !(systemFuns[i] instanceof UndefinedFunction)) {
                system.append(this.createString(systemFuns[i].getName()));
                continue;
            }
            if (envFuns[i] == null || envFuns[i] instanceof UndefinedFunction) continue;
            user.append(this.createString(envFuns[i].getName()));
        }
        funs.append(this.createString("internal"), system);
        funs.append(this.createString("user"), user);
        return funs;
    }

    public int findFunctionId(StringValue name) {
        return this._quercus.findFunctionId(name);
    }

    public AbstractFunction findFunction(StringValue name) {
        int id = this._quercus.findFunctionId(name);
        if (id >= 0) {
            if (id < this._fun.length && !(this._fun[id] instanceof UndefinedFunction)) {
                return this._fun[id];
            }
            return null;
        }
        if (this._anonymousFunMap != null) {
            return this._anonymousFunMap.get(name);
        }
        return null;
    }

    public AbstractFunction getFunction(int id) {
        return this._fun[id];
    }

    public AbstractFunction getFunction(StringValue name) {
        AbstractFunction fun = this.findFunction(name);
        if (fun != null) {
            return fun;
        }
        throw this.createErrorException(L.l("'{0}' is an unknown function.", (Object)name));
    }

    public void updateFunction(int id, AbstractFunction fun) {
        if (this._fun.length <= id) {
            AbstractFunction[] oldFun = this._fun;
            this._fun = new AbstractFunction[id + 256];
            System.arraycopy(oldFun, 0, this._fun, 0, oldFun.length);
        }
        if (this._fun[id] == null) {
            this._fun[id] = fun;
        }
    }

    public AbstractFunction getFunction(Value name) {
        if ((name = name.toValue()) instanceof CallbackFunction) {
            return ((CallbackFunction)name).getFunction(this);
        }
        return this.getFunction(name.toStringValue());
    }

    public Value addFunction(String name, AbstractFunction fun) {
        return this.addFunction(this.createString(name), fun);
    }

    public Value addFunction(StringValue name, AbstractFunction fun) {
        AbstractFunction staticFun = this._quercus.findLowerFunctionImpl(name.toLowerCase(Locale.ENGLISH));
        if (staticFun != null) {
            throw new QuercusException(L.l("can't redefine function {0}", (Object)name));
        }
        int id = this._quercus.getFunctionId(name);
        if (this._fun.length <= id) {
            AbstractFunction[] funMap = new AbstractFunction[id + 256];
            System.arraycopy(this._fun, 0, funMap, 0, this._fun.length);
            this._fun = funMap;
        }
        if (this._fun[id] != null && !(this._fun[id] instanceof UndefinedFunction)) {
            throw new QuercusException(L.l("can't redefine function {0}", (Object)name));
        }
        this._fun[id] = fun;
        return BooleanValue.TRUE;
    }

    public AbstractFunction createAnonymousFunction(String args, String code) throws IOException {
        if (this._anonymousFunMap == null) {
            this._anonymousFunMap = new HashMap();
        }
        StringValue sb = this.createStringBuilder();
        sb.append("\u0000lambda_");
        sb.append(this._anonymousFunMap.size() + 1);
        StringValue name = sb;
        if (args == null) {
            args = "";
        }
        if (code == null) {
            code = "";
        }
        AbstractFunction fun = this.getQuercus().parseFunction(name.toString(), args, code);
        this._anonymousFunMap.put(name, fun);
        return fun;
    }

    public Value addFunctionFromPage(String name, String lowerName, AbstractFunction fun) {
        return BooleanValue.TRUE;
    }

    public Value evalCode(StringValue code) throws IOException {
        QuercusContext quercus;
        QuercusProgram program;
        Value value;
        if (log.isLoggable(Level.FINER)) {
            log.finer(code.toString());
        }
        if ((value = (program = (quercus = this.getQuercus()).parseEvalExpr(code)).execute(this)) == null) {
            return NullValue.NULL;
        }
        return value;
    }

    public void execute() throws IOException {
        StringValue prepend = this._quercus.getIniValue("auto_prepend_file").toStringValue(this);
        if (prepend.length() > 0) {
            Path prependPath = this.lookup(prepend);
            if (prependPath == null) {
                this.error(L.l("auto_prepend_file '{0}' not found.", (Object)prepend));
            } else {
                QuercusPage prependPage = this._quercus.parse(prependPath);
                prependPage.executeTop(this);
            }
        }
        this.executeTop();
        StringValue append = this._quercus.getIniValue("auto_append_file").toStringValue(this);
        if (append.length() > 0) {
            Path appendPath = this.lookup(append);
            if (appendPath == null) {
                this.error(L.l("auto_append_file '{0}' not found.", (Object)append));
            } else {
                QuercusPage appendPage = this.getQuercus().parse(appendPath);
                appendPage.executeTop(this);
            }
        }
    }

    public Value executeTop() {
        try {
            return this.executePageTop(this._page);
        }
        catch (QuercusLanguageException e) {
            log.log(Level.FINER, e.toString(), e);
            if (this.getExceptionHandler() != null) {
                try {
                    this.getExceptionHandler().call(this, e.toException(this));
                }
                catch (QuercusLanguageException e2) {
                    this.uncaughtExceptionError(e2);
                }
            } else {
                this.uncaughtExceptionError(e);
            }
            return NullValue.NULL;
        }
    }

    private void uncaughtExceptionError(QuercusLanguageException e) {
        Location location = e.getLocation(this);
        String type = e.getValue().getClassName();
        String message = e.getMessage(this);
        this.error(L.l("Uncaught exception of type '{0}' with message '{1}'", (Object)type, (Object)message), location);
    }

    protected Value executePage(QuercusPage page) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " executePage " + page);
        }
        if (page.getCompiledPage() != null) {
            return page.getCompiledPage().execute(this);
        }
        return page.execute(this);
    }

    protected Value executePageTop(QuercusPage page) {
        if (page.getCompiledPage() != null) {
            return page.getCompiledPage().execute(this);
        }
        return page.execute(this);
    }

    public Value call(StringValue name) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.call(this);
    }

    public Value call(StringValue name, Value a0) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.call(this, a0);
    }

    public Value call(StringValue name, Value a0, Value a1) {
        return this.getFunction(name).call(this, a0, a1);
    }

    public Value call(StringValue name, Value a0, Value a1, Value a2) {
        return this.getFunction(name).call(this, a0, a1, a2);
    }

    public Value call(StringValue name, Value a0, Value a1, Value a2, Value a3) {
        return this.getFunction(name).call(this, a0, a1, a2, a3);
    }

    public Value call(StringValue name, Value a0, Value a1, Value a2, Value a3, Value a4) {
        return this.getFunction(name).call(this, a0, a1, a2, a3, a4);
    }

    public Value call(StringValue name, Value[] args) {
        return this.getFunction(name).call(this, args);
    }

    public Value callRef(StringValue name) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.callRef(this);
    }

    public Value callRef(StringValue name, Value a0) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.callRef(this, a0);
    }

    public Value callRef(StringValue name, Value a0, Value a1) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.callRef(this, a0, a1);
    }

    public Value callRef(StringValue name, Value a0, Value a1, Value a2) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.callRef(this, a0, a1, a2);
    }

    public Value callRef(StringValue name, Value a0, Value a1, Value a2, Value a3) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.callRef(this, a0, a1, a2, a3);
    }

    public Value callRef(StringValue name, Value a0, Value a1, Value a2, Value a3, Value a4) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.callRef(this, a0, a1, a2, a3, a4);
    }

    public Value callRef(StringValue name, Value[] args) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.callRef(this, args);
    }

    public void addClassDef(String name, ClassDef cl) {
        int id = this._quercus.getClassId(name);
        if (this._classDef.length <= id) {
            ClassDef[] def = new ClassDef[id + 256];
            System.arraycopy(this._classDef, 0, def, 0, this._classDef.length);
            this._classDef = def;
        }
        if (this._classDef[id] == null) {
            this._classDef[id] = cl;
        }
    }

    public ClassDef findClassDef(String name) {
        int id = this._quercus.getClassId(name);
        if (id < this._classDef.length) {
            return this._classDef[id];
        }
        return null;
    }

    public SaveState saveState() {
        if (this._globalMap != this._map) {
            throw new QuercusException(L.l("Env.saveState() only allowed at top level"));
        }
        return new SaveState(this, this._fun, this._classDef, this._qClass, this._const, this._staticMap, this._globalMap, this._includeMap, this._importMap);
    }

    EnvVar[] getGlobalList() {
        return this._globalList;
    }

    boolean isSpecialVar(StringValue name) {
        if (QuercusContext.isSuperGlobal(name)) {
            return true;
        }
        return this._scriptGlobalMap.get(name) != null;
    }

    public void restoreState(SaveState saveState) {
        AbstractFunction[] fun = saveState.getFunctionList();
        if (this._fun.length < fun.length) {
            this._fun = new AbstractFunction[fun.length];
        }
        System.arraycopy(fun, 0, this._fun, 0, fun.length);
        ClassDef[] classDef = saveState.getClassDefList();
        if (this._classDef.length < classDef.length) {
            this._classDef = new ClassDef[classDef.length];
        }
        System.arraycopy(classDef, 0, this._classDef, 0, classDef.length);
        QuercusClass[] qClass = saveState.getQuercusClassList();
        if (this._qClass.length < qClass.length) {
            this._qClass = new QuercusClass[qClass.length];
        }
        System.arraycopy(qClass, 0, this._qClass, 0, qClass.length);
        Value[] constList = saveState.getConstantList();
        if (this._const.length < constList.length) {
            this._const = new Value[constList.length];
        }
        System.arraycopy(constList, 0, this._const, 0, constList.length);
        IntMap staticNameMap = saveState.getStaticNameMap();
        Value[] staticList = saveState.getStaticList();
        this._staticMap = new LazyStaticMap(staticNameMap, staticList);
        IntMap globalNameMap = saveState.getGlobalNameMap();
        Value[] globalList = saveState.getGlobalList();
        Map<StringValue, EnvVar> oldGlobal = this._globalMap;
        this._globalMap = new LazySymbolMap(globalNameMap, globalList);
        this._map = this._globalMap;
        for (Map.Entry<StringValue, EnvVar> oldEntry : oldGlobal.entrySet()) {
            EnvVar oldEnvVar = oldEntry.getValue();
            EnvVar newEnvVar = this._globalMap.get(oldEntry.getKey());
            if (newEnvVar == null) continue;
            oldEnvVar.setVar(newEnvVar.getVar());
        }
        Map<Path, QuercusPage> includeMap = saveState.getIncludeMap();
        this._includeMap = new HashMap<Path, QuercusPage>(includeMap);
        ImportMap importMap = saveState.getImportMap();
        if (importMap != null) {
            this._importMap = importMap.copy();
        }
    }

    public ObjectValue createObject() {
        try {
            return (ObjectValue)this._quercus.getStdClass().createObject(this);
        }
        catch (Exception e) {
            throw new QuercusModuleException(e);
        }
    }

    public ObjectValue createIncompleteObject(String name) {
        try {
            ObjectValue obj = (ObjectValue)this._quercus.getStdClass().createObject(this);
            obj.setIncompleteObjectName(name);
            return obj;
        }
        catch (Exception e) {
            throw new QuercusModuleException(e);
        }
    }

    public StringValue getEmptyString() {
        if (this._isUnicodeSemantics) {
            return UnicodeBuilderValue.EMPTY;
        }
        return ConstStringValue.EMPTY;
    }

    public StringValue createStringBuilder() {
        if (this._isUnicodeSemantics) {
            return new UnicodeBuilderValue();
        }
        return new StringBuilderValue();
    }

    public StringValue createString(byte[] buffer, int offset, int length) {
        if (this._isUnicodeSemantics) {
            return new UnicodeValueImpl(new String(buffer, offset, length));
        }
        return new ConstStringValue(buffer, offset, length);
    }

    public StringValue createString(char[] buffer, int length) {
        if (this._isUnicodeSemantics) {
            return new UnicodeBuilderValue(buffer, length);
        }
        return new ConstStringValue(buffer, length);
    }

    public StringValue createString(char[] buffer, int offset, int length) {
        if (this._isUnicodeSemantics) {
            return new UnicodeBuilderValue(buffer, offset, length);
        }
        return new ConstStringValue(buffer, offset, length);
    }

    public StringValue createString(long value) {
        String s = String.valueOf(value);
        if (this._isUnicodeSemantics) {
            return new UnicodeValueImpl(s);
        }
        return new ConstStringValue(s);
    }

    public StringValue createString(String s) {
        if (s == null || s.length() == 0) {
            return this._isUnicodeSemantics ? UnicodeBuilderValue.EMPTY : ConstStringValue.EMPTY;
        }
        if (s.length() == 1) {
            if (this._isUnicodeSemantics) {
                return UnicodeBuilderValue.create(s.charAt(0));
            }
            return ConstStringValue.create(s.charAt(0));
        }
        if (this._isUnicodeSemantics) {
            return new UnicodeBuilderValue(s);
        }
        if (s.length() < 256) {
            StringValue stringValue = _internStringMap.get(s);
            if (stringValue == null) {
                stringValue = new ConstStringValue(s);
                _internStringMap.put(s, stringValue);
            }
            return stringValue;
        }
        return new ConstStringValue(s);
    }

    public StringValue createString(char ch) {
        if (this._isUnicodeSemantics) {
            return UnicodeValueImpl.create(ch);
        }
        return ConstStringValue.create(ch);
    }

    public StringValue createBinaryString(TempBuffer head) {
        StringBuilderValue string = this._isUnicodeSemantics ? new BinaryBuilderValue() : new StringBuilderValue();
        while (head != null) {
            ((StringValue)string).append(head.getBuffer(), 0, head.getLength());
            head = head.getNext();
        }
        return string;
    }

    public Value createException(String exceptionClass, String message) {
        QuercusClass cls = this.getClass(exceptionClass);
        StringValue messageV = this.createString(message);
        Value[] args = new Value[]{messageV};
        Value value = cls.callNew(this, args);
        Location location = this.getLocation();
        value.putField(this, "file", (Value)this.createString(location.getFileName()));
        value.putField(this, "line", (Value)LongValue.create(location.getLineNumber()));
        value.putField(this, "trace", (Value)ErrorModule.debug_backtrace(this, 0, 0));
        return value;
    }

    public Value createException(String exceptionClass, String ... args) {
        QuercusClass cls = this.getClass(exceptionClass);
        Value[] argsV = new Value[args.length];
        for (int i = 0; i < args.length; ++i) {
            argsV[i] = this.createString(args[i]);
        }
        Value value = cls.callNew(this, argsV);
        Location location = this.getLocation();
        value.putField(this, "file", (Value)this.createString(location.getFileName()));
        value.putField(this, "line", (Value)LongValue.create(location.getLineNumber()));
        value.putField(this, "trace", (Value)ErrorModule.debug_backtrace(this, 0, 0));
        return value;
    }

    public Value createException(Throwable e) {
        QuercusClass cls = this.findClass("Exception");
        StringValue message = this.createString(e.getMessage());
        Value[] args = new Value[]{message};
        Value value = cls.callNew(this, args);
        if (e.getStackTrace() != null && e.getStackTrace().length > 0) {
            StackTraceElement elt = e.getStackTrace()[0];
            value.putField(this, "file", (Value)this.createString(elt.getFileName()));
            value.putField(this, "line", (Value)LongValue.create(elt.getLineNumber()));
            value.putField(this, "trace", (Value)ErrorModule.debug_backtrace(this, 0, 0));
        }
        if (e instanceof QuercusException && e.getCause() != null) {
            e = e.getCause();
        }
        value.putField(this, "__javaException", this.wrapJava(e));
        return value;
    }

    public int generateObjectId() {
        return ++this._objectId;
    }

    public JavaClassDef getJavaClassDefinition(String className) {
        JavaClassDef def = this.getJavaClassDefinition(className, true);
        if (def != null) {
            return def;
        }
        throw this.createErrorException(L.l("'{0}' class definition not found", (Object)className));
    }

    public JavaClassDef getJavaClassDefinition(Class<?> type) {
        JavaClassDef def = this._quercus.getJavaClassDefinition(type, type.getName());
        return def;
    }

    private JavaClassDef getJavaClassDefinition(String className, boolean useImport) {
        JavaClassDef def;
        block4: {
            def = null;
            try {
                def = this._quercus.getJavaClassDefinition(className);
                if (def == null && useImport) {
                    useImport = false;
                    def = this.importJavaClass(className);
                }
            }
            catch (Throwable e) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, e.toString(), e);
                }
                if (!useImport || (def = this.importJavaClass(className)) == null) break block4;
                return def;
            }
        }
        return def;
    }

    public JavaClassDef importJavaClass(String className) {
        if (this._importMap == null) {
            return null;
        }
        String fullName = this._importMap.getQualified(className);
        if (fullName != null) {
            return this.getJavaClassDefinition(fullName, false);
        }
        ArrayList<String> wildcardList = this._importMap.getWildcardList();
        for (String entry : wildcardList) {
            fullName = entry + '.' + className;
            try {
                JavaClassDef def = this.getJavaClassDefinition(fullName, false);
                if (def == null) continue;
                this._importMap.putQualified(className, fullName);
                return def;
            }
            catch (Exception e) {
                log.log(Level.ALL, e.toString(), e);
            }
        }
        return null;
    }

    public void putQualifiedImport(String javaName) {
        if (this._importMap == null) {
            this._importMap = new ImportMap();
        }
        String phpName = this._importMap.putQualified(javaName);
    }

    public void addWildcardImport(String name) {
        if (this._importMap == null) {
            this._importMap = new ImportMap();
        }
        this._importMap.addWildcardImport(name);
    }

    public Value wrapJava(Object obj, boolean isNullAsFalse) {
        if (obj == null) {
            if (isNullAsFalse) {
                return BooleanValue.FALSE;
            }
            return NullValue.NULL;
        }
        return this.wrapJava(obj);
    }

    public Value wrapJava(Object obj, JavaClassDef def, boolean isNullAsFalse) {
        if (obj == null) {
            if (isNullAsFalse) {
                return BooleanValue.FALSE;
            }
            return NullValue.NULL;
        }
        return this.wrapJava(obj, def);
    }

    public Value wrapJava(Object obj) {
        if (obj == null) {
            return NullValue.NULL;
        }
        if (obj instanceof Value) {
            return (Value)obj;
        }
        JavaClassDef def = this.getJavaClassDefinition(obj.getClass());
        return def.wrap(this, obj);
    }

    public Value wrapJava(Object obj, JavaClassDef def) {
        if (obj == null) {
            return NullValue.NULL;
        }
        if (obj instanceof Value) {
            return (Value)obj;
        }
        if (def.getType() != obj.getClass()) {
            def = this.getJavaClassDefinition(obj.getClass());
        }
        return def.wrap(this, obj);
    }

    public void addClassAlias(String alias, QuercusClass cls) {
        if (this._classAliasMap == null) {
            this._classAliasMap = new HashMap();
        }
        this._classAliasMap.put(alias, cls);
    }

    public QuercusClass findClassByAlias(String alias) {
        if (this._classAliasMap == null) {
            return null;
        }
        return this._classAliasMap.get(alias);
    }

    public QuercusClass findClass(String name) {
        return this.findClass(name, -1, true, true, true);
    }

    public QuercusClass findClass(String name, boolean useAutoload, boolean useImport, boolean useAliasMap) {
        return this.findClass(name, -1, useAutoload, useImport, useAliasMap);
    }

    public QuercusClass findClass(int id) {
        return this.findClass(null, id, true, true, true);
    }

    public QuercusClass findClass(int id, boolean useAutoload, boolean useImport, boolean useAliasMap) {
        return this.findClass(null, id, useAutoload, useImport, useAliasMap);
    }

    public QuercusClass findClass(String name, int id, boolean useAutoload, boolean useImport, boolean useAliasMap) {
        if (id < 0) {
            id = this._quercus.getClassId(name);
        }
        if (id < this._qClass.length && this._qClass[id] != null) {
            return this._qClass[id];
        }
        QuercusClass cl = this.createClassFromCache(id, useAutoload, useImport, useAliasMap);
        if (cl != null) {
            this._qClass[id] = cl;
            cl.init(this);
            return cl;
        }
        if (name == null) {
            name = this._quercus.getClassName(id);
        }
        QuercusClass qcl = null;
        if (useAliasMap) {
            qcl = this.findClassByAlias(name);
        }
        if (qcl == null) {
            qcl = this.findClassExt(name, id, useAutoload, useImport, useAliasMap);
        }
        if (qcl == null) {
            return null;
        }
        this._qClass[id] = qcl;
        return qcl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QuercusClass findClassExt(String name, int id, boolean useAutoload, boolean useImport, boolean useAliasMap) {
        if (id < 0) {
            id = this._quercus.getClassId(name);
        }
        if (useAutoload && !this._autoloadClasses.contains(name)) {
            try {
                this._autoloadClasses.add(name);
                StringValue nameString = this.createString(name);
                int size = this._autoloadList != null ? this._autoloadList.size() : 0;
                for (int i = 0; i < size; ++i) {
                    Callable cb = this._autoloadList.get(i);
                    cb.call(this, nameString);
                    QuercusClass cls = this.findClass(name, id, false, useImport, useAliasMap);
                    if (cls == null) continue;
                    QuercusClass quercusClass = cls;
                    return quercusClass;
                }
                if (size == 0) {
                    if (this._autoload == null) {
                        this._autoload = this.findFunction(this.createString("__autoload"));
                    }
                    if (this._autoload != null) {
                        this._autoload.call(this, nameString);
                        QuercusClass cls = this.findClass(name, id, false, useImport, useAliasMap);
                        if (cls != null) {
                            QuercusClass quercusClass = cls;
                            return quercusClass;
                        }
                    }
                }
            }
            finally {
                this._autoloadClasses.remove(name);
            }
        }
        if (useImport) {
            if (this.importPhpClass(name)) {
                return this.findClass(name, id, false, false, useAliasMap);
            }
            try {
                JavaClassDef javaClassDef = this.getJavaClassDefinition(name, true);
                if (javaClassDef != null) {
                    QuercusClass cls;
                    this._qClass[id] = cls = this.createQuercusClass(id, javaClassDef, null);
                    cls.init(this);
                    return cls;
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        return this._internalAutoload.loadClass(this, name);
    }

    public QuercusClass getClass(int classId) {
        ClassDef def;
        QuercusClass qClass;
        if (this._qClass.length <= classId) {
            QuercusClass[] oldClassList = this._qClass;
            this._qClass = new QuercusClass[classId + 256];
            System.arraycopy(oldClassList, 0, this._qClass, 0, oldClassList.length);
        }
        if ((qClass = this._qClass[classId]) != null) {
            return qClass;
        }
        if (this._classDef.length <= classId) {
            ClassDef[] oldClassDefList = this._classDef;
            this._classDef = new ClassDef[classId + 256];
            System.arraycopy(oldClassDefList, 0, this._classDef, 0, oldClassDefList.length);
        }
        if ((def = this._classDef[classId]) == null) {
            QuercusClass cl = this.findClass(null, classId, true, true, true);
            if (cl != null) {
                return cl;
            }
            this.error(L.l("'{0}' is an unknown class.", (Object)this._quercus.getClassName(classId)));
            throw new QuercusException(L.l("'{0}' is an unknown class.", (Object)this._quercus.getClassName(classId)));
        }
        int parentId = -1;
        if (def.getParentName() != null) {
            parentId = this._quercus.getClassId(def.getParentName());
        }
        this.addClass(def, classId, parentId);
        return this._qClass[classId];
    }

    public void addClass(ClassDef def, int classId, int parentId) {
        QuercusClass qClass;
        def = def.loadClassDef();
        QuercusClass parentClass = null;
        if (parentId >= 0) {
            parentClass = this.getClass(parentId);
        }
        if ((qClass = this._quercus.getCachedClass(classId)) == null || qClass.isModified() || qClass.getClassDef() != def || qClass.getParent() != parentClass) {
            qClass = this.createQuercusClass(classId, def, parentClass);
            this._quercus.setCachedClass(classId, qClass);
        }
        if (this._qClass.length <= classId) {
            QuercusClass[] oldClassList = this._qClass;
            this._qClass = new QuercusClass[classId + 256];
            System.arraycopy(oldClassList, 0, this._qClass, 0, oldClassList.length);
        }
        this._qClass[classId] = qClass;
        qClass.init(this);
    }

    public void addClass(String name, ClassDef def) {
        int id = this._quercus.getClassId(name);
        int parentId = -1;
        if (def.getParentName() != null) {
            parentId = this._quercus.getClassId(def.getParentName());
        }
        this.addClass(def, id, parentId);
    }

    private QuercusClass createClassFromCache(int id, boolean useAutoload, boolean useImport, boolean useAliasMap) {
        if (id < this._classDef.length && this._classDef[id] != null) {
            ClassDef classDef = this._classDef[id];
            String parentName = classDef.getParentName();
            QuercusClass parent = null;
            if (parentName != null) {
                parent = this.findClass(parentName, -1, useAutoload, useImport, useAliasMap);
            }
            if (parentName == null || parent != null) {
                return this.createQuercusClass(id, classDef, parent);
            }
            return null;
        }
        ClassDef staticClass = this._quercus.getClassDef(id);
        if (staticClass != null) {
            return this.createQuercusClass(id, staticClass, null);
        }
        return null;
    }

    public void addAutoloadFunction(Callable fun, boolean isPrepend) {
        if (fun == null) {
            throw new NullPointerException();
        }
        if (this._autoloadList == null) {
            this._autoloadList = new ArrayList();
        }
        if (isPrepend) {
            this._autoloadList.add(0, fun);
        } else {
            this._autoloadList.add(fun);
        }
    }

    public void removeAutoloadFunction(Callable fun) {
        if (this._autoloadList != null) {
            this._autoloadList.remove(fun);
            if (this._autoloadList.size() == 0) {
                this._autoloadList = null;
            }
        }
    }

    public ArrayList<Callable> getAutoloadFunctions() {
        return this._autoloadList;
    }

    public boolean importPhpClass(String name) {
        if (this._importMap == null) {
            return false;
        }
        String fullName = this._importMap.getQualifiedPhp(name);
        URL url = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (fullName != null) {
            url = loader.getResource(fullName);
        } else {
            String entry;
            Iterator<String> iterator = this._importMap.getWildcardPhpList().iterator();
            while (iterator.hasNext() && (url = loader.getResource((entry = iterator.next()) + '/' + name + ".php")) == null) {
            }
        }
        if (url != null) {
            this.includeOnce(this.createString(url.toString()));
            return true;
        }
        return false;
    }

    public Value getDeclaredClasses() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this._classDef.length; ++i) {
            if (this._classDef[i] == null) continue;
            list.add(this._classDef[i].getName());
        }
        HashMap<String, ClassDef> classMap = this.getModuleContext().getClassMap();
        for (Map.Entry<String, ClassDef> entry : classMap.entrySet()) {
            list.add(entry.getKey());
        }
        Collections.sort(list);
        ArrayValueImpl array = new ArrayValueImpl();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            array.put((String)iter.next());
        }
        return array;
    }

    public QuercusClass findAbstractClass(String name) {
        QuercusClass cl = this.findClass(name, -1, true, true, true);
        if (cl != null) {
            return cl;
        }
        throw this.createErrorException(L.l("'{0}' is an unknown class name.", (Object)name));
    }

    public QuercusClass getClass(String name) {
        QuercusClass cl = this.findClass(name);
        if (cl != null) {
            return cl;
        }
        throw this.createErrorException(L.l("'{0}' is an unknown class.", (Object)name));
    }

    public void clearClassCache() {
    }

    QuercusClass createJavaQuercusClass(JavaClassDef def) {
        int id = this.getQuercus().getClassId(def.getName());
        if (this._qClass.length <= id) {
            QuercusClass[] oldClassList = this._qClass;
            this._qClass = new QuercusClass[id + 256];
            System.arraycopy(oldClassList, 0, this._qClass, 0, oldClassList.length);
        }
        if (this._qClass[id] == null) {
            this._qClass[id] = def.getQuercusClass();
        }
        return this._qClass[id];
    }

    QuercusClass createQuercusClass(int id, ClassDef def, QuercusClass parent) {
        QuercusClass qClass = this._quercus.getCachedClass(id);
        if (this._qClass.length <= id) {
            QuercusClass[] oldClassList = this._qClass;
            this._qClass = new QuercusClass[id + 256];
            System.arraycopy(oldClassList, 0, this._qClass, 0, oldClassList.length);
        }
        if (qClass == null || qClass.isModified() || qClass.getClassDef() != def || qClass.getParent() != parent) {
            this._qClass[id] = qClass = new QuercusClass(this.getModuleContext(), def, parent);
            qClass.validate(this);
            this._quercus.setCachedClass(id, qClass);
        }
        this._qClass[id] = qClass;
        return qClass;
    }

    public boolean isInitializedClass(String name) {
        return this._initializedClassSet.contains(name);
    }

    public void addInitializedClass(String name) {
        this._initializedClassSet.add(name);
    }

    public AbstractFunction findFunction(String className, String methodName) {
        QuercusClass cl = this.findClass(className);
        if (cl == null) {
            throw new QuercusRuntimeException(L.l("'{0}' is an unknown class", (Object)className));
        }
        return cl.findFunction(methodName);
    }

    public Value requireOnce(StringValue include) {
        return this.include(this.getSelfDirectory(), include, true, true);
    }

    public Value require(StringValue include) {
        return this.include(this.getSelfDirectory(), include, true, false);
    }

    public Value include(StringValue include) {
        return this.include(this.getSelfDirectory(), include, false, false);
    }

    public Value includeOnce(StringValue include) {
        return this.include(this.getSelfDirectory(), include, false, true);
    }

    public Value includeOnce(Path scriptPwd, StringValue include, boolean isRequire) {
        return this.include(scriptPwd, include, isRequire, true);
    }

    public Value include(Path scriptPwd, StringValue include, boolean isRequire, boolean isOnce) {
        try {
            Path pwd = this.getPwd();
            Path path = this.lookupInclude(include, pwd, scriptPwd);
            if (path == null) {
                if (isRequire) {
                    this.error(L.l("'{0}' is not a valid include path", (Object)include));
                    return BooleanValue.FALSE;
                }
                this.warning(L.l("'{0}' is not a valid include path", (Object)include));
                return BooleanValue.FALSE;
            }
            if (!this._isAllowUrlInclude && this.isUrl(path)) {
                String msg = L.l("not allowed to include url {0}", (Object)path.getURL());
                log.warning(this.dbgId() + msg);
                this.error(msg);
                return BooleanValue.FALSE;
            }
            QuercusPage page = this._includeMap.get(path);
            if (page != null && isOnce) {
                return BooleanValue.TRUE;
            }
            if (page == null || page.isModified()) {
                page = this._quercus.parse(path);
                this.pageInit(page);
                this._includeMap.put(path, page);
            }
            return this.executePage(page);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    void executePage(Path path) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " execute " + path);
        }
        try {
            QuercusPage page = this._quercus.parse(path);
            this.pageInit(page);
            this.executePage(page);
        }
        catch (IOException e) {
            throw new QuercusException(e);
        }
    }

    private boolean isUrl(Path path) {
        String scheme = path.getScheme();
        if ("".equals(scheme) || "file".equals(scheme) || "memory".equals(scheme)) {
            return false;
        }
        if (path instanceof JarPath) {
            return this.isUrl(((JarPath)path).getContainer());
        }
        return !"php".equals(scheme) || "php://input".equals(path.toString()) || path.toString().startsWith("php://filter");
    }

    public Path lookupPwd(Value relPathV) {
        if (!relPathV.isset()) {
            return null;
        }
        StringValue relPath = relPathV.toStringValue();
        if (relPath.length() == 0) {
            return null;
        }
        Path path = this._lookupCache.get(relPath);
        if (path == null) {
            path = this.getPwd().lookup(this.normalizePath(relPath));
            this._lookupCache.put(relPath, path);
        }
        return path;
    }

    public Path lookup(StringValue relPath) {
        return this.lookupInclude(this.getSelfDirectory(), this.normalizePath(relPath));
    }

    public Path lookupInclude(StringValue relPath) {
        return this.lookupInclude(relPath, this.getPwd(), this.getSelfDirectory());
    }

    private Path lookupInclude(StringValue include, Path pwd, Path scriptPwd) {
        String includePath = this.getDefaultIncludePath();
        Path path = this._quercus.getIncludeCache(include, includePath, pwd, scriptPwd);
        if (path == null && (path = this.lookupIncludeImpl(include, pwd, scriptPwd)) != null) {
            this._quercus.putIncludeCache(include, includePath, pwd, scriptPwd, path);
        }
        if (path == NullPath.NULL) {
            path = null;
        }
        this._includePath = includePath;
        this._includePathIniCount = this._iniCount;
        return path;
    }

    private String getDefaultIncludePath() {
        String includePath = this._includePath;
        if (this._includePathIniCount != this._iniCount) {
            includePath = QuercusContext.INI_INCLUDE_PATH.getAsString(this);
            this._includePath = null;
            this._includePathList = null;
        }
        if (includePath == null) {
            includePath = ".";
        }
        return includePath;
    }

    private Path lookupIncludeImpl(StringValue includeValue, Path pwd, Path scriptPwd) {
        String include = this.normalizePath(includeValue);
        Path path = this.lookupInclude(pwd, include);
        if (path == null) {
            path = this.lookupInclude(scriptPwd, include);
        }
        if (path == null && !this.includeExists(path = scriptPwd.lookup(include))) {
            path = null;
        }
        return path;
    }

    private Path lookupInclude(Path pwd, String relPath) {
        ArrayList<Path> pathList = this.getIncludePath(pwd);
        for (int i = 0; i < pathList.size(); ++i) {
            Path path = pathList.get(i).lookup(relPath);
            if (!path.canRead() || path.isDirectory()) continue;
            return path;
        }
        return null;
    }

    private boolean includeExists(Path path) {
        if (path.canRead() && !path.isDirectory()) {
            return true;
        }
        if (!this.getQuercus().isRequireSource()) {
            return this.getQuercus().includeExists(path);
        }
        return false;
    }

    private ArrayList<Path> getIncludePath(Path pwd) {
        ArrayList<Path> pathList;
        String includePath = this.getDefaultIncludePath();
        if (this._includePathList == null) {
            String subpath;
            int tail;
            this._includePathList = new ArrayList();
            this._includePathMap = new HashMap();
            int head = 0;
            String pathSeparator = FileModule.PATH_SEPARATOR;
            int length = pathSeparator.length();
            while ((tail = includePath.indexOf(pathSeparator, head)) >= 0) {
                subpath = includePath.substring(head, tail);
                this._includePathList.add(this.normalizePath(subpath));
                head = tail + length;
            }
            subpath = includePath.substring(head);
            this._includePathList.add(this.normalizePath(subpath));
            this._includePath = includePath;
            this._includePathIniCount = this._iniCount;
        }
        if ((pathList = this._includePathMap.get(pwd)) == null) {
            pathList = new ArrayList();
            if (pwd != null) {
                for (int i = 0; i < this._includePathList.size(); ++i) {
                    pathList.add(pwd.lookup(this._includePathList.get(i)));
                }
                this._includePathMap.put(pwd, pathList);
            }
        }
        return pathList;
    }

    public String setIncludePath(String path) {
        String prevIncludePath = QuercusContext.INI_INCLUDE_PATH.getAsString(this);
        if (this._defaultIncludePath == null) {
            this._defaultIncludePath = prevIncludePath;
        }
        QuercusContext.INI_INCLUDE_PATH.set(this, path);
        this._includePathIniCount = -1;
        return prevIncludePath;
    }

    public String normalizePath(CharSequence path) {
        if (Path.isWindows()) {
            char ch3;
            char ch;
            this._cb.setLength(0);
            int len = path.length();
            if (len >= 3 && path.charAt(1) == ':' && ('a' <= (ch = path.charAt(0)) && ch <= 'z' || 'A' <= ch && ch <= 'Z') && (ch3 = path.charAt(2)) != '/' && ch3 != '\\') {
                this._cb.append(ch);
                this._cb.append(':');
                this._cb.append('\\');
                this._cb.append(ch3);
                for (int i = 3; i < len; ++i) {
                    this._cb.append(path.charAt(i));
                }
                return this._cb.toString();
            }
        }
        return path.toString();
    }

    public void restoreIncludePath() {
        QuercusContext.INI_INCLUDE_PATH.set(this, this._defaultIncludePath);
    }

    public ArrayValue getIncludedFiles() {
        ArrayValueImpl array = new ArrayValueImpl();
        ArrayList<String> list = new ArrayList<String>();
        for (Path path : this._includeMap.keySet()) {
            list.add(path.getNativePath());
        }
        Collections.sort(list);
        for (String pathName : list) {
            ((ArrayValue)array).put(this.createString(pathName));
        }
        return array;
    }

    public Value suppress(int errorMask, Value value) {
        this.setErrorMask(errorMask);
        return value;
    }

    public Value exit(Value msg) {
        if (msg.isNull() || msg instanceof LongValue) {
            return this.exit();
        }
        try {
            this.getOut().print(msg.toString());
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        throw new QuercusExitException(msg.toString() + "\n" + this.getStackTraceAsString());
    }

    public Value exit() {
        throw new QuercusExitException(this.getStackTraceAsString());
    }

    public Value die(String msg) {
        try {
            this.getOut().print(msg);
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        throw new QuercusDieException(msg + "\n" + this.getStackTraceAsString());
    }

    public Value die() {
        throw new QuercusDieException(this.getStackTraceAsString());
    }

    public Value cast(Class<?> cl, Value value) {
        if ((value = value.toValue()).isNull()) {
            return null;
        }
        if (cl.isAssignableFrom(value.getClass())) {
            return value;
        }
        this.warning(L.l("{0} ({1}) is not assignable to {2}", (Object)value, (Object)value.getClass().getName(), (Object)cl.getName()));
        return null;
    }

    public static Value first(Value value) {
        return value;
    }

    public static Value first(Value value, Value a1) {
        return value;
    }

    public static Value first(Value value, double a1) {
        return value;
    }

    public static long first(long value, Value a1) {
        return value;
    }

    public static double first(double value, Value a1) {
        return value;
    }

    public static long first(long value, double a1) {
        return value;
    }

    public static long first(long value, long a1) {
        return value;
    }

    public static double first(double value, double a1) {
        return value;
    }

    public static Value first(Value value, Value a1, Value a2) {
        return value;
    }

    public static Value first(Value value, Value a1, Value a2, Value a3) {
        return value;
    }

    public static Value first(Value value, Value a1, Value a2, Value a3, Value a4) {
        return value;
    }

    public static Value first(Value value, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return value;
    }

    public Value expectString(Value value) {
        if (!(value.isString() || value.isLong() || value.isDouble() || value.isBoolean() || value.isNull())) {
            return new UnexpectedValue(value);
        }
        return value;
    }

    public Value expectNumeric(Value value) {
        if (!value.isNull() && !value.isLongConvertible()) {
            return new UnexpectedValue(value);
        }
        return value;
    }

    public Value expectBoolean(Value value) {
        if (!(value.isBoolean() || value.isNull() || value.isString() || value.isNumeric())) {
            return new UnexpectedValue(value);
        }
        return value;
    }

    public void checkTypeHint(Value value, String type, String argName, String functionName) {
        if (value.isNull()) {
            this.error(L.l("'{0}' is an unexpected value for arg '{1}' in function '{2}', expected '{3}'", (Object)value, (Object)argName, (Object)functionName, (Object)type));
        }
    }

    public Value thisError(Location location) {
        return this.error(L.l("Cannot use '$this' when not in object context."), location);
    }

    public Value thisError() {
        return this.thisError(this.getLocation());
    }

    public Value error(String msg) {
        return this.error(0, msg, this.getLocation());
    }

    public Value error(String msg, Location location) {
        return this.error(0, msg, location);
    }

    public Value error(String msg, Throwable e) {
        log.log(Level.WARNING, e.toString(), e);
        return this.error(msg);
    }

    public Value error(Throwable e) {
        log.log(Level.WARNING, e.toString(), e);
        return this.error(e.toString());
    }

    public QuercusRuntimeException createErrorException(String msg) throws QuercusRuntimeException {
        return this.createErrorException(null, msg);
    }

    public QuercusRuntimeException createErrorException(Location location, String msg) throws QuercusRuntimeException {
        if (location == null || location.isUnknown()) {
            location = this.getLocation();
        }
        String prefix = location.getMessagePrefix();
        String fullMsg = msg + this.getFunctionLocation();
        this.error(0, fullMsg, location);
        return new QuercusRuntimeException(fullMsg);
    }

    public QuercusRuntimeException createErrorException(Throwable e) throws QuercusRuntimeException {
        Location location = this.getLocation();
        String prefix = location.getMessagePrefix();
        String fullMsg = e.toString() + this.getFunctionLocation();
        this.error(0, fullMsg, location);
        String exMsg = prefix + fullMsg + this.getStackTraceAsString(e, null);
        return new QuercusRuntimeException(exMsg, e);
    }

    public Value warning(String msg) {
        int mask = 2;
        if ((this.getErrorMask() & mask) != 0 && log.isLoggable(Level.FINER)) {
            QuercusException e = new QuercusException(this.getExceptionLocation(msg));
            log.log(Level.FINER, e.toString(), e);
        }
        return this.error(1, msg, this.getLocation());
    }

    private String getExceptionLocation(String msg) {
        return this.getExceptionLocation(msg, this.getLocation());
    }

    private String getExceptionLocation(String msg, Location loc) {
        if (loc != null && !loc.isUnknown()) {
            return loc.getFileName() + ":" + loc.getLineNumber() + ": " + msg + this.getFunctionLocation() + this.getStackTraceAsString(null);
        }
        return msg + this.getFunctionLocation() + this.getStackTraceAsString();
    }

    public Value warning(String msg, Location location) {
        int mask = 2;
        if ((this.getErrorMask() & mask) != 0 && log.isLoggable(Level.FINER)) {
            QuercusException e = new QuercusException(msg);
            log.log(Level.FINER, e.toString(), e);
        }
        return this.error(1, msg, location);
    }

    public Value warning(String msg, Throwable e) {
        log.log(Level.FINE, e.toString(), e);
        return this.warning(msg);
    }

    public Value warning(String msg, Location location, Throwable e) {
        log.log(Level.FINE, e.toString(), e);
        return this.warning(msg, location);
    }

    public Value warning(Throwable e) {
        return this.warning(e.toString(), e);
    }

    public Value warning(Throwable e, Location location) {
        return this.warning(e.toString(), location, e);
    }

    public Value strict(String msg) {
        if (log.isLoggable(Level.FINER)) {
            QuercusException e = new QuercusException(msg);
            log.log(Level.FINER, e.toString(), e);
        }
        return this.error(11, msg, this.getLocation());
    }

    public Value invalidArgument(String name, Object value) {
        return this.warning(L.l("invalid value `{0}' for `{1}'", value, (Object)name));
    }

    public Value deprecatedArgument(String name) {
        return this.strict(L.l("argument `{1}' is deprecated", (Object)name));
    }

    public Value notice(String msg) {
        return this.error(3, msg, this.getLocation());
    }

    public Value notice(Throwable e) {
        log.log(Level.FINE, e.toString(), e);
        return this.notice(e.toString());
    }

    public Value notice(String msg, Throwable e) {
        log.log(Level.FINE, e.toString(), e);
        return this.notice(msg);
    }

    public Value stub(String msg) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.getLocation().getMessagePrefix() + msg);
        }
        return NullValue.NULL;
    }

    public static Value nullAsFalse(Value value) {
        return value == null || value.isNull() ? BooleanValue.FALSE : value;
    }

    public Value parse(String msg) throws Exception {
        return this.error(2, msg);
    }

    public Value compileError(String msg) {
        return this.error(6, msg);
    }

    public Value compileWarning(String msg) {
        return this.error(7, msg);
    }

    public int getErrorMask() {
        return this.getIni("error_reporting").toInt();
    }

    public int setErrorMask(int mask) {
        int oldMask = this.getErrorMask();
        this.setIni("error_reporting", LongValue.create(mask));
        return oldMask;
    }

    public void setErrorHandler(int mask, Callable fun) {
        for (int i = 0; i < this._errorHandlers.length; ++i) {
            this._prevErrorHandlers[i] = this._errorHandlers[i];
        }
        if ((mask & 1) != 0) {
            this._errorHandlers[0] = fun;
        }
        if ((mask & 2) != 0) {
            this._errorHandlers[1] = fun;
        }
        if ((mask & 4) != 0) {
            this._errorHandlers[2] = fun;
        }
        if ((mask & 8) != 0) {
            this._errorHandlers[3] = fun;
        }
        if ((mask & 0x100) != 0) {
            this._errorHandlers[8] = fun;
        }
        if ((mask & 0x200) != 0) {
            this._errorHandlers[9] = fun;
        }
        if ((mask & 0x400) != 0) {
            this._errorHandlers[10] = fun;
        }
        if ((mask & 0x800) != 0) {
            this._errorHandlers[11] = fun;
        }
        if ((mask & 0x1000) != 0) {
            this._errorHandlers[12] = fun;
        }
    }

    public void restoreErrorHandler() {
        for (int i = 0; i < this._errorHandlers.length; ++i) {
            this._errorHandlers[i] = this._prevErrorHandlers[i];
        }
    }

    public Callable getExceptionHandler() {
        return this._exceptionHandler;
    }

    public Value setExceptionHandler(Callable fun) {
        this._prevExceptionHandler = this._exceptionHandler;
        this._exceptionHandler = fun;
        if (this._prevExceptionHandler != null) {
            return ((Value)((Object)this._prevExceptionHandler)).toStringValue();
        }
        return NullValue.NULL;
    }

    public void restoreExceptionHandler() {
        this._exceptionHandler = this._prevExceptionHandler;
    }

    public Value error(int code, String msg) {
        return this.error(code, msg, this.getLocation());
    }

    public Value error(int code, String msg, Location location) {
        int mask;
        if (location == null || location.isUnknown()) {
            location = this.getLocation();
        }
        this._lastErrorType = mask = 1 << code;
        this._lastErrorMessage = msg;
        this._lastErrorLocation = location;
        int errorMask = this.getErrorMask();
        if (log.isLoggable(Level.FINEST)) {
            QuercusException e = new QuercusException(location.getMessagePrefix() + msg);
            log.log(Level.FINEST, e.toString(), e);
        }
        if ((errorMask & mask) != 0 && log.isLoggable(Level.FINE)) {
            log.fine(this + " " + location.getMessagePrefix() + this.getExceptionLocation(msg));
        }
        if (code >= 0 && code < this._errorHandlers.length && this._errorHandlers[code] != null) {
            Callable handler = this._errorHandlers[code];
            try {
                this._errorHandlers[code] = null;
                Value fileNameV = NullValue.NULL;
                String fileName = location.getFileName();
                if (fileName != null) {
                    fileNameV = this.createString(fileName);
                }
                Value lineV = NullValue.NULL;
                int line = location.getLineNumber();
                if (line > 0) {
                    lineV = LongValue.create(line);
                }
                NullValue context = NullValue.NULL;
                handler.call(this, LongValue.create(mask), this.createString(msg), fileNameV, lineV, context);
                NullValue nullValue = NullValue.NULL;
                return nullValue;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this._errorHandlers[code] = handler;
            }
        }
        if ((errorMask & mask) != 0) {
            try {
                String fullMsg = log.isLoggable(Level.FINE) ? location.getMessagePrefix() + this.getCodeName(mask) + this.getExceptionLocation(msg) : location.getMessagePrefix() + this.getCodeName(mask) + msg + this.getFunctionLocation();
                if (this.getIniBoolean("track_errors")) {
                    this.setGlobalValue("php_errormsg", (Value)this.createString(fullMsg));
                }
                if ("stderr".equals(this.getIniString("display_errors"))) {
                    System.err.println("\n" + fullMsg);
                } else if (this.getIniBoolean("display_errors")) {
                    this.getOut().println("\n" + fullMsg);
                }
                if (this.getIniBoolean("log_errors")) {
                    log.info(fullMsg);
                }
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        if ((mask & 0x151) != 0) {
            QuercusErrorException exn = new QuercusErrorException(msg);
            exn.fillInStackTrace();
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, exn.toString(), exn);
            }
            throw exn;
        }
        return NullValue.NULL;
    }

    public Value getLastError() {
        if (this._lastErrorType < 0) {
            return NullValue.NULL;
        }
        ArrayValueImpl array = new ArrayValueImpl();
        array.put(this.createString("type"), LongValue.create(this._lastErrorType));
        array.put(this.createString("message"), this.createString(this._lastErrorMessage));
        String file = "";
        int line = -1;
        if (this._lastErrorLocation != null) {
            file = this._lastErrorLocation.getFileName();
            line = this._lastErrorLocation.getLineNumber();
        }
        array.put(this.createString("file"), this.createString(file));
        array.put(this.createString("line"), LongValue.create(line));
        return array;
    }

    private String getCodeName(int code) {
        switch (code) {
            case 1: {
                return "Fatal Error: ";
            }
            case 2: {
                return "Warning: ";
            }
            case 4: {
                return "Parse Error: ";
            }
            case 8: {
                return "Notice: ";
            }
            case 16: {
                return "Fatal Error: ";
            }
            case 32: {
                return "Warning: ";
            }
            case 64: {
                return "Fatal Error: ";
            }
            case 128: {
                return "Warning : ";
            }
            case 256: {
                return "Fatal Error: ";
            }
            case 512: {
                return "Warning: ";
            }
            case 1024: {
                return "Notice: ";
            }
            case 2048: {
                return "Notice: ";
            }
            case 4096: {
                return "Error: ";
            }
        }
        return String.valueOf("ErrorCode(" + code + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getSourceLine(Path path, int sourceLine, int length) {
        if (path == null) {
            return null;
        }
        if (path instanceof NullPath) {
            return null;
        }
        try (ReadStream is = null;){
            String lineString;
            is = path.openRead();
            for (int line = 1; line < sourceLine; ++line) {
                lineString = is.readLine();
                if (lineString != null) continue;
                String[] stringArray = null;
                return stringArray;
            }
            String[] result = new String[length];
            for (int i = line - sourceLine; i < length && (lineString = is.readLine()) != null; ++i) {
                result[i] = lineString;
            }
            String[] stringArray = result;
            return stringArray;
        }
        return null;
    }

    public final Location setLocation(Location newLocation) {
        Location location = this._location;
        this._location = newLocation;
        return location;
    }

    protected final Location getLocationImpl() {
        return this._location;
    }

    public Location getLocation() {
        Location location = this._location;
        if (location != null) {
            return location;
        }
        Expr call = this.peekCall(0);
        if (call != null) {
            return call.getLocation();
        }
        return Location.UNKNOWN;
    }

    public int getSourceLine(String className, int javaLine) {
        return javaLine;
    }

    public String getFunctionLocation() {
        Expr call = this.peekCall(0);
        if (call != null) {
            return call.getFunctionLocation();
        }
        return "";
    }

    public static Value toValue(boolean value) {
        return value ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    public static Value toValue(long value) {
        return LongValue.create(value);
    }

    public static Var toVar(Value value) {
        if (value instanceof Var) {
            return (Var)value;
        }
        if (value == null) {
            return new Var();
        }
        return new Var(value);
    }

    public static Value setFieldVar(Value oldValue, Value value) {
        if (value instanceof Var) {
            return value;
        }
        if (oldValue instanceof Var) {
            return new Var(value);
        }
        return value;
    }

    public static Value setRef(Value oldValue, Value value) {
        if (value instanceof Var) {
            return value;
        }
        return new Var(value);
    }

    public static Var setEnvRef(Var oldVar, Value value) {
        if (value instanceof Var) {
            return (Var)value;
        }
        oldVar.set(value);
        return oldVar;
    }

    public static Value comma(Value a0, Value a1) {
        return a1;
    }

    public static Value comma(Value a0, Value a1, Value a2) {
        return a2;
    }

    public static Value comma(Value a0, Value a1, Value a2, Value a3) {
        return a3;
    }

    public static Value comma(Value a0, Value a1, Value a2, Value a3, Value a4) {
        return a4;
    }

    public static long comma(Value a0, long a1) {
        return a1;
    }

    public static long comma(long a0, long a1) {
        return a1;
    }

    public static Value comma(long a0, Value a1) {
        return a1;
    }

    public static double comma(Value a0, double a1) {
        return a1;
    }

    public static double comma(double a0, double a1) {
        return a1;
    }

    public static Value comma(double a0, Value a1) {
        return a1;
    }

    public String toString() {
        return "Env[]";
    }

    public Value ifNull(Value condition, Value ifNull, Value ifNotNull) {
        return condition.isNull() ? ifNull : ifNotNull;
    }

    public LocaleInfo getLocaleInfo() {
        if (this._locale == null) {
            this._locale = new LocaleInfo();
        }
        return this._locale;
    }

    public long getMicroTime() {
        long nanoTime = this._quercus.getExactTimeNanoseconds();
        if (this._firstMicroTime <= 0L) {
            this._firstNanoTime = nanoTime;
            this._firstMicroTime = this._quercus.getExactTime() * 1000L + this._firstNanoTime % 1000000L / 1000L;
            return this._firstMicroTime;
        }
        long microDiff = (nanoTime - this._firstNanoTime) / 1000L;
        return this._firstMicroTime + microDiff;
    }

    public void addShutdown(Callable callback, Value[] args) {
        if (this._shutdownList == null) {
            this._shutdownList = new ArrayList();
        }
        this._shutdownList.add(new Shutdown(callback, args));
    }

    public void setGzStream(Object obj) {
        this._gzStream = obj;
    }

    public Object getGzStream() {
        return this._gzStream;
    }

    public void startDuplex(Object duplex) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void closeDuplex() {
        this._duplex = null;
        this.close();
    }

    public Object getDuplex() {
        return this._duplex;
    }

    public void close() {
        this._quercus.completeEnv(this);
        try {
            while (this._outputBuffer != null) {
                this.popOutputBuffer();
            }
        }
        finally {
            this.cleanup();
        }
    }

    private void cleanup() {
        if (this._shutdownList != null) {
            for (int i = 0; i < this._shutdownList.size(); ++i) {
                try {
                    this._shutdownList.get(i).call(this);
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
        try {
            this.sessionWriteClose();
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        int count = 0;
        if (this._objCleanupList != null) {
            int size;
            while ((size = this._objCleanupList.size()) > 0) {
                if (++count % 100 == 0) {
                    this.updateTimeout();
                    if (this._isTimeout) {
                        log.log(Level.WARNING, "script has timed out while calling __destruct()");
                        break;
                    }
                }
                ObjectValue obj = this._objCleanupList.remove(size - 1);
                try {
                    if (obj == null) continue;
                    obj.cleanup(this);
                }
                catch (Throwable e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
        }
        if (this._cleanupList != null) {
            ArrayList<EnvCleanup> cleanupList = new ArrayList<EnvCleanup>(this._cleanupList);
            for (int i = cleanupList.size() - 1; i >= 0; --i) {
                EnvCleanup envCleanup = cleanupList.get(i);
                try {
                    if (envCleanup == null) continue;
                    envCleanup.cleanup();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
        }
        _threadEnv.set(this._oldThreadEnv);
        for (int i = 0; this._removePaths != null && i < this._removePaths.size(); ++i) {
            Path path = this._removePaths.get(i);
            try {
                path.remove();
                continue;
            }
            catch (IOException e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        AbstractFunction[] fun = this._fun;
        this._fun = null;
        if (fun != null) {
            boolean isUsed = false;
            if (this._page != null && this._page.setRuntimeFunction(fun)) {
                isUsed = true;
            }
            for (QuercusPage page : this._includeMap.values()) {
                if (!page.setRuntimeFunction(fun)) continue;
                isUsed = true;
            }
            if (!isUsed) {
                for (int i = fun.length - 1; i >= 0; --i) {
                    fun[i] = null;
                }
                _freeFunList.free(fun);
            }
        }
        ClassDef[] classDef = this._classDef;
        this._classDef = null;
        if (classDef != null) {
            for (int i = 0; i < classDef.length; ++i) {
                classDef[i] = null;
            }
            _freeClassDefList.free(classDef);
        }
        QuercusClass[] qClass = this._qClass;
        this._qClass = null;
        if (qClass != null) {
            for (int i = 0; i < qClass.length; ++i) {
                qClass[i] = null;
            }
            _freeClassList.free(qClass);
        }
        Value[] consts = this._const;
        this._const = null;
        if (consts != null) {
            for (int i = 0; i < consts.length; ++i) {
                consts[i] = null;
            }
            _freeConstList.free(consts);
        }
        if (this._gmtDate != null) {
            _freeGmtDateList.free(this._gmtDate);
        }
        if (this._localDate != null) {
            _freeLocalDateList.free(this._localDate);
        }
    }

    public void sessionWriteClose() {
        SessionArrayValue session = this._session;
        this._session = null;
        if (session != null) {
            SessionCallback callback = this.getSessionCallback();
            if (callback != null) {
                String value = session.getSize() > 0 ? VariableModule.serialize(this, session.getArray()) : "";
                callback.write(this, session.getId(), value);
                callback.close(this);
            } else {
                this._quercus.saveSession(this, session);
                Value sessionCopy = session.copy(this);
                this.setGlobalValue("_SESSION", sessionCopy);
                this.setGlobalValue("HTTP_SESSION_VARS", sessionCopy);
            }
        }
    }

    public String dbgId() {
        return this.getClass().getSimpleName() + "[" + this._selfPath + "] ";
    }

    static {
        SPECIAL_VARS.put(new ConstStringValue("GLOBALS"), 5);
        SPECIAL_VARS.put(new ConstStringValue("_SERVER"), 1);
        SPECIAL_VARS.put(new ConstStringValue("_GET"), 2);
        SPECIAL_VARS.put(new ConstStringValue("_POST"), 3);
        SPECIAL_VARS.put(new ConstStringValue("_FILES"), 12);
        SPECIAL_VARS.put(new ConstStringValue("_REQUEST"), 6);
        SPECIAL_VARS.put(new ConstStringValue("_COOKIE"), 4);
        SPECIAL_VARS.put(new ConstStringValue("_SESSION"), 7);
        SPECIAL_VARS.put(new ConstStringValue("_ENV"), 14);
        SPECIAL_VARS.put(new ConstStringValue("argc"), 17);
        SPECIAL_VARS.put(new ConstStringValue("argv"), 18);
        SPECIAL_VARS.put(new ConstStringValue("HTTP_GET_VARS"), 8);
        SPECIAL_VARS.put(new ConstStringValue("HTTP_POST_VARS"), 9);
        SPECIAL_VARS.put(new ConstStringValue("HTTP_POST_FILES"), 13);
        SPECIAL_VARS.put(new ConstStringValue("HTTP_COOKIE_VARS"), 10);
        SPECIAL_VARS.put(new ConstStringValue("HTTP_SERVER_VARS"), 15);
        SPECIAL_VARS.put(new ConstStringValue("PHP_SELF"), 11);
        SPECIAL_VARS.put(new ConstStringValue("HTTP_RAW_POST_DATA"), 16);
        SPECIAL_VARS_U.put(new UnicodeBuilderValue("GLOBALS"), 5);
        SPECIAL_VARS_U.put(new UnicodeBuilderValue("_SERVER"), 1);
        SPECIAL_VARS_U.put(new UnicodeBuilderValue("_GET"), 2);
        SPECIAL_VARS_U.put(new UnicodeBuilderValue("_POST"), 3);
        SPECIAL_VARS_U.put(new UnicodeBuilderValue("_FILES"), 12);
        SPECIAL_VARS_U.put(new UnicodeBuilderValue("_REQUEST"), 6);
        SPECIAL_VARS_U.put(new UnicodeBuilderValue("_COOKIE"), 4);
        SPECIAL_VARS_U.put(new UnicodeBuilderValue("_SESSION"), 7);
        SPECIAL_VARS_U.put(new UnicodeBuilderValue("_ENV"), 14);
        SPECIAL_VARS_U.put(new UnicodeBuilderValue("argc"), 17);
        SPECIAL_VARS_U.put(new UnicodeBuilderValue("argv"), 18);
        SPECIAL_VARS_U.put(new UnicodeBuilderValue("HTTP_GET_VARS"), 8);
        SPECIAL_VARS_U.put(new UnicodeBuilderValue("HTTP_POST_VARS"), 9);
        SPECIAL_VARS_U.put(new UnicodeBuilderValue("HTTP_POST_FILES"), 13);
        SPECIAL_VARS_U.put(new UnicodeBuilderValue("HTTP_COOKIE_VARS"), 10);
        SPECIAL_VARS_U.put(new UnicodeBuilderValue("HTTP_SERVER_VARS"), 15);
        SPECIAL_VARS_U.put(new UnicodeBuilderValue("PHP_SELF"), 11);
        SPECIAL_VARS_U.put(new UnicodeBuilderValue("HTTP_RAW_POST_DATA"), 16);
        DEFAULT_QUERY_SEPARATOR_MAP = new int[128];
        Env.DEFAULT_QUERY_SEPARATOR_MAP[38] = 1;
    }

    static class ClassKey {
        private final WeakReference<ClassDef> _defRef;
        private final WeakReference<QuercusClass> _parentRef;
        private final int _hash;

        ClassKey(ClassDef def, QuercusClass parent) {
            this._defRef = new WeakReference<ClassDef>(def);
            this._parentRef = parent != null ? new WeakReference<QuercusClass>(parent) : null;
            int hash = 37;
            if (def != null) {
                hash = 65521 * hash + def.hashCode();
            }
            if (parent != null) {
                hash = 65521 * hash + parent.hashCode();
            }
            this._hash = hash;
        }

        public int hashCode() {
            return this._hash;
        }

        public boolean equals(Object o) {
            ClassDef bDef;
            ClassKey key = (ClassKey)o;
            ClassDef aDef = (ClassDef)this._defRef.get();
            if (aDef != (bDef = (ClassDef)key._defRef.get())) {
                return false;
            }
            if (this._parentRef == key._parentRef) {
                return true;
            }
            if (this._parentRef == null || key._parentRef == null) {
                return false;
            }
            QuercusClass aParent = (QuercusClass)this._parentRef.get();
            QuercusClass bParent = (QuercusClass)key._parentRef.get();
            return aParent != null && aParent.equals(bParent);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._defRef.get() + "," + (this._parentRef != null ? (QuercusClass)this._parentRef.get() : null) + "]";
        }
    }

    static class FieldGetEntry {
        private final String _className;
        private final StringValue _fieldName;

        FieldGetEntry(String className, StringValue fieldName) {
            this._className = className;
            this._fieldName = fieldName;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FieldGetEntry)) {
                return false;
            }
            FieldGetEntry entry = (FieldGetEntry)o;
            return entry._className.equals(this._className) && entry._fieldName.equals(this._fieldName);
        }
    }

    public static enum OVERLOADING_TYPES {
        INVALID_FIRST,
        FIELDGET,
        FIELDSET,
        ISSET,
        UNSET,
        INVALID_LAST;

    }
}

