/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import java.util.ArrayList;
import java.util.HashMap;

public class ImportMap {
    HashMap<String, String> _qualifiedMap;
    ArrayList<String> _wildcardList;
    ArrayList<String> _wildcardPhpList;

    public void addWildcardImport(String name) {
        if (this._wildcardList == null) {
            this._wildcardList = new ArrayList();
            this._wildcardPhpList = new ArrayList();
        }
        this._wildcardList.add(name);
        this._wildcardPhpList.add(name.replace('.', '/'));
    }

    public String putQualified(String name) {
        int i;
        if (this._qualifiedMap == null) {
            this._qualifiedMap = new HashMap();
        }
        String shortName = (i = name.lastIndexOf(46)) > 0 ? name.substring(i + 1) : name;
        this.putQualified(shortName, name);
        return shortName;
    }

    public void putQualified(String shortName, String name) {
        if (this._qualifiedMap == null) {
            this._qualifiedMap = new HashMap();
        }
        this._qualifiedMap.put(shortName, name);
    }

    public String getQualified(String name) {
        if (this._qualifiedMap == null) {
            return null;
        }
        return this._qualifiedMap.get(name);
    }

    public String getQualifiedPhp(String name) {
        if (this._qualifiedMap == null) {
            return null;
        }
        String fullName = this._qualifiedMap.get(name);
        if (fullName != null) {
            fullName = fullName.replace('.', '/') + ".php";
        }
        return fullName;
    }

    public ArrayList<String> getWildcardList() {
        if (this._wildcardList == null) {
            this._wildcardList = new ArrayList();
        }
        return this._wildcardList;
    }

    public ArrayList<String> getWildcardPhpList() {
        if (this._wildcardPhpList == null) {
            this._wildcardPhpList = new ArrayList();
        }
        return this._wildcardPhpList;
    }

    public ImportMap copy() {
        ImportMap copy = new ImportMap();
        if (this._qualifiedMap != null) {
            copy._qualifiedMap = new HashMap<String, String>(this._qualifiedMap);
        }
        if (this._wildcardList != null) {
            copy._wildcardList = new ArrayList<String>(this._wildcardList);
        }
        if (this._wildcardPhpList != null) {
            copy._wildcardPhpList = new ArrayList<String>(this._wildcardPhpList);
        }
        return copy;
    }

    public void clear() {
        if (this._qualifiedMap != null) {
            this._qualifiedMap.clear();
        }
        if (this._wildcardList != null) {
            this._wildcardList.clear();
        }
        if (this._wildcardPhpList != null) {
            this._wildcardPhpList.clear();
        }
    }
}

