/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaAdapterVar;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.marshal.Marshal;
import com.caucho.quercus.marshal.MarshalFactory;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class JavaAdapter
extends ArrayValue
implements Serializable {
    private static final Logger log = Logger.getLogger(JavaAdapter.class.getName());
    private WeakReference<Env> _envRef;
    private Object _object;
    private JavaClassDef _classDef;

    protected JavaAdapter(Object object, JavaClassDef def) {
        this._object = object;
        this._classDef = def;
    }

    public JavaClassDef getClassDef() {
        return this._classDef;
    }

    public Env getEnv() {
        return Env.getCurrent();
    }

    public Value wrapJava(Object obj) {
        return this.getEnv().wrapJava(obj);
    }

    @Override
    public Object toObject() {
        return null;
    }

    @Override
    public Object toJavaObject() {
        return this._object;
    }

    public Object toJavaObjectNotNull(Env env, Class type) {
        if (type.isAssignableFrom(this._object.getClass())) {
            return this._object;
        }
        env.warning(L.l("Can't assign {0} to {1}", (Object)this._object.getClass().getName(), (Object)type.getName()));
        return null;
    }

    @Override
    public Value toObject(Env env) {
        ObjectValue obj = env.createObject();
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            Value key = entry.getKey();
            if (!(key instanceof StringValue)) continue;
            ((Value)obj).putField(env, key.toString(), entry.getValue());
        }
        return obj;
    }

    @Override
    public Collection toJavaCollection(Env env, Class type) {
        Collection<Object> coll = null;
        if (type.isAssignableFrom(HashSet.class)) {
            coll = new HashSet();
        } else if (type.isAssignableFrom(TreeSet.class)) {
            coll = new TreeSet();
        } else {
            try {
                coll = (Collection)type.newInstance();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
                env.warning(L.l("Can't assign array to {0}", (Object)type.getName()));
                return null;
            }
        }
        for (Map.Entry<Object, Object> entry : this.objectEntrySet()) {
            coll.add(entry.getValue());
        }
        return coll;
    }

    @Override
    public List toJavaList(Env env, Class type) {
        List<Object> list = null;
        if (type.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else if (type.isAssignableFrom(LinkedList.class)) {
            list = new LinkedList();
        } else if (type.isAssignableFrom(Vector.class)) {
            list = new Vector();
        } else {
            try {
                list = (List)type.newInstance();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
                env.warning(L.l("Can't assign array to {0}", (Object)type.getName()));
                return null;
            }
        }
        for (Map.Entry<Object, Object> entry : this.objectEntrySet()) {
            list.add(entry.getValue());
        }
        return list;
    }

    public Map toJavaMap(Env env, Class type) {
        Map<Object, Object> map = null;
        if (type.isAssignableFrom(TreeMap.class)) {
            map = new TreeMap();
        } else if (type.isAssignableFrom(LinkedHashMap.class)) {
            map = new LinkedHashMap();
        } else {
            try {
                map = (Map)type.newInstance();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
                env.warning(L.l("Can't assign array to {0}", (Object)type.getName()));
                return null;
            }
        }
        for (Map.Entry<Object, Object> entry : this.objectEntrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    @Override
    public abstract Value copy();

    @Override
    public abstract Value copy(Env var1, IdentityHashMap<Value, Value> var2);

    @Override
    public abstract int getSize();

    @Override
    public abstract void clear();

    @Override
    public final Value put(Value value) {
        return this.put(this.createTailKey(), value);
    }

    @Override
    public final Value put(Value key, Value value) {
        return this.putImpl(key, value);
    }

    public abstract Value putImpl(Value var1, Value var2);

    @Override
    public ArrayValue unshift(Value value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrayValue splice(int begin, int end, ArrayValue replace) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value getArg(Value index, boolean isTop) {
        return this.get(index);
    }

    @Override
    public Var putVar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract Value createTailKey();

    public Collection<Value> getIndices() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract Value get(Value var1);

    @Override
    public abstract Value remove(Value var1);

    @Override
    public Var getVar(Value index) {
        Var var = new Var(new JavaAdapterVar(this, index));
        return var;
    }

    @Override
    public Set<Value> keySet() {
        return new KeySet(this.getEnv());
    }

    @Override
    public abstract Set<Map.Entry<Value, Value>> entrySet();

    public abstract Set<Map.Entry<Object, Object>> objectEntrySet();

    @Override
    public Collection<Value> values() {
        throw new UnimplementedException();
    }

    @Override
    public ArrayValue append(Value key, Value value) {
        this.put(key, value);
        return this;
    }

    @Override
    public Value pop(Env env) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value shuffle() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrayValue.Entry getHead() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ArrayValue.Entry getTail() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value current() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value key() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasCurrent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value next() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value prev() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value each() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value reset() {
        return BooleanValue.FALSE;
    }

    @Override
    public Value end() {
        return BooleanValue.FALSE;
    }

    @Override
    public Value contains(Value value) {
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return NullValue.NULL;
    }

    @Override
    public Value containsStrict(Value value) {
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            if (!entry.getValue().eql(value)) continue;
            return entry.getKey();
        }
        return NullValue.NULL;
    }

    @Override
    public Value containsKey(Value key) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Map.Entry<Value, Value>[] toEntryArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sort(Comparator<Map.Entry<Value, Value>> comparator, boolean resetKeys, boolean strict) {
        Map.Entry[] entries = new Map.Entry[this.getSize()];
        int i = 0;
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            entries[i++] = entry;
        }
        Arrays.sort(entries, comparator);
        this.clear();
        long base = 0L;
        if (!resetKeys) {
            strict = false;
        }
        for (int j = 0; j < entries.length; ++j) {
            Value key = (Value)entries[j].getKey();
            if (resetKeys && (!(key instanceof StringValue) || strict)) {
                this.put(LongValue.create(base++), (Value)entries[j].getValue());
                continue;
            }
            this.put((Value)entries[j].getKey(), (Value)entries[j].getValue());
        }
    }

    @Override
    public void serialize(Env env, StringBuilder sb) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void varExportImpl(StringValue sb, int level) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean keyReset(long base, boolean strict) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value[] valuesToArray() {
        Value[] values = new Value[this.getSize()];
        int i = 0;
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            values[i++] = entry.getValue();
        }
        return values;
    }

    @Override
    public Object valuesToArray(Env env, Class elementType) {
        int size = this.getSize();
        Object array = Array.newInstance(elementType, size);
        MarshalFactory factory = env.getModuleContext().getMarshalFactory();
        Marshal elementMarshal = factory.create(elementType);
        int i = 0;
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            Array.set(array, i++, elementMarshal.marshal(env, entry.getValue(), elementType));
        }
        return array;
    }

    @Override
    public Value getField(Env env, StringValue name) {
        return this._classDef.getField(env, this, name);
    }

    @Override
    public Value putField(Env env, StringValue name, Value value) {
        return this._classDef.putField(env, this, name, value);
    }

    public String getName() {
        return this._classDef.getName();
    }

    @Override
    public boolean isA(Env env, String name) {
        return this._classDef.isA(env, name);
    }

    @Override
    public AbstractFunction findFunction(StringValue methodName) {
        return this._classDef.findFunction(methodName);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value[] args) {
        return this._classDef.callMethod(env, (Value)this, methodName, hash, args);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash) {
        return this._classDef.callMethod(env, this, methodName, hash);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1) {
        return this._classDef.callMethod(env, (Value)this, methodName, hash, a1);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2) {
        return this._classDef.callMethod(env, this, methodName, hash, a1, a2);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3) {
        return this._classDef.callMethod(env, this, methodName, hash, a1, a2, a3);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4) {
        return this._classDef.callMethod(env, this, methodName, hash, a1, a2, a3, a4);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this._classDef.callMethod(env, this, methodName, hash, a1, a2, a3, a4, a5);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value[] args) {
        return this._classDef.callMethod(env, (Value)this, methodName, hash, args);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash) {
        return this._classDef.callMethod(env, this, methodName, hash);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1) {
        return this._classDef.callMethod(env, (Value)this, methodName, hash, a1);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2) {
        return this._classDef.callMethod(env, this, methodName, hash, a1, a2);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3) {
        return this._classDef.callMethod(env, this, methodName, hash, a1, a2, a3);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4) {
        return this._classDef.callMethod(env, this, methodName, hash, a1, a2, a3, a4);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this._classDef.callMethod(env, this, methodName, hash, a1, a2, a3, a4, a5);
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.println("array(" + this.getSize() + ") {");
        int nestedDepth = depth + 1;
        for (Map.Entry<Value, Value> mapEntry : this.entrySet()) {
            this.printDepth(out, nestedDepth * 2);
            out.print("[");
            Value key = mapEntry.getKey();
            if (key.isString()) {
                out.print("\"" + key + "\"");
            } else {
                out.print(key);
            }
            out.println("]=>");
            this.printDepth(out, nestedDepth * 2);
            mapEntry.getValue().varDump(env, out, nestedDepth, valueSet);
            out.println();
        }
        this.printDepth(out, 2 * depth);
        out.print("}");
    }

    @Override
    protected void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.println("Array");
        this.printDepth(out, 8 * depth);
        out.println("(");
        for (Map.Entry<Value, Value> mapEntry : this.entrySet()) {
            this.printDepth(out, 8 * depth);
            out.print("    [");
            out.print(mapEntry.getKey());
            out.print("] => ");
            Value value = mapEntry.getValue();
            if (value != null) {
                value.printR(env, out, depth + 1, valueSet);
            }
            out.println();
        }
        this.printDepth(out, 8 * depth);
        out.println(")");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this._object);
        out.writeObject(this._classDef.getName());
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this._envRef = new WeakReference<Env>(Env.getInstance());
        this._object = in.readObject();
        this._classDef = this.getEnv().getJavaClassDefinition((String)in.readObject());
    }

    @Override
    public String toString() {
        return String.valueOf(this._object);
    }

    public class KeySet
    extends AbstractSet<Value> {
        Env _env;

        KeySet(Env env) {
            this._env = env;
        }

        @Override
        public int size() {
            return JavaAdapter.this.getSize();
        }

        @Override
        public Iterator<Value> iterator() {
            return JavaAdapter.this.getKeyIterator(this._env);
        }
    }
}

