/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.function.FunSpecialCall;
import com.caucho.quercus.program.ClassDef;
import com.caucho.util.L10N;
import com.caucho.util.Primes;
import java.util.Iterator;

public final class MethodMap<V> {
    private static final L10N L = new L10N(MethodMap.class);
    private final QuercusClass _quercusClass;
    private final ClassDef _classDef;
    private Entry<V>[] _entries = new Entry[16];
    private int _prime = Primes.getBiggestPrime(this._entries.length);
    private int _size;
    private Entry<V> _head;
    private Entry<V> _tail;

    public MethodMap(QuercusClass quercusClass, ClassDef classDef) {
        this._quercusClass = quercusClass;
        this._classDef = classDef;
    }

    public void put(StringValue name, V value) {
        Entry<V> entry;
        if (this._entries.length <= this._size * 4) {
            this.resize();
        }
        int hash = name.hashCodeCaseInsensitive();
        int bucket = (hash & Integer.MAX_VALUE) % this._prime;
        for (entry = this._entries[bucket]; entry != null; entry = entry.getNext()) {
            StringValue entryKey = entry.getKey();
            if (name != entryKey && !name.equalsIgnoreCase(entryKey)) continue;
            entry.setValue(value);
            return;
        }
        entry = this.createEntry(name, value);
        ((Entry)entry)._next = (Entry)this._entries[bucket];
        this._entries[bucket] = entry;
        ++this._size;
    }

    private Entry<V> createEntry(StringValue name, V value) {
        Entry<V> entry = new Entry<V>(name, value);
        if (this._head == null) {
            this._head = entry;
        }
        if (this._tail != null) {
            this._tail.setAbsoluteNext(entry);
        }
        this._tail = entry;
        return entry;
    }

    public boolean containsKey(StringValue key) {
        int hash = key.hashCodeCaseInsensitive();
        int bucket = (hash & Integer.MAX_VALUE) % this._prime;
        for (Entry<V> entry = this._entries[bucket]; entry != null; entry = entry.getNext()) {
            StringValue entryKey = entry.getKey();
            if (key != entryKey && !key.equalsIgnoreCase(entryKey)) continue;
            return true;
        }
        return false;
    }

    public final V get(StringValue key, int hash) {
        return this.get(key, hash, false);
    }

    public final V getStatic(StringValue key, int hash) {
        return this.get(key, hash, true);
    }

    public final V get(StringValue key, int hash, boolean isStatic) {
        int bucket = (hash & Integer.MAX_VALUE) % this._prime;
        for (Entry<V> entry = this._entries[bucket]; entry != null; entry = entry.getNext()) {
            StringValue entryKey = entry.getKey();
            if (key != entryKey && !key.equalsIgnoreCase(entryKey)) continue;
            return (V)((Entry)entry)._value;
        }
        AbstractFunction call = null;
        if (isStatic) {
            if (this._quercusClass != null) {
                call = this._quercusClass.getCallStatic();
            } else if (this._classDef != null) {
                call = this._classDef.getCallStatic();
            }
        } else if (this._quercusClass != null) {
            call = this._quercusClass.getCall();
        } else if (this._classDef != null) {
            call = this._classDef.getCall();
        }
        if (call != null) {
            return (V)new FunSpecialCall(call, key);
        }
        Env env = Env.getCurrent();
        if (this._quercusClass != null) {
            env.error(L.l("Call to undefined method {0}::{1}", (Object)this._quercusClass.getName(), (Object)key));
        } else {
            env.error(L.l("Call to undefined function {0}", (Object)key));
        }
        throw new IllegalStateException(L.l("Call to undefined function {0}", (Object)key));
    }

    public V getRaw(StringValue key) {
        int hash = key.hashCodeCaseInsensitive();
        int bucket = (hash & Integer.MAX_VALUE) % this._prime;
        for (Entry<V> entry = this._entries[bucket]; entry != null; entry = entry.getNext()) {
            StringValue entryKey = entry.getKey();
            if (key != entryKey && !key.equalsIgnoreCase(entryKey)) continue;
            return entry.getValue();
        }
        return null;
    }

    public V get(StringValue key) {
        return this.get(key, key.hashCodeCaseInsensitive());
    }

    public Iterable<V> values() {
        return new ValueIterator<V>(this._head);
    }

    private boolean match(char[] a, char[] b, int length) {
        if (a.length != length) {
            return false;
        }
        for (int i = length - 1; i >= 0; --i) {
            int chA = a[i];
            int chB = b[i];
            if (chA == chB) continue;
            if (65 <= chA && chA <= 90) {
                chA += 32;
            }
            if (65 <= chB && chB <= 90) {
                chB += 32;
            }
            if (chA == chB) continue;
            return false;
        }
        return true;
    }

    private void resize() {
        Entry[] newEntries = new Entry[2 * this._entries.length];
        int newPrime = Primes.getBiggestPrime(newEntries.length);
        for (int i = 0; i < this._entries.length; ++i) {
            Entry<V> entry = this._entries[i];
            while (entry != null) {
                Entry<V> next = entry.getNext();
                int hash = ((Entry)entry)._key.hashCodeCaseInsensitive();
                int bucket = (hash & Integer.MAX_VALUE) % newPrime;
                entry.setNext(newEntries[bucket]);
                newEntries[bucket] = entry;
                entry = next;
            }
        }
        this._entries = newEntries;
        this._prime = newPrime;
    }

    static final class ValueIterator<V>
    implements Iterable<V>,
    Iterator<V> {
        Entry<V> _next;

        public ValueIterator(Entry<V> next) {
            this._next = next;
        }

        private void getNext() {
            Entry<V> current = this._next;
            this._next = current.getAbsoluteNext();
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public V next() {
            Object value = ((Entry)this._next)._value;
            this.getNext();
            return (V)value;
        }

        @Override
        public Iterator<V> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static final class Entry<V> {
        private final StringValue _key;
        private V _value;
        private Entry<V> _next;
        private Entry<V> _absoluteNext;

        Entry(StringValue key, V value) {
            this._key = key;
            this._value = value;
        }

        public final StringValue getKey() {
            return this._key;
        }

        public final V getValue() {
            return this._value;
        }

        public void setValue(V value) {
            this._value = value;
        }

        public Entry<V> getNext() {
            return this._next;
        }

        public void setNext(Entry<V> next) {
            this._next = next;
        }

        public Entry<V> getAbsoluteNext() {
            return this._absoluteNext;
        }

        public void setAbsoluteNext(Entry<V> next) {
            this._absoluteNext = next;
        }
    }
}

