/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractBinaryExpr;
import com.caucho.quercus.expr.Expr;

public class BinaryAndExpr
extends AbstractBinaryExpr {
    public BinaryAndExpr(Location location, Expr left, Expr right) {
        super(location, left, right);
    }

    public BinaryAndExpr(Expr left, Expr right) {
        super(left, right);
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Value eval(Env env) {
        if (this._left.evalBoolean(env) && this._right.evalBoolean(env)) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    @Override
    public boolean evalBoolean(Env env) {
        return this._left.evalBoolean(env) && this._right.evalBoolean(env);
    }

    @Override
    public String toString() {
        return "(" + this._left + " && " + this._right + ")";
    }
}

