/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;

public class BinaryAssignExpr
extends Expr {
    protected final AbstractVarExpr _var;
    protected final Expr _value;

    public BinaryAssignExpr(Location location, AbstractVarExpr var, Expr value) {
        super(location);
        this._var = var;
        this._value = value;
    }

    public BinaryAssignExpr(AbstractVarExpr var, Expr value) {
        this._var = var;
        this._value = value;
    }

    @Override
    public Expr createCopy(ExprFactory factory) {
        return factory.createCopy(this);
    }

    @Override
    public boolean isAssign() {
        return true;
    }

    @Override
    public Value eval(Env env) {
        return this._var.evalAssignValue(env, this._value);
    }

    @Override
    public Value evalCopy(Env env) {
        return this.eval(env).copy();
    }

    @Override
    public Value evalRef(Env env) {
        Value value = this._value.evalCopy(env);
        this._var.evalAssignValue(env, value);
        return this._var.eval(env);
    }

    @Override
    public String toString() {
        return this._var + "=" + this._value;
    }
}

