/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.util.L10N;
import java.util.ArrayList;

public class CallExpr
extends Expr {
    private static final L10N L = new L10N(CallExpr.class);
    protected final StringValue _name;
    protected final StringValue _nsName;
    protected final Expr[] _args;
    private int _funId;
    protected boolean _isRef;

    public CallExpr(Location location, StringValue name, ArrayList<Expr> args) {
        super(location);
        this._name = name;
        int ns = this._name.lastIndexOf('\\');
        this._nsName = ns > 0 ? this._name.substring(ns + 1) : null;
        this._args = new Expr[args.size()];
        args.toArray(this._args);
    }

    public CallExpr(Location location, StringValue name, Expr[] args) {
        super(location);
        this._name = name;
        int ns = this._name.lastIndexOf('\\');
        this._nsName = ns > 0 ? this._name.substring(ns + 1) : null;
        this._args = args;
    }

    public StringValue getName() {
        return this._name;
    }

    @Override
    public String getFunctionLocation() {
        return " [" + this._name + "]";
    }

    @Override
    public Expr createCopy(ExprFactory factory) {
        return this;
    }

    @Override
    public Value eval(Env env) {
        return this.evalImpl(env, false, false);
    }

    @Override
    public Value evalCopy(Env env) {
        return this.evalImpl(env, false, true);
    }

    @Override
    public Value evalRef(Env env) {
        return this.evalImpl(env, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value evalImpl(Env env, boolean isRef, boolean isCopy) {
        AbstractFunction fun;
        if (this._funId <= 0) {
            this._funId = env.findFunctionId(this._name);
            if (this._funId <= 0) {
                if (this._nsName != null) {
                    this._funId = env.findFunctionId(this._nsName);
                }
                if (this._funId <= 0) {
                    env.error(L.l("'{0}' is an unknown function.", (Object)this._name), this.getLocation());
                    return NullValue.NULL;
                }
            }
        }
        if ((fun = env.getFunction(this._funId)) == null) {
            env.error(L.l("'{0}' is an unknown function.", (Object)this._name), this.getLocation());
            return NullValue.NULL;
        }
        Value[] args = CallExpr.evalArgs(env, this._args);
        env.pushCall(this, NullValue.NULL, args);
        QuercusClass oldCallingClass = env.setCallingClass(null);
        try {
            env.checkTimeout();
            if (isRef) {
                Value value = fun.callRef(env, args);
                return value;
            }
            if (isCopy) {
                Value value = fun.call(env, args).copyReturn();
                return value;
            }
            Value value = fun.call(env, args).toValue();
            return value;
        }
        finally {
            env.popCall();
            env.setCallingClass(oldCallingClass);
        }
    }

    public Value[] evalArguments(Env env) {
        AbstractFunction fun = env.findFunction(this._name);
        if (fun == null) {
            return null;
        }
        return fun.evalArguments(env, this, this._args);
    }

    @Override
    public String toString() {
        return this._name + "()";
    }
}

