/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;

public class ConstClassExpr
extends Expr {
    protected final StringValue _funName;

    public ConstClassExpr(Location location, StringValue funName) {
        super(location);
        this._funName = funName;
    }

    @Override
    public Value eval(Env env) {
        return ConstClassExpr.evalStatic(env, env.getThis(), this._funName);
    }

    public static StringValue evalStatic(Env env, Value qThis, StringValue funName) {
        QuercusClass cls = qThis.getQuercusClass();
        if (cls == null) {
            return env.getEmptyString();
        }
        String bindingClassName = cls.getTraitMethodBindingClassName(funName);
        if (bindingClassName == null) {
            return env.getEmptyString();
        }
        return env.createString(bindingClassName);
    }

    @Override
    public String toString() {
        return "__CLASS__";
    }
}

