/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;

public class ObjectFieldVarExpr
extends AbstractVarExpr {
    private static final L10N L = new L10N(ObjectFieldVarExpr.class);
    protected final Expr _objExpr;
    protected final Expr _nameExpr;

    public ObjectFieldVarExpr(Location location, Expr objExpr, Expr nameExpr) {
        super(location);
        this._objExpr = objExpr;
        this._nameExpr = nameExpr;
    }

    public ObjectFieldVarExpr(Expr objExpr, Expr nameExpr) {
        this._objExpr = objExpr;
        this._nameExpr = nameExpr;
    }

    @Override
    public Expr createCall(QuercusParser parser, Location location, ArrayList<Expr> args) throws IOException {
        ExprFactory factory = parser.getExprFactory();
        return factory.createMethodCall(location, this._objExpr, this._nameExpr, args);
    }

    @Override
    public Value evalArg(Env env, boolean isTop) {
        Value value = this._objExpr.evalArg(env, false);
        return value.getFieldArg(env, this._nameExpr.evalStringValue(env), isTop);
    }

    @Override
    public Var evalVar(Env env) {
        Value value = this._objExpr.evalObject(env);
        return value.getFieldVar(env, this._nameExpr.evalStringValue(env));
    }

    @Override
    public Value eval(Env env) {
        Value obj = this._objExpr.eval(env);
        return obj.getField(env, this._nameExpr.evalStringValue(env));
    }

    @Override
    public Value evalAssignValue(Env env, Value value) {
        Value obj = this._objExpr.evalObject(env);
        obj.putField(env, this._nameExpr.evalStringValue(env), value);
        return value;
    }

    @Override
    public Value evalAssignRef(Env env, Value value) {
        Value obj = this._objExpr.evalObject(env);
        obj.putField(env, this._nameExpr.evalStringValue(env), value);
        return value;
    }

    @Override
    public Value evalArray(Env env) {
        Value obj = this._objExpr.evalObject(env);
        return obj.getFieldArray(env, this._nameExpr.evalStringValue(env));
    }

    @Override
    public Value evalObject(Env env) {
        Value obj = this._objExpr.evalObject(env);
        return obj.getFieldObject(env, this._nameExpr.evalStringValue(env));
    }

    @Override
    public void evalUnset(Env env) {
        Value obj = this._objExpr.eval(env);
        obj.unsetField(this._nameExpr.evalStringValue(env));
    }

    @Override
    public String toString() {
        return this._objExpr + "->{" + this._nameExpr + "}";
    }

    @Override
    public boolean evalIsset(Env env) {
        Value object = this._objExpr.eval(env);
        return object.issetField(env, this._nameExpr.evalStringValue(env));
    }
}

