/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ObjectNewExpr;
import com.caucho.util.L10N;
import java.util.ArrayList;

public class ObjectNewVarExpr
extends Expr {
    private static final L10N L = new L10N(ObjectNewExpr.class);
    protected final Expr _name;
    protected final Expr[] _args;
    protected Expr[] _fullArgs;

    public ObjectNewVarExpr(Location location, Expr name, ArrayList<Expr> args) {
        super(location);
        this._name = name;
        this._args = new Expr[args.size()];
        args.toArray(this._args);
    }

    public ObjectNewVarExpr(Location location, Expr name, Expr[] args) {
        super(location);
        this._name = name;
        this._args = args;
    }

    public ObjectNewVarExpr(Expr name, ArrayList<Expr> args) {
        this(Location.UNKNOWN, name, args);
    }

    public ObjectNewVarExpr(Expr name, Expr[] args) {
        this(Location.UNKNOWN, name, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value eval(Env env) {
        String name = this._name.evalString(env).intern();
        QuercusClass cl = env.findAbstractClass(name);
        this._fullArgs = this._args;
        Value[] args = new Value[this._args.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this._args[i].eval(env);
        }
        env.pushCall(this, NullValue.NULL, args);
        try {
            env.checkTimeout();
            Value value = cl.callNew(env, args);
            return value;
        }
        finally {
            env.popCall();
        }
    }

    @Override
    public String toString() {
        return this._name + "()";
    }
}

