/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.function;

import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.program.Arg;
import com.caucho.util.L10N;
import java.util.logging.Logger;

public class LazyFunction
extends AbstractFunction {
    private static final Logger log = Logger.getLogger(LazyFunction.class.getName());
    private static final L10N L = new L10N(LazyFunction.class);
    private final QuercusContext _quercus;
    private final String _name;
    private final Class<?> _pageClass;
    private final String _className;
    private AbstractFunction _fun;

    public LazyFunction(QuercusContext quercus, String name, Class<?> pageClass, String className) {
        this._quercus = quercus;
        this._name = name;
        this._pageClass = pageClass;
        this._className = className;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Arg[] getArgs(Env env) {
        return this.getFun(env).getArgs(env);
    }

    @Override
    public AbstractFunction toFun() {
        if (this._fun != null) {
            return this._fun;
        }
        return this;
    }

    private AbstractFunction getFun(Env env) {
        try {
            ClassLoader loader = this._pageClass.getClassLoader();
            String className = this._pageClass.getName() + "$" + this._className;
            Class<?> cl = Class.forName(className, false, loader);
            this._fun = (AbstractFunction)cl.newInstance();
            int id = this._quercus.findFunctionId(env.createString(this._name));
            env._fun[id] = this._fun;
            return this._fun;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getComment() {
        if (this._fun != null) {
            return this._fun.getComment();
        }
        return this.getFun(Env.getInstance()).getComment();
    }

    @Override
    public Value call(Env env, Value[] argValues) {
        return this.getFun(env).call(env, argValues);
    }

    @Override
    public Value call(Env env, Value arg) {
        return this.getFun(env).call(env, arg);
    }

    @Override
    public Value call(Env env, Value a1, Value a2) {
        return this.getFun(env).call(env, a1, a2);
    }

    @Override
    public Value call(Env env, Value a1, Value a2, Value a3) {
        return this.getFun(env).call(env, a1, a2, a3);
    }

    @Override
    public Value call(Env env, Value a1, Value a2, Value a3, Value a4) {
        return this.getFun(env).call(env, a1, a2, a3, a4);
    }

    @Override
    public Value call(Env env, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.getFun(env).call(env, a1, a2, a3, a4, a5);
    }

    @Override
    public Value callRef(Env env, Value[] argValues) {
        return this.getFun(env).callRef(env, argValues);
    }

    @Override
    public Value callRef(Env env, Value arg) {
        return this.getFun(env).callRef(env, arg);
    }

    @Override
    public Value callRef(Env env, Value a1, Value a2) {
        return this.getFun(env).callRef(env, a1, a2);
    }

    @Override
    public Value callRef(Env env, Value a1, Value a2, Value a3) {
        return this.getFun(env).callRef(env, a1, a2, a3);
    }

    @Override
    public Value callRef(Env env, Value a1, Value a2, Value a3, Value a4) {
        return this.getFun(env).callRef(env, a1, a2, a3, a4);
    }

    @Override
    public Value callRef(Env env, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.getFun(env).callRef(env, a1, a2, a3, a4, a5);
    }

    @Override
    public Value callCopy(Env env, Value[] argValues) {
        return this.getFun(env).callCopy(env, argValues);
    }
}

