/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringBuilderOutputStream;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.BinaryStream;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class UrlModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(UrlModule.class);
    private static final Logger log = Logger.getLogger(UrlModule.class.getName());
    public static final int PHP_URL_SCHEME = 0;
    public static final int PHP_URL_HOST = 1;
    public static final int PHP_URL_PORT = 2;
    public static final int PHP_URL_USER = 3;
    public static final int PHP_URL_PASS = 4;
    public static final int PHP_URL_PATH = 5;
    public static final int PHP_URL_QUERY = 6;
    public static final int PHP_URL_FRAGMENT = 7;
    private static final StringValue SCHEME_V = new ConstStringValue("scheme");
    private static final StringValue SCHEME_U = new UnicodeBuilderValue("scheme");
    private static final StringValue USER_V = new ConstStringValue("user");
    private static final StringValue USER_U = new UnicodeBuilderValue("user");
    private static final StringValue PASS_V = new ConstStringValue("pass");
    private static final StringValue PASS_U = new UnicodeBuilderValue("pass");
    private static final StringValue HOST_V = new ConstStringValue("host");
    private static final StringValue HOST_U = new UnicodeBuilderValue("host");
    private static final StringValue PORT_V = new ConstStringValue("port");
    private static final StringValue PORT_U = new UnicodeBuilderValue("port");
    private static final StringValue PATH_V = new ConstStringValue("path");
    private static final StringValue PATH_U = new UnicodeBuilderValue("path");
    private static final StringValue QUERY_V = new ConstStringValue("query");
    private static final StringValue QUERY_U = new UnicodeBuilderValue("query");
    private static final StringValue FRAGMENT_V = new ConstStringValue("fragment");
    private static final StringValue FRAGMENT_U = new UnicodeBuilderValue("fragment");

    public static String base64_encode(StringValue s) {
        CharBuffer cb = new CharBuffer();
        byte[] buffer = new byte[3];
        int strlen = s.length();
        int offset = 0;
        while (offset + 3 <= strlen) {
            buffer[0] = (byte)s.charAt(offset);
            buffer[1] = (byte)s.charAt(offset + 1);
            buffer[2] = (byte)s.charAt(offset + 2);
            Base64.encode(cb, buffer, 0, 3);
            offset += 3;
        }
        if (offset < strlen) {
            buffer[0] = (byte)s.charAt(offset);
        }
        if (offset + 1 < strlen) {
            buffer[1] = (byte)s.charAt(offset + 1);
        }
        if (offset + 2 < strlen) {
            buffer[2] = (byte)s.charAt(offset + 2);
        }
        Base64.encode(cb, buffer, 0, strlen - offset);
        return cb.toString();
    }

    public static Value base64_decode(Env env, StringValue str, @Optional boolean isStrict) {
        if (str.length() == 0) {
            return str;
        }
        StringValue sb = env.createBinaryBuilder();
        StringBuilderOutputStream os = new StringBuilderOutputStream(sb);
        try {
            Base64.decodeIgnoreWhitespace(str.toSimpleReader(), os);
        }
        catch (IOException e) {
            env.warning(e);
            return BooleanValue.FALSE;
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Value get_headers(Env env, String urlString, @Optional Value format) {
        Socket socket = null;
        try {
            Object line;
            URL url = new URL(urlString);
            if (!url.getProtocol().equals("http") && !url.getProtocol().equals("https")) {
                env.warning(L.l("Not an HTTP URL"));
                Value value = null;
                return value;
            }
            int port = 80;
            if (url.getPort() < 0) {
                if (url.getProtocol().equals("http")) {
                    port = 80;
                } else if (url.getProtocol().equals("https")) {
                    port = 443;
                }
            } else {
                port = url.getPort();
            }
            socket = new Socket(url.getHost(), port);
            OutputStream out = socket.getOutputStream();
            InputStream in = socket.getInputStream();
            StringBuilder request = new StringBuilder();
            request.append("HEAD ");
            if (url.getPath() != null) {
                request.append(url.getPath());
            }
            if (url.getQuery() != null) {
                request.append("?" + url.getQuery());
            }
            if (url.getRef() != null) {
                request.append("#" + url.getRef());
            }
            request.append(" HTTP/1.0\r\n");
            if (url.getHost() != null) {
                request.append("Host: " + url.getHost() + "\r\n");
            }
            request.append("\r\n");
            OutputStreamWriter writer = new OutputStreamWriter(out);
            writer.write(request.toString());
            writer.flush();
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(in));
            ArrayValueImpl result = new ArrayValueImpl();
            if (format.toBoolean()) {
                line = reader.readLine();
                while (line != null) {
                    if (((String)(line = ((String)line).trim())).length() != 0) {
                        int colon = ((String)line).indexOf(58);
                        if (colon < 0) {
                            ((ArrayValue)result).put(env.createString(((String)line).trim()));
                        } else {
                            ArrayValue values;
                            StringValue key = env.createString(((String)line).substring(0, colon).trim());
                            StringValue value = colon < ((String)line).length() ? env.createString(((String)line).substring(colon + 1).trim()) : env.getEmptyString();
                            if (((ArrayValue)result).get(key) != UnsetValue.UNSET) {
                                values = (ArrayValue)((ArrayValue)result).get(key);
                            } else {
                                values = new ArrayValueImpl();
                                result.put(key, values);
                            }
                            values.put(value);
                        }
                    }
                    line = reader.readLine();
                }
                for (Value key : result.keySet()) {
                    Value value = ((ArrayValue)result).get(key);
                    if (!value.isArray() || ((ArrayValue)value).getSize() != 1) continue;
                    result.put(key, ((ArrayValue)value).get(LongValue.ZERO));
                }
            } else {
                line = reader.readLine();
                while (line != null) {
                    if (((String)(line = ((String)line).trim())).length() != 0) {
                        ((ArrayValue)result).put(env.createString(((String)line).trim()));
                    }
                    line = reader.readLine();
                }
            }
            ArrayValueImpl arrayValueImpl = result;
            return arrayValueImpl;
        }
        catch (Exception e) {
            env.warning(e);
            BooleanValue booleanValue = BooleanValue.FALSE;
            return booleanValue;
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException e) {
                env.warning(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Value get_meta_tags(Env env, StringValue filename, @Optional boolean useIncludePath) {
        InputStream in = null;
        ArrayValueImpl result = new ArrayValueImpl();
        try {
            BinaryStream stream = FileModule.fopen(env, filename, "r", useIncludePath, null);
            if (stream == null || !(stream instanceof BinaryInput)) {
                ArrayValueImpl arrayValueImpl = result;
                return arrayValueImpl;
            }
            BinaryInput input = (BinaryInput)stream;
            block14: while (!input.isEOF()) {
                String tag = UrlModule.getNextTag(input);
                if (tag.equalsIgnoreCase("meta")) {
                    String[] attr;
                    String name = null;
                    String content = null;
                    while ((attr = UrlModule.getNextAttribute(input)) != null) {
                        if (name == null && attr[0].equalsIgnoreCase("name")) {
                            if (attr.length > 1) {
                                name = attr[1];
                            }
                        } else if (content == null && attr[0].equalsIgnoreCase("content") && attr.length > 1) {
                            content = attr[1];
                        }
                        if (name == null || content == null) continue;
                        result.put(env.createString(name), env.createString(content));
                        continue block14;
                    }
                    continue;
                }
                if (!tag.equalsIgnoreCase("/head")) continue;
                break;
            }
        }
        catch (IOException e) {
            env.warning(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                env.warning(e);
            }
        }
        return result;
    }

    public static Value http_build_query(Env env, Value formdata, @Optional StringValue numeric_prefix, @Optional(value="'&'") StringValue separator) {
        StringValue result = env.createUnicodeBuilder();
        UrlModule.httpBuildQueryImpl(env, result, formdata, env.getEmptyString(), numeric_prefix, separator);
        return result;
    }

    private static void httpBuildQueryImpl(Env env, StringValue result, Value formdata, StringValue path, StringValue numeric_prefix, StringValue separator) {
        Set<Map.Entry<Value, Value>> entrySet;
        if (formdata.isArray()) {
            entrySet = ((ArrayValue)formdata).entrySet();
        } else if (formdata.isObject()) {
            entrySet = ((ObjectValue)formdata).entrySet();
        } else {
            env.warning(L.l("formdata must be an array or object"));
            return;
        }
        boolean isFirst = true;
        for (Map.Entry<Value, Value> entry : entrySet) {
            if (!isFirst) {
                if (separator != null) {
                    result.append(separator);
                } else {
                    result.append("&");
                }
            }
            isFirst = false;
            StringValue newPath = UrlModule.makeNewPath(path, entry.getKey(), numeric_prefix);
            Value entryValue = entry.getValue();
            if (entryValue.isArray() || entryValue.isObject()) {
                UrlModule.httpBuildQueryImpl(env, result, entryValue, newPath, null, separator);
                continue;
            }
            result.append(newPath);
            result.append("=");
            result.append(UrlModule.urlencode(entry.getValue().toStringValue()));
        }
    }

    private static StringValue makeNewPath(StringValue oldPath, Value key, StringValue numeric_prefix) {
        StringValue path = oldPath.createStringBuilder();
        if (oldPath.length() != 0) {
            path.append(oldPath);
            path.append("%5B");
            UrlModule.urlencode(path, key.toStringValue());
            path.append("%5D");
            return path;
        }
        if (key.isLongConvertible() && numeric_prefix != null) {
            UrlModule.urlencode(path, numeric_prefix);
            UrlModule.urlencode(path, key.toStringValue());
            return path;
        }
        UrlModule.urlencode(path, key.toStringValue());
        return path;
    }

    public static Value parse_url(Env env, StringValue str, @Optional(value="-1") int component) {
        boolean isUnicode = env.isUnicodeSemantics();
        ArrayValueImpl array = new ArrayValueImpl();
        UrlModule.parseUrl(env, str, array, isUnicode);
        switch (component) {
            case 0: {
                return array.get(isUnicode ? SCHEME_U : SCHEME_V);
            }
            case 1: {
                return array.get(isUnicode ? HOST_U : HOST_V);
            }
            case 2: {
                return array.get(isUnicode ? PORT_U : PORT_V);
            }
            case 3: {
                return array.get(isUnicode ? USER_U : USER_V);
            }
            case 4: {
                return array.get(isUnicode ? PASS_U : PASS_V);
            }
            case 5: {
                return array.get(isUnicode ? PATH_U : PATH_V);
            }
            case 6: {
                return array.get(isUnicode ? QUERY_U : QUERY_V);
            }
            case 7: {
                return array.get(isUnicode ? FRAGMENT_U : FRAGMENT_V);
            }
        }
        return array;
    }

    private static void parseUrl(Env env, StringValue str, ArrayValue array, boolean isUnicode) {
        char ch;
        int strlen = str.length();
        if (strlen == 0) {
            array.put(PATH_V, PATH_U, (Value)env.getEmptyString(), isUnicode);
            return;
        }
        int i = 0;
        int colon = str.indexOf(":");
        boolean hasHost = false;
        if (0 <= colon) {
            StringValue sb;
            int end = colon;
            if (colon + 1 < strlen && str.charAt(colon + 1) == '/') {
                if (colon + 2 < strlen && str.charAt(colon + 2) == '/') {
                    end = colon + 2;
                    if (colon + 3 >= strlen || str.charAt(colon + 3) != '/') {
                        hasHost = true;
                    }
                }
                sb = env.createStringBuilder();
                sb.append(str, 0, colon);
                array.put(SCHEME_V, SCHEME_U, (Value)sb, isUnicode);
                i = end + 1;
            } else if (colon + 1 == strlen || (ch = str.charAt(colon + 1)) <= '0' || '9' <= ch) {
                sb = env.createStringBuilder();
                sb.append(str, 0, colon);
                array.put(SCHEME_V, SCHEME_U, (Value)sb, isUnicode);
                i = colon + 1;
            } else {
                hasHost = true;
            }
        }
        colon = str.indexOf(':', i);
        int question = str.indexOf('?', i);
        int pound = str.indexOf('#', i);
        int atSign = str.lastIndexOf('@');
        StringValue user = null;
        StringValue pass = null;
        if (0 <= atSign && (question < 0 || atSign < question) && hasHost) {
            if (0 <= colon && colon < atSign) {
                if (i < colon) {
                    user = env.createStringBuilder();
                    user.append(str, i, colon);
                }
                if (colon + 1 < atSign) {
                    pass = env.createStringBuilder();
                    pass.append(str, colon + 1, atSign);
                }
                i = atSign + 1;
                colon = str.indexOf(':', i);
            } else {
                user = env.createStringBuilder();
                user.append(str, i, atSign);
                i = atSign + 1;
            }
        }
        if (0 <= i && hasHost) {
            int slash = str.indexOf('/', i);
            if (i < colon) {
                StringValue sb = env.createStringBuilder();
                sb.append(str, i, colon);
                array.put(HOST_V, HOST_U, (Value)sb, isUnicode);
                int end = i < slash ? slash : (i < question ? question + 1 : (i < pound ? pound + 1 : strlen));
                if (0 < end - (colon + 1)) {
                    int port = 0;
                    for (int j = colon + 1; j < end && '0' <= (ch = str.charAt(j)) && ch <= '9'; ++j) {
                        port = port * 10 + ch - 48;
                    }
                    array.put(PORT_V, PORT_U, (Value)LongValue.create(port), isUnicode);
                }
                i = end;
            } else if (i < question && (slash < i || question < slash)) {
                StringValue sb = env.createStringBuilder();
                sb.append(str, i, question);
                array.put(HOST_V, HOST_U, (Value)sb, isUnicode);
                i = question + 1;
            } else if (i < slash) {
                StringValue sb = env.createStringBuilder();
                sb.append(str, i, slash);
                array.put(HOST_V, HOST_U, (Value)sb, isUnicode);
                i = slash;
            } else if (i < pound) {
                StringValue sb = env.createStringBuilder();
                sb.append(str, i, pound);
                array.put(HOST_V, HOST_U, (Value)sb, isUnicode);
                i = pound + 1;
            } else {
                StringValue sb = env.createStringBuilder();
                sb.append(str, i, strlen);
                array.put(HOST_V, HOST_U, (Value)sb, isUnicode);
                i = strlen;
            }
        }
        if (user != null) {
            array.put(USER_V, USER_U, (Value)user, isUnicode);
        }
        if (pass != null) {
            array.put(PASS_V, PASS_U, pass, isUnicode);
        }
        if (i < question) {
            StringValue sb = env.createStringBuilder();
            sb.append(str, i, question);
            array.put(PATH_V, PATH_U, (Value)sb, isUnicode);
            i = question + 1;
        }
        if (0 <= pound) {
            if (i < pound) {
                StringValue sb = env.createStringBuilder();
                sb.append(str, i, pound);
                if (0 <= question) {
                    array.put(QUERY_V, QUERY_U, (Value)sb, isUnicode);
                } else {
                    array.put(PATH_V, PATH_U, (Value)sb, isUnicode);
                }
            }
            if (pound + 1 < strlen) {
                StringValue sb = env.createStringBuilder();
                sb.append(str, pound + 1, strlen);
                array.put(FRAGMENT_V, FRAGMENT_U, (Value)sb, isUnicode);
            }
        } else if (i < strlen) {
            StringValue sb = env.createStringBuilder();
            sb.append(str, i, strlen);
            if (0 <= question) {
                array.put(QUERY_V, QUERY_U, (Value)sb, isUnicode);
            } else {
                array.put(PATH_V, PATH_U, (Value)sb, isUnicode);
            }
        }
    }

    public static String rawurldecode(String s) {
        if (s == null) {
            return "";
        }
        int len = s.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '%' && i + 2 < len) {
                char d1 = s.charAt(i + 1);
                char d2 = s.charAt(i + 2);
                int v = 0;
                if ('0' <= d1 && d1 <= '9') {
                    v = 16 * (d1 - 48);
                } else if ('a' <= d1 && d1 <= 'f') {
                    v = 16 * (d1 - 97 + 10);
                } else if ('A' <= d1 && d1 <= 'F') {
                    v = 16 * (d1 - 65 + 10);
                } else {
                    sb.append('%');
                    continue;
                }
                if ('0' <= d2 && d2 <= '9') {
                    v += d2 - 48;
                } else if ('a' <= d2 && d2 <= 'f') {
                    v += d2 - 97 + 10;
                } else if ('A' <= d2 && d2 <= 'F') {
                    v += d2 - 65 + 10;
                } else {
                    sb.append('%');
                    continue;
                }
                i += 2;
                sb.append((char)v);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String rawurlencode(String str) {
        if (str == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || ch == '-' || ch == '_' || ch == '.' || ch == '~') {
                sb.append(ch);
                continue;
            }
            sb.append('%');
            sb.append(UrlModule.toHexDigit(ch >> 4));
            sb.append(UrlModule.toHexDigit(ch));
        }
        return sb.toString();
    }

    public static StringValue urlencode(StringValue str) {
        StringValue sb = str.createStringBuilder();
        UrlModule.urlencode(sb, str);
        return sb;
    }

    private static void urlencode(StringValue sb, StringValue str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if ('a' <= ch && ch <= 'z') {
                sb.append(ch);
                continue;
            }
            if ('A' <= ch && ch <= 'Z') {
                sb.append(ch);
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                sb.append(ch);
                continue;
            }
            if (ch == '-' || ch == '_' || ch == '.') {
                sb.append(ch);
                continue;
            }
            if (ch == ' ') {
                sb.append('+');
                continue;
            }
            sb.append('%');
            sb.append(UrlModule.toHexDigit(ch / 16));
            sb.append(UrlModule.toHexDigit(ch));
        }
    }

    public static String urldecode(String s) {
        if (s == null) {
            return "";
        }
        int len = s.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '%' && i + 2 < len) {
                char d1 = s.charAt(i + 1);
                char d2 = s.charAt(i + 2);
                int v = 0;
                if ('0' <= d1 && d1 <= '9') {
                    v = 16 * (d1 - 48);
                } else if ('a' <= d1 && d1 <= 'f') {
                    v = 16 * (d1 - 97 + 10);
                } else if ('A' <= d1 && d1 <= 'F') {
                    v = 16 * (d1 - 65 + 10);
                } else {
                    sb.append('%');
                    continue;
                }
                if ('0' <= d2 && d2 <= '9') {
                    v += d2 - 48;
                } else if ('a' <= d2 && d2 <= 'f') {
                    v += d2 - 97 + 10;
                } else if ('A' <= d2 && d2 <= 'F') {
                    v += d2 - 65 + 10;
                } else {
                    sb.append('%');
                    continue;
                }
                i += 2;
                sb.append((char)v);
                continue;
            }
            if (ch == '+') {
                sb.append(' ');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static String getNextTag(BinaryInput input) throws IOException {
        StringBuilder tag = new StringBuilder();
        int ch = 0;
        while (!input.isEOF() && ch != 60) {
            ch = input.read();
        }
        while (!input.isEOF() && !Character.isWhitespace(ch = input.read())) {
            tag.append((char)ch);
        }
        return tag.toString();
    }

    private static String[] getNextAttribute(BinaryInput input) throws IOException {
        int ch;
        UrlModule.consumeWhiteSpace(input);
        StringBuilder attribute = new StringBuilder();
        while (!input.isEOF()) {
            ch = input.read();
            if (UrlModule.isValidAttributeCharacter(ch)) {
                attribute.append((char)ch);
                continue;
            }
            input.unread();
            break;
        }
        if (attribute.length() == 0) {
            return null;
        }
        UrlModule.consumeWhiteSpace(input);
        if (input.isEOF()) {
            return new String[]{attribute.toString()};
        }
        ch = input.read();
        if (ch != 61) {
            input.unread();
            return new String[]{attribute.toString()};
        }
        UrlModule.consumeWhiteSpace(input);
        int quote = 32;
        boolean quoted = false;
        if (input.isEOF()) {
            return new String[]{attribute.toString()};
        }
        ch = input.read();
        if (ch == 34 || ch == 39) {
            quoted = true;
            quote = ch;
        } else {
            input.unread();
        }
        StringBuilder value = new StringBuilder();
        while (!input.isEOF()) {
            ch = input.read();
            if (quoted && ch == quote || !quoted && Character.isWhitespace(ch) || ch == 62) break;
            value.append((char)ch);
        }
        return new String[]{attribute.toString(), value.toString()};
    }

    private static void consumeWhiteSpace(BinaryInput input) throws IOException {
        int ch = 0;
        while (!input.isEOF() && Character.isWhitespace(ch = input.read())) {
        }
        if (!Character.isWhitespace(ch)) {
            input.unread();
        }
    }

    private static boolean isValidAttributeCharacter(int ch) {
        return Character.isLetterOrDigit(ch) || ch == 45 || ch == 46 || ch == 95 || ch == 58;
    }

    private static char toHexDigit(int d) {
        if ((d &= 0xF) < 10) {
            return (char)(48 + d);
        }
        return (char)(65 + d - 10);
    }

    static enum ParseUrlState {
        INIT,
        USER,
        PASS,
        HOST,
        PORT,
        PATH,
        QUERY,
        FRAGMENT;

    }
}

