/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import com.caucho.quercus.lib.curl.BouncyProvider;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.PrivateKey;
import java.security.Provider;

public class BouncyProvider148
extends BouncyProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrivateKey getPrivateKey(String str, String password) throws Exception {
        try (StringReader reader = new StringReader(str);){
            PrivateKey key;
            PrivateKeyInfo keyInfo;
            BouncyCastleProvider provider = new BouncyCastleProvider();
            PEMParser parser = new PEMParser(reader);
            Object obj = parser.readObject();
            PEMKeyPair keyPair = PEMKeyPair.create(obj);
            if (keyPair != null) {
                keyInfo = keyPair.getPrivateKeyInfo();
            } else {
                PKCS8EncryptedPrivateKeyInfo encryptedKeyInfo = new PKCS8EncryptedPrivateKeyInfo(obj);
                JceOpenSSLPKCS8DecryptorProviderBuilder builder = new JceOpenSSLPKCS8DecryptorProviderBuilder();
                builder.setProvider(provider);
                InputDecryptorProvider input = builder.build(password.toCharArray());
                keyInfo = encryptedKeyInfo.decryptPrivateKeyInfo(input);
            }
            PrivateKey privateKey = key = provider.getPrivateKey(keyInfo);
            return privateKey;
        }
    }

    static class PEMKeyPair {
        private Object _obj;
        private Method _getPrivateKeyInfoMethod;

        public PEMKeyPair(Object obj) throws Exception {
            Class<?> cls = Class.forName("org.bouncycastle.openssl.PEMKeyPair");
            this._getPrivateKeyInfoMethod = cls.getMethod("getPrivateKeyInfo", new Class[0]);
            this._obj = obj;
        }

        public static PEMKeyPair create(Object obj) throws Exception {
            if (obj.getClass().getName().equals("org.bouncycastle.openssl.PEMKeyPair")) {
                return new PEMKeyPair(obj);
            }
            return null;
        }

        public PrivateKeyInfo getPrivateKeyInfo() throws Exception {
            Object obj = this._getPrivateKeyInfoMethod.invoke(this._obj, new Object[0]);
            return new PrivateKeyInfo(obj);
        }
    }

    static class PrivateKeyInfo {
        private Object _obj;

        public PrivateKeyInfo(Object obj) {
            this._obj = obj;
        }

        public Object getObject() {
            return this._obj;
        }
    }

    static class InputDecryptorProvider {
        private Object _obj;

        public InputDecryptorProvider(Object obj) throws Exception {
            this._obj = obj;
        }

        public Object getObject() {
            return this._obj;
        }
    }

    static class PKCS8EncryptedPrivateKeyInfo {
        private Object _obj;
        private Method _keyInfoDecryptMethod;

        public PKCS8EncryptedPrivateKeyInfo(Object obj) throws Exception {
            Class<?> cls = Class.forName("org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo");
            Class<?> inputCls = Class.forName("org.bouncycastle.operator.InputDecryptorProvider");
            this._keyInfoDecryptMethod = cls.getMethod("decryptPrivateKeyInfo", inputCls);
            this._obj = obj;
        }

        public PrivateKeyInfo decryptPrivateKeyInfo(InputDecryptorProvider decryptor) throws Exception {
            Object obj = this._keyInfoDecryptMethod.invoke(this._obj, decryptor.getObject());
            return new PrivateKeyInfo(obj);
        }
    }

    static class JceOpenSSLPKCS8DecryptorProviderBuilder {
        private Object _builder;
        private Method _decryptorBuildMethod;
        private Method _decryptorProviderMethod;

        public JceOpenSSLPKCS8DecryptorProviderBuilder() throws Exception {
            Class<?> cls = Class.forName("org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder");
            this._decryptorBuildMethod = cls.getMethod("build", char[].class);
            this._decryptorProviderMethod = cls.getMethod("setProvider", Provider.class);
            this._builder = cls.newInstance();
        }

        public void setProvider(BouncyCastleProvider provider) throws Exception {
            this._decryptorProviderMethod.invoke(this._builder, provider.getObject());
        }

        public InputDecryptorProvider build(char[] password) throws Exception {
            Object obj = this._decryptorBuildMethod.invoke(this._builder, new Object[]{password});
            return new InputDecryptorProvider(obj);
        }
    }

    static class PEMParser {
        private Object _pemParser;
        private Method _readObjectMethod;

        public PEMParser(Reader reader) throws Exception {
            Class<?> cls = Class.forName("org.bouncycastle.openssl.PEMParser");
            Constructor<?> cons = cls.getConstructor(Reader.class);
            this._readObjectMethod = cls.getMethod("readObject", new Class[0]);
            this._pemParser = cons.newInstance(reader);
        }

        public Object readObject() throws Exception {
            return this._readObjectMethod.invoke(this._pemParser, new Object[0]);
        }
    }

    static class BouncyCastleProvider {
        private Object _obj;
        private Method _getPrivateKeyMethod;

        public BouncyCastleProvider() throws Exception {
            Class<?> cls = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
            Class<?> keyCls = Class.forName("org.bouncycastle.asn1.pkcs.PrivateKeyInfo");
            this._getPrivateKeyMethod = cls.getMethod("getPrivateKey", keyCls);
            this._obj = cls.newInstance();
        }

        public PrivateKey getPrivateKey(PrivateKeyInfo keyInfo) throws Exception {
            Object obj = this._getPrivateKeyMethod.invoke(this._obj, keyInfo.getObject());
            return (PrivateKey)obj;
        }

        public Object getObject() {
            return this._obj;
        }
    }
}

