/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import java.security.Principal;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public final class CurlHostnameVerifier
implements HostnameVerifier {
    private boolean _isVerifySSLPeer;
    private boolean _isVerifySSLCommonName;
    private boolean _isVerifySSLHostname;

    private CurlHostnameVerifier(boolean verifyPeer, boolean commonName, boolean hostname) {
        this._isVerifySSLPeer = verifyPeer;
        this._isVerifySSLCommonName = commonName;
        this._isVerifySSLHostname = hostname;
    }

    public static CurlHostnameVerifier create() {
        return new CurlHostnameVerifier(true, true, true);
    }

    public static CurlHostnameVerifier create(boolean verifyPeer, boolean commonName, boolean hostname) {
        return new CurlHostnameVerifier(verifyPeer, commonName, hostname);
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        Principal principal;
        block7: {
            if (!(this._isVerifySSLPeer || this._isVerifySSLCommonName || this._isVerifySSLHostname)) {
                return true;
            }
            principal = null;
            try {
                principal = session.getPeerPrincipal();
            }
            catch (SSLPeerUnverifiedException e) {
                if (!this._isVerifySSLPeer) break block7;
                return false;
            }
        }
        if (this._isVerifySSLPeer) {
            try {
                session.getPeerPrincipal();
            }
            catch (SSLPeerUnverifiedException e) {
                return false;
            }
        }
        if (this._isVerifySSLCommonName && (principal == null || !principal.getName().equals(hostname))) {
            return false;
        }
        return !this._isVerifySSLHostname || session.getPeerHost() != null && session.getPeerHost().equals(hostname);
    }
}

