/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import com.caucho.quercus.lib.curl.BouncyProvider;
import com.caucho.quercus.lib.curl.CurlX509KeyManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

public class CurlSSLContextFactory {
    private static String PKCS12_HEADER = "-----BEGIN RSA PRIVATE KEY-----";
    private static String PKCS12_FOOTER = "-----END RSA PRIVATE KEY-----";
    private static String PKCS8_HEADER = "-----BEGIN PRIVATE KEY-----";
    private static String PKCS8_FOOTER = "-----END PRIVATE KEY-----";
    private static String PKCS8_ENC_HEADER = "-----BEGIN ENCRYPTED PRIVATE KEY-----";
    private static String PKCS8_ENC_FOOTER = "-----END ENCRYPTED PRIVATE KEY-----";

    public static SSLContext createUntrusted(String algorithm) throws Exception {
        SSLContext sslContext = SSLContext.getInstance(algorithm);
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
        return sslContext;
    }

    public static SSLContext createCaInfo(String algorithm, String certFile) throws Exception {
        SSLContext sslContext = SSLContext.getInstance(algorithm);
        String keyAlias = "server_key";
        X509Certificate cert = CurlSSLContextFactory.getCertificate(certFile);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null);
        keyStore.setCertificateEntry(keyAlias, cert);
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmfactory.init(keyStore, null);
        KeyManager[] keyManagers = kmfactory.getKeyManagers();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
        tmf.init(keyStore);
        TrustManager[] trustManagers = tmf.getTrustManagers();
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    public static SSLContext create(String certFile, String keyFile, String password, String algorithm) throws Exception {
        X509Certificate cert = CurlSSLContextFactory.getCertificate(certFile);
        PrivateKey privateKey = CurlSSLContextFactory.getPrivateKey(keyFile, password);
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(null, null);
        String keyAlias = "client_key";
        KeyStore.TrustedCertificateEntry trustedEntry = new KeyStore.TrustedCertificateEntry(cert);
        keystore.setEntry(keyAlias, trustedEntry, null);
        String keyStorePassword = "changeit";
        if (password != null) {
            keyStorePassword = password;
        }
        keystore.setKeyEntry(keyAlias + "_prv", privateKey, keyStorePassword.toCharArray(), new Certificate[]{cert});
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmfactory.init(keystore, keyStorePassword.toCharArray());
        KeyManager[] keymanagers = kmfactory.getKeyManagers();
        if (keyAlias != null) {
            for (int i = 0; i < keymanagers.length; ++i) {
                keymanagers[i] = new CurlX509KeyManager((X509KeyManager)keymanagers[i], keyAlias);
            }
        }
        SSLContext sslcontext = SSLContext.getInstance(algorithm);
        sslcontext.init(keymanagers, null, new SecureRandom());
        return sslcontext;
    }

    private static X509Certificate getCertificate(String file) throws Exception {
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        FileInputStream is = new FileInputStream(file);
        X509Certificate cert = (X509Certificate)fact.generateCertificate(is);
        return cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey getPrivateKey(String fileName, String password) throws Exception {
        StringBuilder sb = new StringBuilder();
        try (FileInputStream is = new FileInputStream(fileName);){
            int ch;
            while ((ch = is.read()) >= 0) {
                sb.append((char)ch);
            }
        }
        String str = sb.toString();
        PrivateKey key = null;
        BouncyProvider bouncy = BouncyProvider.getBouncy();
        if (bouncy != null) {
            key = bouncy.getPrivateKey(str, password);
        }
        if (key == null) {
            key = CurlSSLContextFactory.getPrivateKeyPkcs12(str);
        }
        if (key == null) {
            key = CurlSSLContextFactory.getPrivateKeyPkcs8(str);
        }
        if (key == null) {
            key = CurlSSLContextFactory.getPrivateKeyPkcs8Encrypted(str, password);
        }
        if (key == null) {
            throw new IOException("unknown key format: " + fileName);
        }
        return key;
    }

    private static byte[] getBytes(String str, String header, String footer) throws Exception {
        int p = str.indexOf(header);
        if (p < 0) {
            return null;
        }
        int q = str.indexOf(footer, p + header.length());
        if (q < 0) {
            throw new IOException("missing footer: " + footer);
        }
        str = str.substring(p + header.length(), q);
        String base64 = str.replaceAll("\\s", "");
        byte[] bytes = DatatypeConverter.parseBase64Binary((String)base64);
        return bytes;
    }

    private static PrivateKey getPrivateKeyPkcs12(String str) throws Exception {
        byte[] bytes = CurlSSLContextFactory.getBytes(str, PKCS12_HEADER, PKCS12_FOOTER);
        if (bytes == null) {
            return null;
        }
        DerInputStream derReader = new DerInputStream(bytes);
        DerValue[] seq = derReader.getSequence(0);
        BigInteger modulus = seq[1].getBigInteger();
        BigInteger publicExp = seq[2].getBigInteger();
        BigInteger privateExp = seq[3].getBigInteger();
        BigInteger prime1 = seq[4].getBigInteger();
        BigInteger prime2 = seq[5].getBigInteger();
        BigInteger exp1 = seq[6].getBigInteger();
        BigInteger exp2 = seq[7].getBigInteger();
        BigInteger crtCoef = seq[8].getBigInteger();
        RSAPrivateCrtKeySpec keySpec = new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, prime1, prime2, exp1, exp2, crtCoef);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return factory.generatePrivate(keySpec);
    }

    private static PrivateKey getPrivateKeyPkcs8(String str) throws Exception {
        byte[] bytes = CurlSSLContextFactory.getBytes(str, PKCS8_HEADER, PKCS8_FOOTER);
        if (bytes == null) {
            return null;
        }
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return factory.generatePrivate(new PKCS8EncodedKeySpec(bytes));
    }

    private static PrivateKey getPrivateKeyPkcs8Encrypted(String str, String password) throws Exception {
        byte[] bytes = CurlSSLContextFactory.getBytes(str, PKCS8_ENC_HEADER, PKCS8_ENC_FOOTER);
        if (bytes == null) {
            return null;
        }
        EncryptedPrivateKeyInfo encryptPKInfo = new EncryptedPrivateKeyInfo(bytes);
        Cipher cipher = Cipher.getInstance(encryptPKInfo.getAlgName());
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password.toCharArray());
        SecretKeyFactory secFac = SecretKeyFactory.getInstance(encryptPKInfo.getAlgName());
        SecretKey pbeKey = secFac.generateSecret(pbeKeySpec);
        AlgorithmParameters algParams = encryptPKInfo.getAlgParameters();
        cipher.init(2, (Key)pbeKey, algParams);
        PKCS8EncodedKeySpec keySpec = encryptPKInfo.getKeySpec(cipher);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return factory.generatePrivate(keySpec);
    }
}

