/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import com.caucho.quercus.lib.curl.CurlHostnameVerifier;
import com.caucho.quercus.lib.curl.CurlHttpConnection;
import com.caucho.quercus.lib.curl.CurlResource;
import com.caucho.quercus.lib.curl.CurlSSLContextFactory;
import java.io.IOException;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.TrustManager;

public class HttpsConnection
extends CurlHttpConnection {
    public HttpsConnection(URL url, String username, String password) throws IOException {
        super(url, username, password);
    }

    @Override
    protected void init(CurlResource curl) throws IOException {
        Proxy proxy = this.getProxy();
        HttpsURLConnection httpsConn = null;
        URLConnection conn = proxy != null ? this.getURL().openConnection(proxy) : this.getURL().openConnection();
        if (conn instanceof HttpsURLConnection) {
            httpsConn = (HttpsURLConnection)conn;
            if (curl.getSslKey() != null && curl.getSslCert() != null) {
                httpsConn.setSSLSocketFactory(HttpsConnection.createSSLContext(curl).getSocketFactory());
            } else if (!curl.getIsVerifySSLPeer()) {
                httpsConn.setSSLSocketFactory(HttpsConnection.createSSLContextUntrusted(curl).getSocketFactory());
            } else if (curl.getCaInfo() != null) {
                httpsConn.setSSLSocketFactory(HttpsConnection.createSSLContextCaInfo(curl).getSocketFactory());
            } else {
                httpsConn.setSSLSocketFactory(HttpsConnection.createSSLContextDefault(curl).getSocketFactory());
            }
            if (!(curl.getIsVerifySSLPeer() && curl.getIsVerifySSLCommonName() && curl.getIsVerifySSLHostname())) {
                CurlHostnameVerifier hostnameVerifier = CurlHostnameVerifier.create(curl.getIsVerifySSLPeer(), curl.getIsVerifySSLCommonName(), curl.getIsVerifySSLHostname());
                httpsConn.setHostnameVerifier(hostnameVerifier);
            }
        }
        this.setConnection(conn);
    }

    @Override
    public void connect(CurlResource curl) throws ConnectException, ProtocolException, SocketTimeoutException, IOException {
        try {
            super.connect(curl);
            ((HttpsURLConnection)this.getConnection()).getServerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            if (curl.getIsVerifySSLPeer()) {
                e.printStackTrace();
                throw e;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private static SSLContext createSSLContextCaInfo(CurlResource curl) throws IOException {
        String algorithm = curl.getSslVersion();
        String certFile = curl.getCaInfo();
        try {
            return CurlSSLContextFactory.createCaInfo(algorithm, certFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    private static SSLContext createSSLContext(CurlResource curl) throws IOException {
        String algorithm = curl.getSslVersion();
        String keyPass = curl.getSslKeyPassword();
        String certFile = curl.getSslCert();
        String keyFile = curl.getSslKey();
        try {
            SSLContext context = CurlSSLContextFactory.create(certFile, keyFile, keyPass, algorithm);
            return context;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static SSLContext createSSLContextUntrusted(CurlResource curl) throws IOException {
        try {
            String algorithm = curl.getSslVersion();
            SSLContext context = CurlSSLContextFactory.createUntrusted(algorithm);
            return context;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static SSLContext createSSLContextDefault(CurlResource curl) throws IOException {
        try {
            String algorithm = curl.getSslVersion();
            SSLContext context = SSLContext.getInstance(algorithm);
            context.init(null, HttpsConnection.createTrustManagerDefault(), null);
            return context;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static TrustManager[] createTrustManagerDefault() {
        return null;
    }
}

