/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.lib.db.JdbcConnectionResource;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.StatementType;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JdbcStatementResource {
    private static final Logger log = Log.open(JdbcStatementResource.class);
    private static final L10N L = new L10N(JdbcStatementResource.class);
    private JdbcConnectionResource _conn;
    private JdbcResultResource _rs;
    private String _query;
    private Statement _stmt;
    private Value[] _results;
    private SQLException _e;
    private String _errorMessage = "";
    private int _errorCode;
    private StatementType _stmtType;

    public JdbcStatementResource(JdbcConnectionResource conn) {
        this._conn = conn;
    }

    protected String getQuery() {
        return this._query;
    }

    protected void setQuery(String query) {
        this._stmtType = null;
        this._query = query;
    }

    protected void setStatement(Statement stmt) {
        this._stmt = stmt;
    }

    public StatementType getStatementType() {
        if (this._stmtType == null) {
            this._stmtType = StatementType.getStatementType(this.getQuery());
        }
        return this._stmtType;
    }

    public boolean bindResults(Env env, Value[] outParams) {
        int size = outParams.length;
        int numColumns = this.getColumnCount(env);
        if (numColumns < 0) {
            numColumns = size;
        }
        for (int i = 0; i < size; ++i) {
            Value val = outParams[i];
            if (val instanceof Var) continue;
            env.error(L.l("Only variables can be passed by reference"));
            return false;
        }
        if (size == 0 || size != numColumns) {
            env.warning(L.l("number of bound variables do not equal number of columns"));
            return false;
        }
        this._results = new Value[size];
        System.arraycopy(outParams, 0, this._results, 0, size);
        return true;
    }

    protected int getColumnCount(Env env) {
        try {
            ResultSetMetaData md = this.getMetaData();
            if (md == null) {
                return -1;
            }
            return md.getColumnCount();
        }
        catch (SQLException e) {
            this.setError(env, e);
            return -1;
        }
    }

    protected boolean close() {
        try {
            JdbcResultResource rs = this._rs;
            this._rs = null;
            if (rs != null) {
                rs.close();
            }
            if (this._stmt != null) {
                this._stmt.close();
            }
            return true;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    protected boolean dataSeek(int offset) {
        return this._rs.setRowNumber(offset);
    }

    protected SQLException getException() {
        return this._e;
    }

    protected int getErrorCode() {
        return this._errorCode;
    }

    protected String getErrorMessage() {
        return this._errorMessage;
    }

    protected boolean execute(Env env) {
        try {
            return this.execute(env, true);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected final boolean execute(Env env, boolean isCatchException) throws SQLException {
        if (this._stmt == null) {
            return false;
        }
        try {
            this.prepareForExecute(env);
            if (this.executeImpl(env)) {
                this._conn.setAffectedRows(0);
                ResultSet resultSet = this._stmt.getResultSet();
                this._rs = this.createResultSet(resultSet);
            } else {
                this._conn.setAffectedRows(this._stmt.getUpdateCount());
            }
            return true;
        }
        catch (SQLException e) {
            if (isCatchException) {
                this.setError(env, e);
                return false;
            }
            throw e;
        }
    }

    protected void setError(Env env, SQLException e) {
        log.log(Level.FINE, e.getMessage(), e);
        this._e = e;
        this._errorMessage = e.getMessage();
        this._errorCode = e.getErrorCode();
    }

    protected boolean prepareForExecute(Env env) throws SQLException {
        return true;
    }

    protected boolean executeImpl(Env env) throws SQLException {
        if (this.getStatementType() == StatementType.INSERT) {
            try {
                return this._stmt.execute(this._query, 1);
            }
            catch (SQLFeatureNotSupportedException e) {
                log.log(Level.FINE, e.getMessage(), e);
                return this._stmt.execute(this._query);
            }
        }
        return this._stmt.execute(this._query);
    }

    protected JdbcResultResource createResultSet(ResultSet rs) {
        return new JdbcResultResource(rs);
    }

    protected Value fetch(Env env) {
        if (this._rs == null) {
            return NullValue.NULL;
        }
        return this._rs.fetchBound(env, this._results);
    }

    public boolean freeResult() {
        JdbcResultResource rs = this._rs;
        this._rs = null;
        if (rs != null) {
            rs.close();
        }
        return true;
    }

    protected ResultSetMetaData getMetaData() throws SQLException {
        if (this._rs == null) {
            return null;
        }
        return this._rs.getMetaData();
    }

    public int getNumRows() throws SQLException {
        if (this._rs == null) {
            return 0;
        }
        return this._rs.getNumRows();
    }

    public int getFieldCount() {
        if (this._rs == null) {
            return 0;
        }
        return this._rs.getFieldCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String lastInsertId(Env env) throws SQLException {
        Statement stmt = this._stmt;
        if (stmt == null) {
            return null;
        }
        String lastInsertId = null;
        ResultSet resultSet = null;
        try {
            resultSet = stmt.getGeneratedKeys();
            if (resultSet.next()) {
                lastInsertId = resultSet.getString(1);
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return lastInsertId;
    }

    public JdbcResultResource getResultSet() {
        return this._rs;
    }

    protected void setResultSet(ResultSet rs) {
        this._rs = this.createResultSet(rs);
    }

    protected final JdbcConnectionResource getConnection() {
        return this._conn;
    }

    protected Connection getJavaConnection(Env env) throws SQLException {
        return this._conn.getJavaConnection(env);
    }

    protected void setErrorMessage(String msg) {
        this._errorMessage = msg;
    }

    protected void setErrorCode(int code) {
        this._errorCode = code;
    }

    protected boolean isFetchFieldIndexBeforeFieldName() {
        return true;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this._conn + "]";
    }
}

