/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.ColumnType;
import com.caucho.quercus.lib.db.JdbcPreparedStatementResource;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.Mysqli;
import com.caucho.quercus.lib.db.MysqliResult;
import com.caucho.util.L10N;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class MysqliStatement
extends JdbcPreparedStatementResource {
    private static final Logger log = Logger.getLogger(MysqliStatement.class.getName());
    private static final L10N L = new L10N(MysqliStatement.class);

    MysqliStatement(Mysqli conn) {
        super(conn);
    }

    @Override
    public boolean execute(Env env) {
        return super.execute(env);
    }

    public int getaffected_rows(Env env) {
        return this.affected_rows(env);
    }

    public int affected_rows(Env env) {
        return this.getConnection().getAffectedRows();
    }

    public boolean bind_param(Env env, StringValue typeStr, @Reference Value[] params) {
        int len = typeStr.length();
        ColumnType[] types = new ColumnType[len];
        for (int i = 0; i < len; ++i) {
            char ch = typeStr.charAt(i);
            if (ch == 's') {
                types[i] = ColumnType.STRING;
                continue;
            }
            if (ch == 'b') {
                types[i] = ColumnType.BLOB;
                continue;
            }
            if (ch == 'i') {
                types[i] = ColumnType.LONG;
                continue;
            }
            if (ch == 'd') {
                types[i] = ColumnType.DOUBLE;
                continue;
            }
            env.warning(L.l("invalid param type '{0}' in string '{1}'", (Object)Character.valueOf(ch), (Object)typeStr));
            return false;
        }
        return this.bindParams(env, types, params);
    }

    public boolean bind_result(Env env, @Reference Value[] outParams) {
        return this.bindResults(env, outParams);
    }

    @Override
    public boolean close() {
        return super.close();
    }

    public Value data_seek(Env env, int offset) {
        if (this.dataSeek(offset)) {
            return NullValue.NULL;
        }
        return BooleanValue.FALSE;
    }

    public int errno() {
        return this.getErrorCode();
    }

    public int geterrno() {
        return this.errno();
    }

    public StringValue error(Env env) {
        return env.createString(this.getErrorMessage());
    }

    @ReturnNullAsFalse
    public StringValue geterror(Env env) {
        return this.error(env);
    }

    @Override
    public Value fetch(Env env) {
        return super.fetch(env);
    }

    public void free_result(Env env) {
        this.freeResult();
    }

    public JdbcResultResource get_result(Env env) {
        return this.getResultSet();
    }

    @Override
    protected JdbcResultResource createResultSet(ResultSet rs) {
        return new MysqliResult(this.getPreparedStatement(), rs, (Mysqli)this.getConnection());
    }

    public Value getnum_rows(Env env) {
        return this.num_rows(env);
    }

    public Value num_rows(Env env) {
        JdbcResultResource rs = this.getResultSet();
        if (rs != null) {
            return LongValue.create(rs.getNumRows());
        }
        return BooleanValue.FALSE;
    }

    public int getparam_count(Env env) {
        return this.param_count(env);
    }

    public int param_count(Env env) {
        return this.paramCount();
    }

    @Override
    public boolean prepare(Env env, String query) {
        return super.prepare(env, query);
    }

    public boolean reset(Env env) {
        return true;
    }

    @ReturnNullAsFalse
    public MysqliResult result_metadata(Env env) {
        try {
            if (this.getResultSet() != null) {
                return new MysqliResult(this.getMetaData(), (Mysqli)this.getConnection());
            }
            return null;
        }
        catch (SQLException e) {
            throw new QuercusModuleException(e);
        }
    }

    public boolean send_long_data(Env env, int paramNumber, String data) {
        throw new UnimplementedException("mysqli_stmt_send_long_data");
    }

    public StringValue getsqlstate(Env env) {
        return this.sqlstate(env);
    }

    public StringValue sqlstate(Env env) {
        int code = this.errno();
        return env.createString(Mysqli.lookupSqlstate(code));
    }

    public boolean store_result(Env env) {
        return true;
    }

    public int getfield_count(Env env) {
        return this.field_count(env);
    }

    public int field_count(Env env) {
        return this.getFieldCount();
    }

    public Value getinsert_id(Env env) {
        return this.insert_id(env);
    }

    public Value insert_id(Env env) {
        return ((Mysqli)this.getConnection()).insert_id(env);
    }
}

