/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.JdbcPreparedStatementResource;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.Oracle;
import com.caucho.quercus.lib.db.OracleOciLob;
import com.caucho.quercus.lib.db.OracleResult;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Logger;

public class OracleStatement
extends JdbcPreparedStatementResource {
    private static final Logger log = Logger.getLogger(OracleStatement.class.getName());
    private Oracle _conn;
    private int _fetchedRows = 0;
    private HashMap<String, Integer> _bindingVariables = new HashMap();
    private OracleOciLob _outParameter = null;
    private Value _resultBuffer;
    private HashMap<String, Value> _byNameVariables = new HashMap();

    OracleStatement(Oracle conn) {
        super(conn);
    }

    protected boolean execute(Env env, int mode) {
        try {
            Connection conn = this.getJavaConnection(env);
            conn.setAutoCommit(false);
            CallableStatement callableStatement = this.getCallableStatement();
            Object cursorResult = null;
            try {
                cursorResult = callableStatement.getObject(1);
                if (cursorResult != null && cursorResult instanceof ResultSet) {
                    ResultSet rs = (ResultSet)cursorResult;
                    this.setResultSet(rs);
                    return true;
                }
            }
            catch (Exception rs) {
                // empty catch block
            }
            this.execute(env, false);
            OracleOciLob ociLob = this.getOutParameter();
            if (ociLob != null) {
                ociLob.setLob(callableStatement.getObject(1));
            }
            if (mode == 82) {
                conn.commit();
            }
            return true;
        }
        catch (SQLException e) {
            env.warning(e);
            this.resetBindingVariables();
            this.resetByNameVariables();
            return false;
        }
    }

    @Override
    protected JdbcResultResource createResultSet(ResultSet rs) {
        return new OracleResult(rs, this._conn);
    }

    public void putBindingVariable(String name, Integer value) {
        this._bindingVariables.put(name, value);
    }

    public Integer getBindingVariable(String name) {
        return this._bindingVariables.get(name);
    }

    public Integer removeBindingVariable(String name) {
        return this._bindingVariables.remove(name);
    }

    public HashMap<String, Integer> getBindingVariables() {
        return this._bindingVariables;
    }

    public void resetBindingVariables() {
        this._bindingVariables = new HashMap();
    }

    public void setResultBuffer(Value resultBuffer) {
        this._resultBuffer = resultBuffer;
    }

    public Value getResultBuffer() {
        return this._resultBuffer;
    }

    public void putByNameVariable(String name, Value value) {
        this._byNameVariables.put(name, value);
    }

    public Value getByNameVariable(String name) {
        return this._byNameVariables.get(name);
    }

    public Value removeByNameVariable(String name) {
        return this._byNameVariables.remove(name);
    }

    public HashMap<String, Value> getByNameVariables() {
        return this._byNameVariables;
    }

    public void resetByNameVariables() {
        this._byNameVariables = new HashMap();
    }

    protected int increaseFetchedRows() {
        return ++this._fetchedRows;
    }

    protected CallableStatement getCallableStatement() {
        return (CallableStatement)this.getPreparedStatement();
    }

    protected int getFetchedRows() {
        return this._fetchedRows;
    }

    protected OracleOciLob getOutParameter() {
        return this._outParameter;
    }

    protected void setOutParameter(OracleOciLob outParameter) {
        this._outParameter = outParameter;
    }
}

