/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.env.ConnectionEntry;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.db.JdbcConnectionResource;
import com.caucho.quercus.lib.db.JdbcDriverContext;
import java.sql.SQLException;

public class SQLite3
extends JdbcConnectionResource {
    public SQLite3(Env env, String jdbcUrl) {
        super(env);
        this.connectInternal(env, null, null, null, null, -1, null, 0, null, jdbcUrl, true, false);
    }

    @Override
    protected ConnectionEntry connectImpl(Env env, String host, String userName, String password, String dbname, int port, String socket, int flags, String driver, String url, boolean isNewLink, boolean isEmulatePrepares) {
        try {
            if (driver == null) {
                JdbcDriverContext driverContext = env.getQuercus().getJdbcDriverContext();
                driver = driverContext.getDriver("sqlite");
            }
            if (driver == null) {
                driver = "org.sqlite.JDBC";
            }
            this._driver = driver;
            ConnectionEntry jConn = env.getConnection(driver, url, null, null, !isNewLink);
            return jConn;
        }
        catch (SQLException e) {
            env.warning(e);
            return null;
        }
        catch (Exception e) {
            env.warning(e);
            return null;
        }
    }

    @Override
    protected String getDriverName() {
        return "sqlite";
    }

    @Override
    protected boolean isSeekable() {
        return false;
    }
}

