/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.lib.file.FileReadValue;
import com.caucho.quercus.lib.file.FileValue;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileWriteValue
extends FileValue {
    private static final Logger log = Logger.getLogger(FileReadValue.class.getName());
    private WriteStream _os;
    private long _offset;

    public FileWriteValue(Path path) throws IOException {
        super(path);
        this._os = path.openWrite();
    }

    public FileWriteValue(Path path, boolean isAppend) throws IOException {
        super(path);
        this._os = isAppend ? path.openAppend() : path.openWrite();
    }

    @Override
    public void print(char v) throws IOException {
        if (this._os != null) {
            this._os.print(v);
        }
    }

    @Override
    public void print(String v) throws IOException {
        if (this._os != null) {
            this._os.print(v);
        }
    }

    @Override
    public int write(byte[] buffer, int offset, int length) throws IOException {
        if (this._os != null) {
            this._os.write(buffer, offset, length);
            return length;
        }
        return 0;
    }

    @Override
    public void flush() {
        try {
            if (this._os != null) {
                this._os.flush();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    @Override
    public void close() {
        try {
            WriteStream os = this._os;
            this._os = null;
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    @Override
    public String toString() {
        return "File[" + this.getPath() + "]";
    }
}

