/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.EnvCleanup;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.AbstractBinaryOutput;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.BinaryOutput;
import com.caucho.quercus.lib.file.LineReader;
import com.caucho.quercus.resources.StreamContextResource;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.HttpStreamWrapper;
import com.caucho.vfs.LockableStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpInputOutput
extends AbstractBinaryOutput
implements BinaryInput,
BinaryOutput,
LockableStream,
EnvCleanup {
    private static final Logger log = Logger.getLogger(HttpInputOutput.class.getName());
    private Env _env;
    private Path _path;
    private StreamContextResource _context;
    private LineReader _lineReader;
    private ReadStream _is;
    private WriteStream _os;
    private HttpStreamWrapper _httpStream;
    private Reader _readEncoding;
    private String _readEncodingName;
    private byte[] _bodyStart;

    public HttpInputOutput(Env env, Path path, StreamContextResource context) throws IOException {
        this.init(env, path, context);
    }

    private void init(Env env, Path path, StreamContextResource context) throws IOException {
        this._env = env;
        this._path = path;
        env.addCleanup(this);
        this._path = path;
        this._lineReader = new LineReader(env);
        if (context != null) {
            Value options = context.getOptions().get(env.createString(path.getScheme()));
            String method = options.get(env.createString("method")).toString();
            if (method.equals("POST")) {
                ReadWritePair pair = path.openReadWrite();
                this._is = pair.getReadStream();
                this._os = pair.getWriteStream();
            } else {
                this._is = path.openRead();
            }
            this._httpStream = (HttpStreamWrapper)this._is.getSource();
            this.setOptions(env, options);
            if (this._os != null && this._bodyStart != null && this._bodyStart.length > 0) {
                this._os.write(this._bodyStart, 0, this._bodyStart.length);
            }
        } else {
            this._is = path.openRead();
            this._httpStream = (HttpStreamWrapper)this._is.getSource();
        }
    }

    private void setOptions(Env env, Value options) throws IOException {
        Iterator<Map.Entry<Value, Value>> iter = options.getIterator(env);
        block0: while (iter.hasNext()) {
            Map.Entry<Value, Value> entry = iter.next();
            String optionName = entry.getKey().toString();
            Value optionValue = entry.getValue();
            if (optionName.equals("method")) {
                this._httpStream.setMethod(optionValue.toString());
                continue;
            }
            if (optionName.equals("header")) {
                String option = optionValue.toString();
                int start = 0;
                int len = option.length();
                while (start < len) {
                    int i;
                    int end = option.indexOf("\r\n", start);
                    if (end < 0) {
                        end = len;
                    }
                    if ((i = option.indexOf(58, start)) < 0 || i > end) {
                        this._httpStream.setAttribute(option.substring(start, end), "");
                        continue block0;
                    }
                    String name = option.substring(start, i);
                    String value = option.substring(i + 1, end).trim();
                    this._httpStream.setAttribute(name, value);
                    start = end += 2;
                }
                continue;
            }
            if (optionName.equals("user_agent")) {
                this._httpStream.setAttribute("User-Agent", optionValue.toString());
                continue;
            }
            if (optionName.equals("content")) {
                this._bodyStart = optionValue.toBinaryValue(env).toBytes();
                continue;
            }
            if (optionName.equals("proxy")) {
                env.stub("StreamContextResource::proxy option");
                continue;
            }
            if (optionName.equals("request_fulluri")) {
                env.stub("StreamContextResource::request_fulluri option");
                continue;
            }
            if (optionName.equals("protocol_version")) {
                double version = optionValue.toDouble();
                if (version == 1.1) continue;
                if (version == 1.0) {
                    this._httpStream.setHttp10();
                    continue;
                }
                env.stub("StreamContextResource::protocol_version " + version);
                continue;
            }
            if (optionName.equals("timeout")) {
                long ms = (long)optionValue.toDouble() * 1000L;
                this._httpStream.setSocketTimeout(ms);
                continue;
            }
            if (optionName.equals("ignore_errors")) {
                env.stub("ignore_errors::ignore_errors option");
                continue;
            }
            env.stub("ignore_errors::" + optionName + " option");
        }
    }

    @Override
    public void write(int ch) throws IOException {
        if (this._os != null) {
            this._os.write(ch);
        }
    }

    @Override
    public StringValue appendTo(StringValue builder) throws IOException {
        if (this._is != null) {
            return builder.append(this._is);
        }
        return builder;
    }

    @Override
    public InputStream getInputStream() {
        return this._is;
    }

    @Override
    public int getAvailable() throws IOException {
        return this._is.available();
    }

    @Override
    public BinaryInput openCopy() throws IOException {
        return new HttpInputOutput(this._env, this._path, this._context);
    }

    @Override
    public int read() throws IOException {
        if (this._is != null) {
            return this._is.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this._is != null) {
            return this._is.read(buffer, offset, length);
        }
        return -1;
    }

    public int read(char[] buffer, int offset, int length) throws IOException {
        if (this._is != null) {
            return this._is.read(buffer, offset, length);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringValue read(int length) throws IOException {
        StringValue bb = this._env.createBinaryBuilder();
        TempBuffer temp = TempBuffer.allocate();
        try {
            byte[] buffer = temp.getBuffer();
            while (length > 0) {
                int sublen = buffer.length;
                if (length < sublen) {
                    sublen = length;
                }
                if ((sublen = this.read(buffer, 0, sublen)) > 0) {
                    bb.append(buffer, 0, sublen);
                    length -= sublen;
                    continue;
                }
                break;
            }
        }
        finally {
            TempBuffer.free(temp);
        }
        return bb;
    }

    @Override
    public StringValue readLine(long length) throws IOException {
        return this._lineReader.readLine(this._env, this, length);
    }

    @Override
    public boolean readOptionalLinefeed() throws IOException {
        int ch = this.read();
        if (ch == 10) {
            return true;
        }
        this.unread();
        return false;
    }

    @Override
    public boolean isEOF() {
        try {
            if (this._is == null) {
                return true;
            }
            return this._is.available() <= 0;
        }
        catch (IOException e) {
            return true;
        }
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        String mimeName = Encoding.getMimeName(encoding);
        if (mimeName != null && mimeName.equals(this._readEncodingName)) {
            return;
        }
        this._readEncoding = Encoding.getReadEncoding(this.getInputStream(), encoding);
        this._readEncodingName = mimeName;
    }

    @Override
    public void unread() throws IOException {
        if (this._is != null) {
            this._is.unread();
        }
    }

    @Override
    public boolean lock(boolean shared, boolean block) {
        return false;
    }

    @Override
    public boolean unlock() {
        return false;
    }

    @Override
    public void closeRead() {
        this.close();
    }

    @Override
    public void close() {
        this._env.removeCleanup(this);
        this.cleanup();
    }

    @Override
    public void cleanup() {
        try {
            ReadStream is = this._is;
            WriteStream os = this._os;
            this._is = null;
            this._os = null;
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public String toString() {
        return "HttpInputOutput[" + this._path + "]";
    }
}

