/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.BinaryOutput;
import com.caucho.quercus.lib.file.LineReader;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class WrappedStream
implements BinaryInput,
BinaryOutput {
    private static final ConstStringValue STREAM_CLOSE = new ConstStringValue("stream_close");
    private static final ConstStringValue STREAM_EOF = new ConstStringValue("stream_eof");
    private static final ConstStringValue STREAM_FLUSH = new ConstStringValue("stream_flush");
    private static final ConstStringValue STREAM_OPEN = new ConstStringValue("stream_open");
    private static final ConstStringValue STREAM_READ = new ConstStringValue("stream_read");
    private static final ConstStringValue STREAM_SEEK = new ConstStringValue("stream_seek");
    private static final ConstStringValue STREAM_TELL = new ConstStringValue("stream_tell");
    private static final ConstStringValue STREAM_WRITE = new ConstStringValue("stream_write");
    private static final UnicodeBuilderValue STREAM_CLOSE_U = new UnicodeBuilderValue("stream_close");
    private static final UnicodeBuilderValue STREAM_EOF_U = new UnicodeBuilderValue("stream_eof");
    private static final UnicodeBuilderValue STREAM_FLUSH_U = new UnicodeBuilderValue("stream_flush");
    private static final UnicodeBuilderValue STREAM_OPEN_U = new UnicodeBuilderValue("stream_open");
    private static final UnicodeBuilderValue STREAM_READ_U = new UnicodeBuilderValue("stream_read");
    private static final UnicodeBuilderValue STREAM_SEEK_U = new UnicodeBuilderValue("stream_seek");
    private static final UnicodeBuilderValue STREAM_TELL_U = new UnicodeBuilderValue("stream_tell");
    private static final UnicodeBuilderValue STREAM_WRITE_U = new UnicodeBuilderValue("stream_write");
    private byte[] printBuffer = new byte[1];
    private Env _env;
    private Value _wrapper;
    private LineReader _lineReader;
    private InputStream _is;
    private OutputStream _os;
    private int _buffer;
    private boolean _doUnread = false;
    private int _writeLength;

    private WrappedStream(Env env, Value wrapper) {
        this._env = env;
        this._wrapper = wrapper;
        this._lineReader = new LineReader(env);
    }

    public WrappedStream(Env env, QuercusClass qClass, StringValue path, StringValue mode, LongValue options) {
        this._env = env;
        this._lineReader = new LineReader(env);
        this._wrapper = qClass.callNew(env, Value.NULL_ARGS);
        if (env.isUnicodeSemantics()) {
            this._wrapper.callMethod(env, (StringValue)STREAM_OPEN_U, path, (Value)mode, (Value)options, (Value)NullValue.NULL);
        } else {
            this._wrapper.callMethod(env, (StringValue)STREAM_OPEN, path, (Value)mode, (Value)options, (Value)NullValue.NULL);
        }
    }

    @Override
    public InputStream getInputStream() {
        if (this._is == null) {
            this._is = new WrappedInputStream();
        }
        return this._is;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this._os == null) {
            this._os = new WrappedOutputStream();
        }
        return this._os;
    }

    @Override
    public BinaryInput openCopy() throws IOException {
        return new WrappedStream(this._env, this._wrapper);
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
    }

    @Override
    public void closeRead() {
        this.close();
    }

    @Override
    public void closeWrite() {
        this.close();
    }

    @Override
    public void close() {
        QuercusClass cls = this._wrapper.getQuercusClass();
        if (cls != null) {
            StringValue funName = this._env.isUnicodeSemantics() ? STREAM_CLOSE_U : STREAM_CLOSE;
            AbstractFunction fun = cls.findFunction(funName);
            if (fun == null) {
                return;
            }
            this._wrapper.callMethod(this._env, funName);
        }
    }

    @Override
    public int getAvailable() throws IOException {
        return 1;
    }

    @Override
    public int read() throws IOException {
        if (this._doUnread) {
            this._doUnread = false;
            return this._buffer;
        }
        Value output = this._env.isUnicodeSemantics() ? this._wrapper.callMethod(this._env, (StringValue)STREAM_READ_U, LongValue.ONE) : this._wrapper.callMethod(this._env, (StringValue)STREAM_READ, LongValue.ONE);
        this._buffer = (int)output.toLong();
        return this._buffer;
    }

    @Override
    public void unread() throws IOException {
        this._doUnread = true;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) {
        Value output = this._env.isUnicodeSemantics() ? this._wrapper.callMethod(this._env, (StringValue)STREAM_READ_U, LongValue.create(length)) : this._wrapper.callMethod(this._env, (StringValue)STREAM_READ, LongValue.create(length));
        if (output.length() == 0) {
            return -1;
        }
        byte[] outputBytes = output.toString().getBytes();
        if (outputBytes.length < length) {
            length = outputBytes.length;
        }
        System.arraycopy(outputBytes, 0, buffer, offset, length);
        return length;
    }

    public int read(char[] buffer, int offset, int length) {
        Value output = this._env.isUnicodeSemantics() ? this._wrapper.callMethod(this._env, (StringValue)STREAM_READ_U, LongValue.create(length)) : this._wrapper.callMethod(this._env, (StringValue)STREAM_READ, LongValue.create(length));
        if (output.length() == 0) {
            return -1;
        }
        byte[] outputBytes = output.toString().getBytes();
        if (outputBytes.length < length) {
            length = outputBytes.length;
        }
        System.arraycopy(outputBytes, 0, buffer, offset, length);
        return length;
    }

    @Override
    public StringValue appendTo(StringValue builder) {
        try {
            int ch;
            while ((ch = this.read()) >= 0) {
                builder.append((char)ch);
            }
            return builder;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    @Override
    public StringValue read(int length) throws IOException {
        Value output = this._env.isUnicodeSemantics() ? this._wrapper.callMethod(this._env, (StringValue)STREAM_READ_U, LongValue.create(length)) : this._wrapper.callMethod(this._env, (StringValue)STREAM_READ, LongValue.create(length));
        return output.toBinaryValue(this._env);
    }

    @Override
    public boolean readOptionalLinefeed() throws IOException {
        int ch = this.read();
        if (ch == 10) {
            return true;
        }
        this.unread();
        return false;
    }

    @Override
    public StringValue readLine(long length) throws IOException {
        return this._lineReader.readLine(this._env, this, length);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        StringValue bb = this._env.createBinaryBuilder(buffer, offset, length);
        Value output = this._env.isUnicodeSemantics() ? this._wrapper.callMethod(this._env, (StringValue)STREAM_WRITE_U, bb) : this._wrapper.callMethod(this._env, (StringValue)STREAM_WRITE, bb);
        this._writeLength = (int)output.toLong();
    }

    @Override
    public int write(InputStream is, int length) {
        int writeLength = 0;
        TempBuffer tb = TempBuffer.allocate();
        byte[] buffer = tb.getBuffer();
        try {
            int sublen;
            while (length > 0) {
                sublen = length < buffer.length ? length : buffer.length;
                if ((sublen = is.read(buffer, 0, sublen)) < 0) break;
                for (int offset = 0; offset < sublen; offset += this._writeLength) {
                    this.write(buffer, offset, sublen);
                    if (this._writeLength > 0) {
                        continue;
                    }
                    int n = writeLength;
                    return n;
                }
                writeLength += sublen;
                length -= sublen;
            }
            sublen = writeLength;
            return sublen;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        finally {
            TempBuffer.free(tb);
        }
    }

    @Override
    public void print(char v) throws IOException {
        this.printBuffer[0] = (byte)v;
        this.write(this.printBuffer, 0, 1);
    }

    @Override
    public void print(String v) throws IOException {
        for (int i = 0; i < v.length(); ++i) {
            this.print(v.charAt(i));
        }
    }

    @Override
    public boolean isEOF() {
        if (this._env.isUnicodeSemantics()) {
            return this._wrapper.callMethod(this._env, STREAM_EOF_U).toBoolean();
        }
        return this._wrapper.callMethod(this._env, STREAM_EOF).toBoolean();
    }

    @Override
    public long getPosition() {
        if (this._env.isUnicodeSemantics()) {
            return this._wrapper.callMethod(this._env, STREAM_TELL_U).toLong();
        }
        return this._wrapper.callMethod(this._env, STREAM_TELL).toLong();
    }

    @Override
    public boolean setPosition(long offset) {
        LongValue offsetValue = LongValue.create(offset);
        LongValue whenceValue = LongValue.create(0L);
        if (this._env.isUnicodeSemantics()) {
            return this._wrapper.callMethod(this._env, (StringValue)STREAM_SEEK_U, offsetValue, (Value)whenceValue).toBoolean();
        }
        return this._wrapper.callMethod(this._env, (StringValue)STREAM_SEEK, offsetValue, (Value)whenceValue).toBoolean();
    }

    @Override
    public long seek(long offset, int whence) {
        LongValue offsetValue = LongValue.create(offset);
        LongValue whenceValue = LongValue.create(whence);
        if (this._env.isUnicodeSemantics()) {
            return this._wrapper.callMethod(this._env, (StringValue)STREAM_SEEK_U, offsetValue, (Value)whenceValue).toLong();
        }
        return this._wrapper.callMethod(this._env, (StringValue)STREAM_SEEK, offsetValue, (Value)whenceValue).toLong();
    }

    @Override
    public void flush() throws IOException {
        boolean result = this._env.isUnicodeSemantics() ? this._wrapper.callMethod(this._env, STREAM_FLUSH_U).toBoolean() : this._wrapper.callMethod(this._env, STREAM_FLUSH).toBoolean();
        if (!result) {
            throw new IOException();
        }
    }

    @Override
    public Value stat() {
        if (this._env.isUnicodeSemantics()) {
            return this._wrapper.callMethod(this._env, STREAM_FLUSH_U);
        }
        return this._wrapper.callMethod(this._env, STREAM_FLUSH);
    }

    private class WrappedOutputStream
    extends OutputStream {
        private WrappedOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            if (WrappedStream.this._env.isUnicodeSemantics()) {
                WrappedStream.this._wrapper.callMethod(WrappedStream.this._env, (StringValue)STREAM_WRITE_U, LongValue.create(b));
            } else {
                WrappedStream.this._wrapper.callMethod(WrappedStream.this._env, (StringValue)STREAM_WRITE, LongValue.create(b));
            }
        }
    }

    private class WrappedInputStream
    extends InputStream {
        private WrappedInputStream() {
        }

        @Override
        public int read() throws IOException {
            return WrappedStream.this.read();
        }
    }
}

