/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.filter;

import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.filter.AbstractFilter;
import com.caucho.quercus.lib.filter.ValidateFilter;

public class EmailValidateFilter
extends AbstractFilter
implements ValidateFilter {
    @Override
    public Value filter(Env env, Value value, Value flagV) {
        StringValue str = value.toStringValue(env);
        EmailParser parser = new EmailParser(str);
        boolean isValid = parser.parse();
        if (isValid) {
            return value;
        }
        return BooleanValue.FALSE;
    }

    static class EmailParser {
        private final StringValue _s;
        private final int _length;
        private int _offset;

        public EmailParser(StringValue s) {
            this._s = s;
            this._length = s.length();
        }

        protected int getOffset() {
            return this._offset;
        }

        public boolean parse() {
            int atSignPos = this._s.indexOf('@');
            if (atSignPos < 0) {
                return false;
            }
            if (!this.parseLocalPart()) {
                return false;
            }
            if (this.read() != 64) {
                return false;
            }
            if (!this.parseDomain()) {
                return false;
            }
            return this._length <= this._offset;
        }

        private boolean parseLocalPart() {
            block2: {
                int ch;
                if (!this.parseWord()) {
                    return false;
                }
                while ((ch = this.read()) == 46) {
                    if (this.parseWord()) continue;
                    this.unread();
                    break block2;
                }
                this.unread();
            }
            return true;
        }

        private boolean parseWord() {
            int ch = this.peek();
            if (ch == 34) {
                return this.parseQuotedString();
            }
            return this.parseAtom();
        }

        private boolean parseAtom() {
            if (!this.parseAtomInner()) {
                return false;
            }
            while (this.parseAtomInner()) {
            }
            return true;
        }

        private boolean parseAtomInner() {
            int ch = this.read();
            if (ch < 0) {
                this.unread();
                return false;
            }
            if (EmailParser.isSpecial(ch)) {
                this.unread();
                return false;
            }
            if (EmailParser.isCtrl(ch)) {
                this.unread();
                return false;
            }
            if (ch == 32) {
                this.unread();
                return false;
            }
            return true;
        }

        private static boolean isSpecial(int ch) {
            return ch == 40 || ch == 41 || ch == 60 || ch == 62 || ch == 64 || ch == 44 || ch == 59 || ch == 58 || ch == 92 || ch == 34 || ch == 46 || ch == 91 || ch == 93;
        }

        private static boolean isCtrl(int ch) {
            return ch <= 31 || ch == 255;
        }

        private boolean parseQuotedString() {
            block4: {
                block5: {
                    int ch = this.read();
                    if (ch != 34) {
                        this.unread();
                        return false;
                    }
                    while (true) {
                        if ((ch = this.read()) < 0 || ch == 34) {
                            this.unread();
                            break block4;
                        }
                        if (ch == 92) {
                            if (this.read() >= 0) continue;
                            this.unread();
                            this.unread();
                            break block4;
                        }
                        if (ch != 13) continue;
                        if (this.peek() != 10) break block5;
                        this.unread();
                        if (!this.parseLinearWhitespace()) break;
                    }
                    break block4;
                }
                this.unread();
            }
            return this.read() == 34;
        }

        private boolean parseDomain() {
            block2: {
                int ch;
                if (!this.parseSubDomain()) {
                    return false;
                }
                while ((ch = this.read()) == 46) {
                    if (this.parseSubDomain()) continue;
                    this.unread();
                    break block2;
                }
                this.unread();
            }
            return true;
        }

        private boolean parseSubDomain() {
            int ch = this.peek();
            if (ch == 91) {
                return this.parseDomainLiteral();
            }
            return this.parseDomainRef();
        }

        private boolean parseDomainLiteral() {
            int ch = this.read();
            if (ch != 91) {
                return false;
            }
            while (true) {
                if ((ch = this.read()) == 92) {
                    if (this.read() >= 0) continue;
                    return false;
                }
                this.unread();
                if (!this.parseDomainText()) break;
            }
            return this.read() == 93;
        }

        private boolean parseDomainText() {
            int ch = this.read();
            if (ch < 0) {
                this.unread();
                return false;
            }
            if (ch == 91 || ch == 93 || ch == 92) {
                this.unread();
                return false;
            }
            if (ch == 13) {
                if (this.peek() == 10) {
                    this.unread();
                    return this.parseLinearWhitespace();
                }
                this.unread();
                return false;
            }
            return true;
        }

        private boolean parseLinearWhitespace() {
            if (!this.parseLinearWhitespaceInner()) {
                return false;
            }
            while (this.parseLinearWhitespaceInner()) {
            }
            return true;
        }

        private boolean parseLinearWhitespaceInner() {
            boolean isSawCrLf = false;
            int ch = this.read();
            if (ch == 13) {
                if (this.read() == 10) {
                    ch = this.read();
                    isSawCrLf = true;
                } else {
                    this.unread();
                    this.unread();
                    return false;
                }
            }
            if (ch == 32 || ch == 9) {
                return true;
            }
            this.unread();
            if (isSawCrLf) {
                this.unread();
                this.unread();
            }
            return false;
        }

        private boolean parseDomainRef() {
            return this.parseAtom();
        }

        private int read() {
            int offset;
            if (this._length <= (offset = this._offset++)) {
                return -1;
            }
            return this._s.charAt(offset);
        }

        private int peek() {
            if (this._length <= this._offset) {
                return -1;
            }
            return this._s.charAt(this._offset);
        }

        private void unread() {
            --this._offset;
        }
    }
}

