/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.filter;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.filter.AbstractFilter;
import com.caucho.quercus.lib.filter.ValidateFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IpValidateFilter
extends AbstractFilter
implements ValidateFilter {
    @Override
    protected Value filterImpl(Env env, Value value, int flags, ArrayValue options) {
        int pos;
        boolean isIpV6;
        if (!value.isString()) {
            return BooleanValue.FALSE;
        }
        boolean isIpV4 = (flags & 0x100000) > 0;
        boolean bl = isIpV6 = (flags & 0x200000) > 0;
        if (!isIpV4 && !isIpV6) {
            isIpV4 = true;
            isIpV6 = true;
        }
        boolean isRejectReserved = (flags & 0x400000) > 0;
        boolean isRejectPrivate = (flags & 0x800000) > 0;
        StringValue str = value.toStringValue(env);
        if (isIpV4 && (pos = str.indexOf('.')) >= 0) {
            if (this.isValidIp4(str, isRejectReserved, isRejectPrivate)) {
                return value;
            }
            return BooleanValue.FALSE;
        }
        if (isIpV6 && (pos = str.indexOf(':')) >= 0) {
            if (IpValidateFilter.isValidIp6(str, isRejectReserved, isRejectPrivate)) {
                return value;
            }
            return BooleanValue.FALSE;
        }
        return BooleanValue.FALSE;
    }

    private boolean isValidIp4(StringValue str, boolean isRejectReserved, boolean isRejectPrivate) {
        InputStream is = str.toInputStream();
        int part0 = this.parseIp4Part(is, false);
        if (part0 < 0 || part0 > 255) {
            return false;
        }
        if (isRejectReserved && (part0 == 0 || 224 <= part0 && part0 <= 255)) {
            return false;
        }
        if (isRejectPrivate && part0 == 10) {
            return false;
        }
        int part1 = this.parseIp4Part(is, false);
        if (part1 < 0 || part1 > 255) {
            return false;
        }
        if (isRejectReserved ? part0 == 169 && part1 == 254 : isRejectPrivate && (part0 == 172 && 16 <= part1 && part1 <= 31 || part0 == 192 && part1 == 168)) {
            return false;
        }
        int part2 = this.parseIp4Part(is, false);
        if (part2 < 0 || part2 > 255) {
            return false;
        }
        if (isRejectReserved && part0 == 192 && part1 == 0 && part2 == 2) {
            return false;
        }
        int part3 = this.parseIp4Part(is, true);
        return part3 >= 0 && part3 <= 255;
    }

    private int parseIp4Part(InputStream is, boolean isLast) {
        try {
            int ch = is.read();
            if (48 > ch || ch > 57) {
                return -1;
            }
            int value = ch - 48;
            ch = is.read();
            if (48 > ch || ch > 57) {
                if (!isLast && ch == 46) {
                    return value;
                }
                if (isLast && ch < 0) {
                    return value;
                }
                return -1;
            }
            value = value * 10 + ch - 48;
            ch = is.read();
            if (48 > ch || ch > 57) {
                if (!isLast && ch == 46) {
                    return value;
                }
                if (isLast && ch < 0) {
                    return value;
                }
                return -1;
            }
            value = value * 10 + ch - 48;
            ch = is.read();
            if (ch == 46 || isLast && ch < 0) {
                return value;
            }
            return -1;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isValidIp6(StringValue str, boolean isRejectReserved, boolean isRejectPrivate) {
        try {
            InetAddress ip = InetAddress.getByName(str.toString());
            return ip instanceof Inet6Address;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }
}

