/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.gae;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.gae.GaeUser;
import com.caucho.quercus.lib.gae.GaeUserService;
import com.caucho.quercus.module.AbstractQuercusModule;
import java.util.HashSet;
import java.util.Map;

public class GaeUserServiceModule
extends AbstractQuercusModule {
    @Override
    public String[] getLoadedExtensions() {
        return new String[]{"gae_users"};
    }

    public static String gae_users_create_login_url(Env env, String destinationUrl, @Optional String authDomain, @Optional String federatedIdentity, @Optional Value attributesRequest) {
        HashSet<String> attributeSet = null;
        if (!attributesRequest.isDefault()) {
            attributeSet = new HashSet<String>();
            ArrayValue array = attributesRequest.toArrayValue(env);
            for (Map.Entry<Value, Value> entrySet : array.entrySet()) {
                attributeSet.add(entrySet.getValue().toString());
            }
        }
        return GaeUserService.createLoginURL(destinationUrl, authDomain, federatedIdentity, attributeSet);
    }

    public static String gae_users_create_logout_url(Env env, String destinationUrl, @Optional String authDomain) {
        return GaeUserService.createLogoutURL(destinationUrl, authDomain);
    }

    public static GaeUser gae_users_get_current_user(Env env) {
        return GaeUserService.getCurrentUser();
    }

    public static boolean gae_users_is_user_admin(Env env) {
        return GaeUserService.isUserAdmin();
    }

    public static boolean gae_users_is_user_logged_in(Env env) {
        return GaeUserService.isUserLoggedIn();
    }
}

