/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.i18n;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BinaryValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.i18n.Decoder;
import com.caucho.quercus.lib.i18n.Encoder;
import com.caucho.quercus.lib.i18n.QuercusMimeUtility;
import com.caucho.quercus.lib.i18n.UnicodeUtility;
import com.caucho.quercus.lib.i18n.Utf8Decoder;
import com.caucho.quercus.lib.i18n.Utf8Encoder;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.module.IniDefinition;
import com.caucho.quercus.module.IniDefinitions;
import com.caucho.util.L10N;
import java.io.UnsupportedEncodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnicodeModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(UnicodeModule.class.getName());
    private static final L10N L = new L10N(UnicodeModule.class);
    public static final int U_INVALID_STOP = 0;
    public static final int U_INVALID_SKIP = 1;
    public static final int U_INVALID_SUBSTITUTE = 2;
    public static final int U_INVALID_ESCAPE = 3;
    public static final String ICONV_IMPL = "QuercusIconv";
    public static final String ICONV_VERSION = "1.0";
    public static final int ICONV_MIME_DECODE_STRICT = 1;
    public static final int ICONV_MIME_DECODE_CONTINUE_ON_ERROR = 2;
    private static final IniDefinitions _iniDefinitions = new IniDefinitions();
    static final IniDefinition INI_ICONV_INPUT_ENCODING = _iniDefinitions.add("iconv.input_encoding", "utf-8", 7);
    static final IniDefinition INI_ICONV_OUTPUT_ENCODING = _iniDefinitions.add("iconv.output_encoding", "utf-8", 7);
    static final IniDefinition INI_ICONV_INTERNAL_ENCODING = _iniDefinitions.add("iconv.internal_encoding", "utf-8", 7);

    @Override
    public String[] getLoadedExtensions() {
        return new String[]{"iconv"};
    }

    @Override
    public IniDefinitions getIniDefinitions() {
        return _iniDefinitions;
    }

    public static BooleanValue unicode_semantics(Env env) {
        return env.isUnicodeSemantics() ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    public static Value unicode_decode(Env env, BinaryValue str, String encoding, @Optional int errorMode) {
        try {
            Decoder decoder = Decoder.create(encoding);
            return decoder.decodeUnicode(str);
        }
        catch (UnsupportedCharsetException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(L.l("unsupported charset {0}", (Object)encoding));
            return BooleanValue.FALSE;
        }
    }

    public static Value unicode_encode(Env env, UnicodeValue str, String encoding, @Optional int errorMode) {
        try {
            Encoder encoder = Encoder.create(encoding);
            StringValue sb = env.createBinaryBuilder();
            return encoder.encode(sb, str);
        }
        catch (UnsupportedCharsetException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(L.l("unsupported charset {0}", (Object)encoding));
            return BooleanValue.FALSE;
        }
    }

    public static Value iconv_strpos(Env env, StringValue haystack, StringValue needle, @Optional(value="0") int offset, @Optional(value="") String charset) {
        if (charset.length() == 0) {
            charset = env.getIniString("iconv.internal_encoding");
        }
        try {
            Decoder decoder = Decoder.create(charset);
            StringValue haystackUnicode = decoder.decodeUnicode(haystack);
            decoder.reset();
            StringValue needleUnicode = decoder.decodeUnicode(needle);
            int index = haystackUnicode.indexOf(needleUnicode, offset);
            if (index < 0) {
                return BooleanValue.FALSE;
            }
            return LongValue.create(index);
        }
        catch (UnsupportedCharsetException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(L.l("unsupported charset {0}", (Object)charset));
            return BooleanValue.FALSE;
        }
    }

    public static Value iconv_strrpos(Env env, StringValue haystack, StringValue needle, @Optional(value="") String charset) {
        if (charset.length() == 0) {
            charset = env.getIniString("iconv.internal_encoding");
        }
        try {
            Decoder decoder = Decoder.create(charset);
            StringValue haystackUnicode = decoder.decodeUnicode(haystack);
            decoder.reset();
            StringValue needleUnicode = decoder.decodeUnicode(needle);
            int index = haystackUnicode.lastIndexOf(needleUnicode);
            if (index < 0) {
                return BooleanValue.FALSE;
            }
            return LongValue.create(index);
        }
        catch (UnsupportedCharsetException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(L.l("unsupported charset {0}", (Object)charset));
            return BooleanValue.FALSE;
        }
    }

    public static Value iconv_substr(Env env, StringValue str, int offset, @Optional(value="0x7fffffff") int length, @Optional(value="") String charset) {
        if (charset.length() == 0) {
            charset = env.getIniString("iconv.internal_encoding");
        }
        try {
            Decoder decoder = Decoder.create(charset);
            CharSequence unicodeStr = decoder.decode(env, str);
            if (decoder.hasError()) {
                log.log(Level.FINE, L.l("string has invalid {0} encoding", (Object)charset));
                env.notice(L.l("string has invalid {0} encoding", (Object)charset));
                return BooleanValue.FALSE;
            }
            int strlen = unicodeStr.length();
            int newOffset = offset;
            if (offset < 0) {
                newOffset = strlen + offset;
            }
            int tail = length < 0 ? (offset < 0 ? strlen : strlen + length) : (length > strlen - newOffset ? strlen : newOffset + length);
            if (newOffset < 0 || tail < newOffset) {
                return StringValue.EMPTY;
            }
            unicodeStr = unicodeStr.subSequence(newOffset, tail);
            Encoder encoder = Encoder.create(charset);
            StringValue sb = env.createBinaryBuilder();
            StringValue encodedStr = encoder.encode(sb, unicodeStr);
            return encodedStr;
        }
        catch (UnsupportedCharsetException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(L.l("unsupported charset {0}", (Object)charset));
            return BooleanValue.FALSE;
        }
    }

    public static Value iconv(Env env, String inCharset, String outCharset, StringValue str) {
        CharSequence unicodeStr;
        boolean isIgnoreErrors = false;
        if (inCharset.endsWith("//IGNORE")) {
            inCharset = inCharset.substring(0, inCharset.length() - 8);
        } else if (inCharset.endsWith("//TRANSLIT")) {
            inCharset = inCharset.substring(0, inCharset.length() - 10);
        }
        if (outCharset.endsWith("//IGNORE")) {
            isIgnoreErrors = true;
            outCharset = outCharset.substring(0, outCharset.length() - 8);
        } else if (outCharset.endsWith("//TRANSLIT")) {
            env.stub("Iconv TRANSLIT option not supported");
            outCharset = outCharset.substring(0, outCharset.length() - 10);
        }
        boolean isStartUtf8 = false;
        boolean isEndUtf8 = false;
        if (inCharset.equalsIgnoreCase("utf8") || inCharset.equalsIgnoreCase("utf-8")) {
            isStartUtf8 = true;
        }
        if (outCharset.equalsIgnoreCase("utf8") || outCharset.equalsIgnoreCase("utf-8")) {
            isEndUtf8 = true;
        }
        if (isStartUtf8 && isEndUtf8) {
            return UnicodeUtility.utf8Clean(env, str, null, isIgnoreErrors);
        }
        try {
            Decoder decoder = isStartUtf8 ? new Utf8Decoder(inCharset) : Decoder.create(inCharset);
            decoder.setIgnoreErrors(isIgnoreErrors);
            unicodeStr = decoder.decode(env, str);
        }
        catch (UnsupportedCharsetException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(L.l("unsupported input charset {0}", (Object)inCharset));
            return BooleanValue.FALSE;
        }
        try {
            Encoder encoder = isEndUtf8 ? new Utf8Encoder() : Encoder.create(outCharset);
            encoder.setIgnoreErrors(isIgnoreErrors);
            StringValue sb = env.createBinaryBuilder();
            return encoder.encode(sb, unicodeStr);
        }
        catch (UnsupportedCharsetException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(L.l("unsupported output charset {0}", (Object)outCharset));
            return BooleanValue.FALSE;
        }
    }

    public static StringValue ob_iconv_handler(StringValue contents, int status) {
        throw new UnimplementedException("ob_iconv_handler");
    }

    public static Value iconv_get_encoding(Env env, @Optional(value="all") String type) {
        if ("all".equals(type = type.toLowerCase(Locale.ENGLISH))) {
            ArrayValueImpl array = new ArrayValueImpl();
            array.put(env, "input_encoding", env.getIniString("iconv.input_encoding"));
            array.put(env, "output_encoding", env.getIniString("iconv.output_encoding"));
            array.put(env, "internal_encoding", env.getIniString("iconv.internal_encoding"));
            return array;
        }
        if ("input_encoding".equals(type)) {
            return env.createString(env.getIniString("iconv.input_encoding"));
        }
        if ("output_encoding".equals(type)) {
            return env.createString(env.getIniString("iconv.output_encoding"));
        }
        if ("internal_encoding".equals(type)) {
            return env.createString(env.getIniString("iconv.internal_encoding"));
        }
        return BooleanValue.FALSE;
    }

    public static BooleanValue iconv_set_encoding(Env env, String type, StringValue charset) {
        if ("input_encoding".equals(type = type.toLowerCase(Locale.ENGLISH))) {
            env.setIni("iconv.input_encoding", charset);
            return BooleanValue.TRUE;
        }
        if ("output_encoding".equals(type)) {
            env.setIni("iconv.output_encoding", charset);
            return BooleanValue.TRUE;
        }
        if ("internal_encoding".equals(type)) {
            env.setIni("iconv.internal_encoding", charset);
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    public static Value iconv_strlen(Env env, StringValue str, @Optional(value="") String charset) {
        if (charset.length() == 0) {
            charset = env.getIniString("iconv.internal_encoding");
        }
        try {
            Decoder decoder = Decoder.create(charset);
            CharSequence unicodeStr = decoder.decode(env, str);
            if (decoder.hasError()) {
                log.log(Level.FINE, L.l("string has invalid {0} encoding", (Object)charset));
                env.notice(L.l("string has invalid {0} encoding", (Object)charset));
                return BooleanValue.FALSE;
            }
            return LongValue.create(unicodeStr.length());
        }
        catch (UnsupportedCharsetException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(L.l("unsupported charset {0}", (Object)charset));
            return BooleanValue.FALSE;
        }
    }

    public static Value iconv_mime_encode(Env env, StringValue fieldName, StringValue fieldValue, @Optional ArrayValue preferences) {
        try {
            String inCharset;
            String scheme = "B";
            String lineBreakChars = "\r\n";
            String outCharset = inCharset = env.getIniString("iconv.internal_encoding");
            int lineLength = 76;
            if (preferences != null) {
                Value tmp = env.createString("scheme");
                if ((tmp = preferences.get(tmp)).isset()) {
                    scheme = tmp.toString();
                }
                tmp = env.createString("line-break-chars");
                if ((tmp = preferences.get(tmp)).isset()) {
                    lineBreakChars = tmp.toString();
                }
                tmp = env.createString("input-charset");
                if ((tmp = preferences.get(tmp)).isset()) {
                    inCharset = tmp.toString();
                }
                tmp = env.createString("output-charset");
                if ((tmp = preferences.get(tmp)).isset()) {
                    outCharset = tmp.toString();
                }
                tmp = env.createString("line-length");
                if ((tmp = preferences.get(tmp)).isset() && tmp.isLongConvertible()) {
                    lineLength = (int)tmp.toLong();
                }
            }
            return QuercusMimeUtility.encodeMime(env, fieldName, fieldValue, inCharset, outCharset, scheme, lineBreakChars, lineLength);
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e.getMessage());
            return BooleanValue.FALSE;
        }
    }

    public static Value iconv_mime_decode_headers(Env env, StringValue encoded_headers, @Optional int mode, @Optional String charset) {
        if (charset.length() == 0) {
            charset = env.getIniString("iconv.internal_encoding");
        }
        try {
            return QuercusMimeUtility.decodeMimeHeaders(env, encoded_headers, charset);
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e.getMessage());
        }
        catch (NoClassDefFoundError e) {
            throw new QuercusException(L.l("mime_decode requires javamail.jar"));
        }
        return BooleanValue.FALSE;
    }

    public static Value iconv_mime_decode(Env env, StringValue encodedHeader, @Optional(value="1") int mode, @Optional(value="") String charset) {
        if (charset.length() == 0) {
            charset = env.getIniString("iconv.internal_encoding");
        }
        try {
            return QuercusMimeUtility.decodeMime(env, encodedHeader, charset);
        }
        catch (UnsupportedEncodingException e) {
            env.warning(e);
            log.log(Level.FINE, e.getMessage(), e);
            return BooleanValue.FALSE;
        }
    }
}

