/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.image;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.ResourceValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.OptionsModule;
import com.caucho.util.IntQueue;
import com.caucho.util.LruCache;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.FlatteningPathIterator;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;

public class QuercusImage
extends ResourceValue {
    private static LruCache<StringValue, Font> _fontMap = new LruCache(1024);
    private static Font FONT_ZERO = new Font("sansserif", 0, 8);
    private static Font FONT_TWO = new Font("sansserif", 0, 10);
    private static Font FONT_THREE = new Font("sansserif", 0, 11);
    private static Font FONT_FOUR = new Font("sansserif", 0, 12);
    private static Font FONT_FIVE = new Font("sansserif", 0, 14);
    private BufferedImage _bufferedImage;
    private Graphics2D _graphics;
    private boolean _isInterlace;
    private BufferedImage _brush;
    private int[] _style;
    private int _thickness;
    private boolean _isToFill = false;
    private boolean _isBlankImage = false;

    public QuercusImage(int width, int height) {
        this._bufferedImage = new BufferedImage(width, height, 1);
        this._graphics = (Graphics2D)this._bufferedImage.getGraphics();
        this._isBlankImage = true;
    }

    public QuercusImage(InputStream inputStream) {
        try {
            this._bufferedImage = ImageIO.read(inputStream);
            this._graphics = (Graphics2D)this._bufferedImage.getGraphics();
        }
        catch (IOException e) {
            throw new QuercusException(e);
        }
    }

    public QuercusImage(Env env, Path filename) {
        try {
            this._bufferedImage = ImageIO.read(filename.openRead());
            this._graphics = (Graphics2D)this._bufferedImage.getGraphics();
        }
        catch (IOException e) {
            throw new QuercusException(e);
        }
    }

    public void setInterlace(boolean isInterlace) {
        this._isInterlace = isInterlace;
    }

    public boolean isInterlace() {
        return this._isInterlace;
    }

    public int getPixel(int x, int y) {
        return this._bufferedImage.getRGB(x, y) & 0xFFFFFF;
    }

    public void setPixel(int x, int y, int color) {
        this._isBlankImage = false;
        this._bufferedImage.setRGB(x, y, color);
    }

    public Graphics2D getGraphics() {
        return this._graphics;
    }

    public Font getFont(int fontIndex) {
        switch (fontIndex) {
            case 0: 
            case 1: {
                return FONT_ZERO;
            }
            case 2: {
                return FONT_TWO;
            }
            case 3: {
                return FONT_THREE;
            }
            case 4: {
                return FONT_FOUR;
            }
        }
        return FONT_FIVE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getTrueTypeFont(Env env, StringValue fontPath) throws FontFormatException, IOException {
        Font font = _fontMap.get(fontPath);
        if (font != null) {
            return font;
        }
        Path path = env.lookupPwd(fontPath);
        if (path.canRead()) {
            try (ReadStream is = path.openRead();){
                font = Font.createFont(0, is);
            }
            _fontMap.put(fontPath, font);
            return font;
        }
        if (fontPath.length() > 0 && fontPath.charAt(0) == '/') {
            return null;
        }
        StringValue gdFontPathKey = env.createString("GDFONTPATH");
        StringValue gdFontPath = OptionsModule.getenv(env, gdFontPathKey).toStringValue();
        int start = 0;
        int len = gdFontPath.length();
        while (start < len) {
            StringValue item;
            int i = gdFontPath.indexOf(':', start);
            if (i >= 0 && i + 1 < len && gdFontPath.charAt(i + 1) == ';') {
                item = gdFontPath.substring(start, i);
                path = env.lookupPwd(item);
                start = i + 2;
            } else {
                item = gdFontPath.substring(start);
                path = env.lookupPwd(item);
                start = len;
            }
            if (!path.canRead()) continue;
            try (ReadStream is = path.openRead();){
                font = Font.createFont(0, is);
            }
            _fontMap.put(fontPath, font);
            return font;
        }
        return null;
    }

    public BufferedImage getBufferedImage() {
        return this._bufferedImage;
    }

    public int getWidth() {
        return this._bufferedImage.getWidth();
    }

    public int getHeight() {
        return this._bufferedImage.getHeight();
    }

    public void fill(Shape shape, int color) {
        this._isBlankImage = false;
        this._graphics.setColor(QuercusImage.intToColor(color));
        this._graphics.fill(shape);
    }

    protected static Color intToColor(int argb) {
        int alpha = argb >> 24;
        alpha <<= 1;
        alpha |= (alpha & 2) >> 1;
        return new Color(argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb >> 0 & 0xFF, alpha);
    }

    public void stroke(Shape shape, int color) {
        this._isBlankImage = false;
        switch (color) {
            case -2: {
                this.strokeStyled(shape);
                break;
            }
            case -3: {
                this.strokeBrushed(shape);
                break;
            }
            default: {
                this._graphics.setColor(QuercusImage.intToColor(color));
                this._graphics.setStroke(new BasicStroke(this._thickness));
                this._graphics.draw(shape);
            }
        }
    }

    private void strokeStyled(Shape shape) {
        this._isBlankImage = false;
        for (int i = 0; i < this._style.length; ++i) {
            this._graphics.setColor(QuercusImage.intToColor(this._style[i]));
            BasicStroke stroke = new BasicStroke(this._thickness, 1, 1, 1.0f, new float[]{1.0f, this._style.length - 1}, i);
            this._graphics.setStroke(stroke);
            this._graphics.draw(shape);
        }
    }

    private void strokeBrushed(Shape shape) {
        this._isBlankImage = false;
        Graphics2D g = this._graphics;
        FlatteningPathIterator fpi = new FlatteningPathIterator(shape.getPathIterator(g.getTransform()), 1.0);
        float[] floats = new float[6];
        fpi.currentSegment(floats);
        float last_x = floats[0];
        float last_y = floats[1];
        while (!fpi.isDone()) {
            fpi.currentSegment(floats);
            int distance = (int)Math.sqrt((floats[0] - last_x) * (floats[0] - last_x) + (floats[1] - last_y) * (floats[1] - last_y));
            if (distance <= 1) {
                distance = 1;
            }
            for (int i = 1; i <= distance; ++i) {
                int x = (int)(floats[0] * (float)i + last_x * (float)(distance - i)) / distance;
                int y = (int)(floats[1] * (float)i + last_y * (float)(distance - i)) / distance;
                g.drawImage((Image)this._brush, x -= this._brush.getWidth() / 2, y -= this._brush.getHeight() / 2, null);
            }
            last_x = floats[0];
            last_y = floats[1];
            fpi.next();
        }
    }

    public void setThickness(int thickness) {
        this._style = null;
        this._thickness = thickness;
    }

    public void setStyle(Env env, ArrayValue colors) {
        this._style = new int[colors.getSize()];
        Iterator<Value> iter = colors.getValueIterator(env);
        for (int i = 0; i < this._style.length; ++i) {
            this._style[i] = iter.next().toInt();
        }
    }

    public void setBrush(QuercusImage image) {
        this._brush = image._bufferedImage;
    }

    public BufferedImage getBrush() {
        return this._brush;
    }

    public void setToFill(boolean isToFill) {
        this._isToFill = isToFill;
    }

    public long allocateColor(int r, int g, int b) {
        int color = 0x7F000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
        if (this._isToFill) {
            this._isToFill = false;
            this.flood(0, 0, color);
        }
        return color;
    }

    public void flood(int x, int y, int color) {
        this.flood(x, y, color, 0, false);
    }

    public void flood(int x, int y, int color, int border) {
        this.flood(x, y, color, border, true);
    }

    private void floodBlankImage(int color) {
        int width = this.getWidth();
        int height = this.getHeight();
        color &= 0xFFFFFF;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                this.setPixel(i, j, color);
            }
        }
    }

    private void flood(int startX, int startY, int color, int border, boolean isUseBorder) {
        boolean isBlank = this._isBlankImage;
        if (isBlank) {
            this.floodBlankImage(color);
            return;
        }
        this._isBlankImage = false;
        IntQueue q = new IntQueue();
        q.add(startX);
        q.add(startY);
        color &= 0xFFFFFF;
        border &= 0xFFFFFF;
        int width = this.getWidth();
        int height = this.getHeight();
        int startColor = this.getPixel(startX, startX) & 0xFFFFFF;
        while (q.size() > 0) {
            int x = q.remove();
            int y = q.remove();
            int p = this.getPixel(x, y) & 0xFFFFFF;
            if (isUseBorder && (p == border || p == color) || !isUseBorder && p != startColor || p == color) continue;
            this.setPixel(x, y, color);
            if (y - 1 >= 0) {
                this.addPointIfValid(q, x, y - 1, color, border, startColor, isUseBorder);
            }
            if (y + 1 < height) {
                this.addPointIfValid(q, x, y + 1, color, border, startColor, isUseBorder);
            }
            if (x - 1 >= 0) {
                if (y - 1 >= 0) {
                    this.addPointIfValid(q, x - 1, y - 1, color, border, startColor, isUseBorder);
                }
                this.addPointIfValid(q, x - 1, y, color, border, startColor, isUseBorder);
                if (y + 1 < height) {
                    this.addPointIfValid(q, x - 1, y + 1, color, border, startColor, isUseBorder);
                }
            }
            if (x + 1 >= width) continue;
            if (y - 1 >= 0) {
                this.addPointIfValid(q, x + 1, y - 1, color, border, startColor, isUseBorder);
            }
            this.addPointIfValid(q, x + 1, y, color, border, startColor, isUseBorder);
            if (y + 1 >= height) continue;
            this.addPointIfValid(q, x + 1, y + 1, color, border, startColor, isUseBorder);
        }
    }

    private void addPointIfValid(IntQueue queue, int x, int y, int fillColor, int borderColor, int startColor, boolean isUseBorder) {
        int pixel = this.getPixel(x, y) & 0xFFFFFF;
        if ((!isUseBorder || pixel != borderColor && pixel != fillColor) && (isUseBorder || pixel == startColor)) {
            queue.add(x);
            queue.add(y);
        }
    }
}

