/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.jms;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.ClassImplementation;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.jms.JMSQueue;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.module.IniDefinition;
import com.caucho.quercus.module.IniDefinitions;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.naming.Context;
import javax.naming.InitialContext;

@ClassImplementation
public class JMSModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(JMSModule.class.getName());
    private static final L10N L = new L10N(JMSModule.class);
    private static final IniDefinitions _iniDefinitions = new IniDefinitions();
    static final IniDefinition INI_JMS_CONNECTION_FACTORY = _iniDefinitions.add("jms.connection_factory", "jms/ConnectionFactory", 4);

    @Override
    public IniDefinitions getIniDefinitions() {
        return _iniDefinitions;
    }

    static JMSQueue message_get_queue(Env env, String queueName, ConnectionFactory connectionFactory) {
        if (connectionFactory == null) {
            connectionFactory = JMSModule.getConnectionFactory(env);
        }
        if (connectionFactory == null) {
            env.warning(L.l("No connection factory"));
            return null;
        }
        try {
            Destination queue = null;
            if (queueName != null && !queueName.equals("")) {
                queue = (Destination)new InitialContext().lookup("java:comp/env/" + queueName);
            }
            return new JMSQueue(connectionFactory, queue);
        }
        catch (Exception e) {
            env.warning(e);
            return null;
        }
    }

    private static ConnectionFactory getConnectionFactory(Env env) {
        StringValue factoryName = env.getIni("jms.connection_factory");
        if (factoryName == null) {
            log.fine("jms.connection_factory not set");
        }
        try {
            Context context = (Context)new InitialContext().lookup("java:comp/env");
            ConnectionFactory connectionFactory = (ConnectionFactory)context.lookup(factoryName.toString());
            if (connectionFactory == null) {
                log.warning("Couldn't find factory " + factoryName.toString());
            }
            return connectionFactory;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QuercusModuleException(e);
        }
    }
}

